/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.datamodel;

import com.bc.ceres.core.Assert;

public class RGBChannelDef
implements Cloneable {
    private static final int R = 0;
    private static final int G = 1;
    private static final int B = 2;
    private static final int A = 3;
    private ChannelDef[] channelDefs = new ChannelDef[]{new ChannelDef(), new ChannelDef(), new ChannelDef(), new ChannelDef()};

    public RGBChannelDef() {
    }

    public RGBChannelDef(String[] bandNames) {
        this();
        this.setSourceNames(bandNames);
    }

    public String getSourceName(int index) {
        return this.channelDefs[index].sourceName;
    }

    public void setSourceName(int index, String sourceName) {
        Assert.notNull((Object)sourceName, (String)"sourceName");
        this.channelDefs[index].sourceName = sourceName;
    }

    public String[] getSourceNames() {
        if (this.isAlphaUsed()) {
            return new String[]{this.getSourceName(0), this.getSourceName(1), this.getSourceName(2), this.getSourceName(3)};
        }
        return new String[]{this.getSourceName(0), this.getSourceName(1), this.getSourceName(2)};
    }

    public void setSourceNames(String[] bandNames) {
        Assert.notNull((Object)bandNames, (String)"bandNames");
        this.setSourceName(0, bandNames[0]);
        this.setSourceName(1, bandNames[1]);
        this.setSourceName(2, bandNames[2]);
        this.setSourceName(3, bandNames.length > 3 ? bandNames[3] : "");
    }

    public boolean isAlphaUsed() {
        return !"".equals(this.getSourceName(3));
    }

    public boolean isGammaUsed(int index) {
        double gamma = this.getGamma(index);
        double v = gamma - 1.0;
        return Math.abs(v) > 1.0E-5;
    }

    public double getGamma(int index) {
        return this.channelDefs[index].gamma;
    }

    public void setGamma(int index, double gamma) {
        Assert.argument((gamma >= 0.0 ? 1 : 0) != 0, (String)"gamma");
        this.channelDefs[index].gamma = gamma;
    }

    public double getMinDisplaySample(int index) {
        return this.channelDefs[index].minDisplaySample;
    }

    public void setMinDisplaySample(int index, double min) {
        this.channelDefs[index].minDisplaySample = min;
    }

    public double getMaxDisplaySample(int index) {
        return this.channelDefs[index].maxDisplaySample;
    }

    public void setMaxDisplaySample(int index, double max) {
        this.channelDefs[index].maxDisplaySample = max;
    }

    public final Object clone() {
        try {
            RGBChannelDef copy = (RGBChannelDef)super.clone();
            copy.channelDefs = (ChannelDef[])this.channelDefs.clone();
            for (int i = 0; i < this.channelDefs.length; ++i) {
                copy.channelDefs[i] = (ChannelDef)this.channelDefs[i].clone();
            }
            return copy;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    private static class ChannelDef
    implements Cloneable {
        private String sourceName;
        private double minDisplaySample;
        private double maxDisplaySample;
        private double gamma;

        private ChannelDef() {
            this("", 0.0, 1.0, 1.0);
        }

        private ChannelDef(String sourceName, double minDisplaySample, double maxDisplaySample, double gamma) {
            this.sourceName = sourceName;
            this.gamma = gamma;
            this.minDisplaySample = minDisplaySample;
            this.maxDisplaySample = maxDisplaySample;
        }

        public final Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

