/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.datamodel;

import com.bc.ceres.core.Assert;
import com.bc.ceres.core.CoreException;
import com.bc.ceres.core.runtime.ConfigurableExtension;
import com.bc.ceres.core.runtime.ConfigurationElement;
import com.bc.jexp.Parser;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.Properties;
import org.esa.beam.framework.datamodel.Band;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.datamodel.VirtualBand;
import org.esa.beam.util.Guardian;
import org.esa.beam.util.io.FileUtils;

public class RGBImageProfile
implements ConfigurableExtension {
    public static final String RED_BAND_NAME = "virtual_red";
    public static final String GREEN_BAND_NAME = "virtual_green";
    public static final String BLUE_BAND_NAME = "virtual_blue";
    public static final String ALPHA_BAND_NAME = "virtual_alpha";
    public static final String[] RGB_BAND_NAMES = new String[]{"virtual_red", "virtual_green", "virtual_blue"};
    public static final String[] RGBA_BAND_NAMES = new String[]{"virtual_red", "virtual_green", "virtual_blue", "virtual_alpha"};
    public static final String FILENAME_EXTENSION = ".rgb";
    public static final String PROPERTY_KEY_NAME = "name";
    public static final String PROPERTY_KEY_RED = "red";
    public static final String PROPERTY_KEY_GREEN = "green";
    public static final String PROPERTY_KEY_BLUE = "blue";
    public static final String PROPERTY_KEY_ALPHA = "alpha";
    public static final String PROPERTY_KEY_INTERNAL = "internal";
    public static final String PROPERTY_KEY_PREFIX_RGB_PROFILE = "rgbProfile";
    private static final int R = 0;
    private static final int G = 1;
    private static final int B = 2;
    private static final int A = 3;
    private String name;
    private boolean internal;
    private String[] rgbaExpressions;
    private String[] pattern;

    public RGBImageProfile() {
        this("");
    }

    public RGBImageProfile(String name) {
        this(name, new String[]{"", "", ""}, null);
    }

    public RGBImageProfile(String name, String[] rgbaExpressions) {
        this(name, rgbaExpressions, null);
    }

    public RGBImageProfile(String name, String[] rgbaExpressions, String[] pattern) {
        Assert.argument((name != null ? 1 : 0) != 0, (String)"name != null");
        Assert.argument((rgbaExpressions != null ? 1 : 0) != 0, (String)"rgbaExpressions != null");
        Assert.argument((rgbaExpressions.length == 3 || rgbaExpressions.length == 4 ? 1 : 0) != 0, (String)"rgbaExpressions.length == 3 || rgbaExpressions.length == 4");
        if (pattern != null) {
            Assert.argument((pattern.length == 3 ? 1 : 0) != 0, (String)"pattern.length == 3");
        }
        this.name = name;
        this.rgbaExpressions = new String[4];
        this.rgbaExpressions[0] = rgbaExpressions[0];
        this.rgbaExpressions[1] = rgbaExpressions[1];
        this.rgbaExpressions[2] = rgbaExpressions[2];
        this.rgbaExpressions[3] = rgbaExpressions.length == 4 ? rgbaExpressions[3] : "";
        this.pattern = pattern;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isInternal() {
        return this.internal;
    }

    public void setInternal(boolean internal) {
        this.internal = internal;
    }

    public boolean equalExpressions(RGBImageProfile profile) {
        return this.equalExpressions(profile.rgbaExpressions);
    }

    public boolean equalExpressions(String[] rgbaExpressions) {
        for (int i = 0; i < this.rgbaExpressions.length; ++i) {
            if (this.rgbaExpressions[i].equals(rgbaExpressions[i])) continue;
            return false;
        }
        return true;
    }

    public boolean isValid() {
        return !this.getRedExpression().equals("") || !this.getGreenExpression().equals("") || !this.getBlueExpression().equals("");
    }

    public String[] getRgbExpressions() {
        String[] copy = new String[this.rgbaExpressions.length - 1];
        copy[0] = this.rgbaExpressions[0];
        copy[1] = this.rgbaExpressions[1];
        copy[2] = this.rgbaExpressions[2];
        return copy;
    }

    public void setRgbExpressions(String[] rgbExpressions) {
        this.rgbaExpressions[0] = rgbExpressions[0];
        this.rgbaExpressions[1] = rgbExpressions[1];
        this.rgbaExpressions[2] = rgbExpressions[2];
    }

    public String[] getRgbaExpressions() {
        return (String[])this.rgbaExpressions.clone();
    }

    public void setRgbaExpressions(String[] rgbaExpressions) {
        this.rgbaExpressions[0] = rgbaExpressions[0];
        this.rgbaExpressions[1] = rgbaExpressions[1];
        this.rgbaExpressions[2] = rgbaExpressions[2];
        this.rgbaExpressions[3] = rgbaExpressions[3];
    }

    public String getRedExpression() {
        return this.rgbaExpressions[0];
    }

    public void setRedExpression(String expression) {
        this.rgbaExpressions[0] = RGBImageProfile.checkAndTrimExpressionArgument(expression);
    }

    public String getGreenExpression() {
        return this.rgbaExpressions[1];
    }

    public void setGreenExpression(String expression) {
        this.rgbaExpressions[1] = RGBImageProfile.checkAndTrimExpressionArgument(expression);
    }

    public String getBlueExpression() {
        return this.rgbaExpressions[2];
    }

    public void setBlueExpression(String expression) {
        this.rgbaExpressions[2] = RGBImageProfile.checkAndTrimExpressionArgument(expression);
    }

    public String getAlphaExpression() {
        return this.rgbaExpressions[3];
    }

    public void setAlphaExpression(String expression) {
        this.rgbaExpressions[3] = RGBImageProfile.checkAndTrimExpressionArgument(expression);
    }

    public boolean hasAlpha() {
        return !this.getAlphaExpression().equals("");
    }

    public String[] getPattern() {
        return this.pattern;
    }

    public void setPattern(String[] pattern) {
        this.pattern = pattern;
    }

    public boolean isApplicableTo(Product product) {
        String[] expressions;
        Guardian.assertNotNull("product", (Object)product);
        if (!this.isValid()) {
            return false;
        }
        Parser parser = product.createBandArithmeticParser();
        for (String expression : expressions = this.getRgbExpressions()) {
            if (expression.equals("") || product.isCompatibleBandArithmeticExpression(expression, parser)) continue;
            return false;
        }
        return true;
    }

    public static RGBImageProfile getCurrentProfile(Product product) {
        RGBImageProfile profile = new RGBImageProfile("Current Profile");
        String[] rgbaExpressions = new String[]{"", "", "", ""};
        String[] rBandNames = new String[]{RED_BAND_NAME, PROPERTY_KEY_RED, "r"};
        String[] gBandNames = new String[]{GREEN_BAND_NAME, PROPERTY_KEY_GREEN, "g"};
        String[] bBandNames = new String[]{BLUE_BAND_NAME, PROPERTY_KEY_BLUE, "b"};
        String[] aBandNames = new String[]{ALPHA_BAND_NAME, PROPERTY_KEY_ALPHA, "a"};
        String[][] allBandNames = new String[][]{rBandNames, gBandNames, bBandNames, aBandNames};
        for (int i = 0; i < allBandNames.length; ++i) {
            String[] names;
            for (String currentBandName : names = allBandNames[i]) {
                Band band;
                if (!rgbaExpressions[i].equals("") || (band = product.getBand(currentBandName)) == null) continue;
                rgbaExpressions[i] = band instanceof VirtualBand ? ((VirtualBand)band).getExpression() : band.getName();
            }
        }
        profile.setRgbExpressions(rgbaExpressions);
        return profile;
    }

    public static RGBImageProfile loadProfile(File file) throws IOException {
        Properties properties = new Properties();
        try (FileInputStream inStream = new FileInputStream(file);){
            properties.load(inStream);
        }
        String defaultName = FileUtils.getFilenameWithoutExtension(file);
        RGBImageProfile profile = new RGBImageProfile(defaultName);
        profile.setProperties(properties);
        return profile;
    }

    public static RGBImageProfile loadProfile(URL url) throws IOException {
        Properties properties = new Properties();
        try (InputStream inStream = url.openStream();){
            properties.load(inStream);
        }
        String urlExtForm = url.toExternalForm();
        int lastPathSeperatorIndex = urlExtForm.lastIndexOf(47);
        int extensionDotIndex = urlExtForm.lastIndexOf(46);
        String defaultName = urlExtForm.substring(lastPathSeperatorIndex + 1, extensionDotIndex);
        RGBImageProfile profile = new RGBImageProfile(defaultName);
        profile.setProperties(properties);
        return profile;
    }

    public void store(File file) throws IOException {
        try (FileOutputStream outStream = new FileOutputStream(file);){
            Properties properties = new Properties();
            this.getProperties(properties);
            properties.store(outStream, "RGB-Image Profile");
        }
    }

    public void getProperties(Properties properties) {
        properties.put(PROPERTY_KEY_RED, this.getRedExpression());
        properties.put(PROPERTY_KEY_GREEN, this.getGreenExpression());
        properties.put(PROPERTY_KEY_BLUE, this.getBlueExpression());
        if (!this.getAlphaExpression().equals("")) {
            properties.put(PROPERTY_KEY_ALPHA, this.getAlphaExpression());
        } else {
            properties.remove(PROPERTY_KEY_ALPHA);
        }
        properties.put(PROPERTY_KEY_NAME, this.getName());
        if (this.isInternal()) {
            properties.put(PROPERTY_KEY_INTERNAL, this.isInternal() ? "true" : "false");
        } else {
            properties.remove(PROPERTY_KEY_INTERNAL);
        }
    }

    public void setProperties(Properties properties) {
        String name = properties.getProperty(PROPERTY_KEY_NAME);
        String[] rgbaExpressions = new String[]{RGBImageProfile.getProperty(properties, new String[]{PROPERTY_KEY_RED, "r"}, ""), RGBImageProfile.getProperty(properties, new String[]{PROPERTY_KEY_GREEN, "g"}, ""), RGBImageProfile.getProperty(properties, new String[]{PROPERTY_KEY_BLUE, "b"}, ""), RGBImageProfile.getProperty(properties, new String[]{PROPERTY_KEY_ALPHA, "a"}, "")};
        boolean internal = Boolean.parseBoolean(properties.getProperty(PROPERTY_KEY_INTERNAL, "false"));
        if (name != null) {
            this.setName(name);
        }
        this.setInternal(internal);
        this.setRgbaExpressions(rgbaExpressions);
    }

    public static void storeRgbaExpressions(Product product, String[] rgbaExpressions) {
        RGBImageProfile.storeRgbaExpressions(product, rgbaExpressions, RGBA_BAND_NAMES);
    }

    public static void storeRgbaExpressions(Product product, String[] rgbaExpressions, String[] bandNames) {
        for (int i = 0; i < bandNames.length; ++i) {
            boolean alphaChannel;
            String rgbBandName = bandNames[i];
            String rgbaExpression = rgbaExpressions[i];
            Band rgbBand = product.getBand(rgbBandName);
            boolean expressionIsEmpty = rgbaExpression.equals("");
            boolean bl = alphaChannel = i == 3;
            if (rgbBand != null) {
                if (rgbBand instanceof VirtualBand) {
                    VirtualBand virtualBand = (VirtualBand)rgbBand;
                    virtualBand.setExpression(rgbaExpression);
                    continue;
                }
                product.removeBand(rgbBand);
                product.addBand(new VirtualBand(rgbBandName, 30, product.getSceneRasterWidth(), product.getSceneRasterHeight(), expressionIsEmpty ? "0" : rgbaExpression));
                continue;
            }
            if (alphaChannel && expressionIsEmpty) continue;
            product.addBand(new VirtualBand(rgbBandName, 30, product.getSceneRasterWidth(), product.getSceneRasterHeight(), expressionIsEmpty ? "0" : rgbaExpression));
        }
    }

    public int hashCode() {
        return this.getRedExpression().hashCode() + this.getGreenExpression().hashCode() + this.getBlueExpression().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof RGBImageProfile) {
            RGBImageProfile profile = (RGBImageProfile)obj;
            return this.getName().equals(profile.getName()) && this.equalExpressions(profile) && Arrays.equals(this.getPattern(), profile.getPattern());
        }
        return false;
    }

    public String toString() {
        return this.getClass().getName() + "[" + "name=" + this.name + ", " + "r=" + this.rgbaExpressions[0] + ", " + "g=" + this.rgbaExpressions[1] + ", " + "b=" + this.rgbaExpressions[2] + ", " + "a=" + this.rgbaExpressions[3] + "]";
    }

    private static String checkAndTrimExpressionArgument(String expression) {
        if (expression == null) {
            throw new IllegalArgumentException("expression is null");
        }
        return expression.trim();
    }

    private static String getProperty(Properties properties, String[] keys, String defaultValue) {
        String key;
        String value = null;
        String[] stringArray = keys;
        int n = stringArray.length;
        for (int i = 0; i < n && (value = properties.getProperty(key = stringArray[i])) == null; ++i) {
        }
        return value != null ? value : defaultValue;
    }

    public void configure(ConfigurationElement config) throws CoreException {
        this.name = RGBImageProfile.getChildValue(config, PROPERTY_KEY_NAME);
        this.internal = true;
        this.rgbaExpressions[0] = RGBImageProfile.getChildValue(config, PROPERTY_KEY_RED);
        this.rgbaExpressions[1] = RGBImageProfile.getChildValue(config, PROPERTY_KEY_GREEN);
        this.rgbaExpressions[2] = RGBImageProfile.getChildValue(config, PROPERTY_KEY_BLUE);
        ConfigurationElement child = (ConfigurationElement)config.getChild(PROPERTY_KEY_ALPHA);
        String alpha = null;
        if (child != null) {
            alpha = child.getValue();
        }
        if (alpha == null) {
            alpha = "";
        }
        this.rgbaExpressions[3] = alpha;
        ConfigurationElement patternConfig = (ConfigurationElement)config.getChild("pattern");
        if (patternConfig != null) {
            this.pattern = new String[3];
            ConfigurationElement productType = (ConfigurationElement)patternConfig.getChild("productType");
            ConfigurationElement productName = (ConfigurationElement)patternConfig.getChild("productName");
            ConfigurationElement productDesc = (ConfigurationElement)patternConfig.getChild("productDesc");
            if (productType != null) {
                this.pattern[0] = productType.getValue();
            }
            if (productName != null) {
                this.pattern[1] = productName.getValue();
            }
            if (productDesc != null) {
                this.pattern[2] = productDesc.getValue();
            }
        }
    }

    private static String getChildValue(ConfigurationElement config, String childName) throws CoreException {
        ConfigurationElement child = (ConfigurationElement)config.getChild(childName);
        if (child != null) {
            return child.getValue();
        }
        throw new CoreException("Configuration element [" + childName + "] does not exist");
    }
}

