/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.datamodel;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.esa.beam.framework.datamodel.RGBImageProfile;
import org.esa.beam.util.SystemUtils;
import org.esa.beam.util.logging.BeamLogManager;

public class RGBImageProfileManager {
    private final List<RGBImageProfile> _profiles = new ArrayList<RGBImageProfile>();
    private static final File profilesDir = new File(SystemUtils.getApplicationDataDir(), "beam-core/auxdata/rgb_profiles");

    private RGBImageProfileManager() {
        this.loadDefaultProfiles();
    }

    public static File getProfilesDir() {
        return profilesDir;
    }

    public static RGBImageProfileManager getInstance() {
        return Holder.instance;
    }

    public void addProfile(RGBImageProfile profile) {
        if (profile != null && !this._profiles.contains(profile)) {
            this._profiles.add(profile);
        }
    }

    public void removeProfile(RGBImageProfile profile) {
        if (profile != null) {
            this._profiles.remove(profile);
        }
    }

    public int getProfileCount() {
        return this._profiles.size();
    }

    public RGBImageProfile getProfile(int i) {
        return this._profiles.get(i);
    }

    public RGBImageProfile[] getAllProfiles() {
        return this._profiles.toArray(new RGBImageProfile[this._profiles.size()]);
    }

    private void loadDefaultProfiles() {
        File[] files;
        if (!RGBImageProfileManager.getProfilesDir().exists()) {
            profilesDir.mkdirs();
            BeamLogManager.getSystemLogger().log(Level.INFO, "Directory for RGB-image profiles not found: " + RGBImageProfileManager.getProfilesDir());
        }
        if ((files = RGBImageProfileManager.getProfilesDir().listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".rgb") || name.endsWith(".rgb".toUpperCase());
            }
        })) != null) {
            for (File file : files) {
                try {
                    this.addProfile(RGBImageProfile.loadProfile(file));
                }
                catch (IOException e) {
                    BeamLogManager.getSystemLogger().log(Level.SEVERE, "Failed to load RGB-image profile from " + file, e);
                }
            }
        } else {
            BeamLogManager.getSystemLogger().log(Level.INFO, "No RGB-image profiles found in " + RGBImageProfileManager.getProfilesDir());
        }
    }

    static {
        if (!profilesDir.exists()) {
            profilesDir.mkdirs();
        }
    }

    private static class Holder {
        private static final RGBImageProfileManager instance = new RGBImageProfileManager();

        private Holder() {
        }
    }
}

