/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.datamodel;

import com.bc.ceres.core.ProgressMonitor;
import com.bc.ceres.core.SubProgressMonitor;
import com.bc.ceres.glevel.MultiLevelImage;
import com.bc.ceres.glevel.MultiLevelModel;
import com.bc.ceres.glevel.MultiLevelSource;
import com.bc.ceres.glevel.support.DefaultMultiLevelImage;
import com.bc.ceres.glevel.support.DefaultMultiLevelSource;
import com.bc.ceres.glevel.support.GenericMultiLevelSource;
import com.bc.ceres.jai.operator.InterpretationType;
import com.bc.ceres.jai.operator.ReinterpretDescriptor;
import com.bc.ceres.jai.operator.ScalingType;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.media.jai.ImageLayout;
import javax.media.jai.JAI;
import javax.media.jai.ROI;
import org.esa.beam.framework.datamodel.ColorPaletteDef;
import org.esa.beam.framework.datamodel.DataNode;
import org.esa.beam.framework.datamodel.GeoCoding;
import org.esa.beam.framework.datamodel.ImageInfo;
import org.esa.beam.framework.datamodel.Mask;
import org.esa.beam.framework.datamodel.Pointing;
import org.esa.beam.framework.datamodel.PointingFactory;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.datamodel.ProductData;
import org.esa.beam.framework.datamodel.ProductNodeGroup;
import org.esa.beam.framework.datamodel.ProductVisitor;
import org.esa.beam.framework.datamodel.Scaling;
import org.esa.beam.framework.datamodel.Stx;
import org.esa.beam.framework.datamodel.StxFactory;
import org.esa.beam.framework.datamodel.TransectProfileData;
import org.esa.beam.framework.datamodel.TransectProfileDataBuilder;
import org.esa.beam.framework.dataop.barithm.BandArithmetic;
import org.esa.beam.jai.ImageManager;
import org.esa.beam.util.BitRaster;
import org.esa.beam.util.Debug;
import org.esa.beam.util.ObjectUtils;
import org.esa.beam.util.ProductUtils;
import org.esa.beam.util.StringUtils;
import org.esa.beam.util.SystemUtils;
import org.esa.beam.util.jai.SingleBandedSampleModel;
import org.esa.beam.util.math.DoubleList;
import org.esa.beam.util.math.Histogram;
import org.esa.beam.util.math.IndexValidator;
import org.esa.beam.util.math.MathUtils;
import org.esa.beam.util.math.Quantizer;
import org.esa.beam.util.math.Range;

public abstract class RasterDataNode
extends DataNode
implements Scaling {
    public static final String PROPERTY_NAME_IMAGE_INFO = "imageInfo";
    public static final String PROPERTY_NAME_LOG_10_SCALED = "log10Scaled";
    @Deprecated
    public static final String PROPERTY_NAME_ROI_DEFINITION = "roiDefinition";
    public static final String PROPERTY_NAME_SCALING_FACTOR = "scalingFactor";
    public static final String PROPERTY_NAME_SCALING_OFFSET = "scalingOffset";
    public static final String PROPERTY_NAME_NO_DATA_VALUE = "noDataValue";
    public static final String PROPERTY_NAME_NO_DATA_VALUE_USED = "noDataValueUsed";
    public static final String PROPERTY_NAME_VALID_PIXEL_EXPRESSION = "validPixelExpression";
    public static final String PROPERTY_NAME_GEOCODING = "geoCoding";
    public static final String PROPERTY_NAME_STX = "stx";
    public static final String PROPERTY_NAME_ANCILLARY_BANDS = "ancillaryBands";
    public static final String NO_DATA_TEXT = "NaN";
    public static final String INVALID_POS_TEXT = "Invalid pos.";
    public static final String IO_ERROR_TEXT = "I/O error";
    private final int rasterWidth;
    private final int rasterHeight;
    private double scalingFactor;
    private double scalingOffset;
    private boolean log10Scaled;
    private boolean scalingApplied;
    private boolean noDataValueUsed;
    private ProductData noData;
    private double geophysicalNoDataValue;
    private String validPixelExpression;
    private GeoCoding geoCoding;
    private Stx stx;
    private ImageInfo imageInfo;
    private final ProductNodeGroup<Mask> overlayMasks;
    @Deprecated
    private final ProductNodeGroup<Mask> roiMasks;
    private static final int READ_BUFFER_MAX_SIZE = 0x800000;
    private Pointing pointing;
    private MultiLevelImage sourceImage;
    private MultiLevelImage geophysicalImage;
    private MultiLevelImage validMaskImage;
    private ROI validMaskROI;
    private Map<String, RasterDataNode> ancillaryBands = new HashMap<String, RasterDataNode>();

    protected RasterDataNode(String name, int dataType, int width, int height) {
        super(name, dataType, (long)width * (long)height);
        if (dataType != 10 && dataType != 11 && dataType != 12 && dataType != 20 && dataType != 21 && dataType != 22 && dataType != 30 && dataType != 31) {
            throw new IllegalArgumentException("dataType is invalid");
        }
        this.rasterWidth = width;
        this.rasterHeight = height;
        this.scalingFactor = 1.0;
        this.scalingOffset = 0.0;
        this.log10Scaled = false;
        this.scalingApplied = false;
        this.noData = null;
        this.noDataValueUsed = false;
        this.geophysicalNoDataValue = 0.0;
        this.validPixelExpression = null;
        this.overlayMasks = new ProductNodeGroup(this, "overlayMasks", false);
        this.roiMasks = new ProductNodeGroup(this, "roiMasks", false);
    }

    public Map<String, RasterDataNode> getAncillaryBands() {
        if (this.ancillaryBands.isEmpty()) {
            return Collections.emptyMap();
        }
        return new HashMap<String, RasterDataNode>(this.ancillaryBands);
    }

    public RasterDataNode getAncillaryBand(String roleName) {
        return this.ancillaryBands.get(roleName);
    }

    public void setAncillaryBand(String roleName, RasterDataNode band) {
        RasterDataNode oldBand = this.ancillaryBands.get(roleName);
        if (band != null) {
            this.ancillaryBands.put(roleName, band);
        } else {
            this.ancillaryBands.remove(roleName);
        }
        RasterDataNode newBand = this.ancillaryBands.get(roleName);
        if (oldBand != newBand) {
            this.fireProductNodeChanged(PROPERTY_NAME_ANCILLARY_BANDS, this.ancillaryBands, this.ancillaryBands);
        }
    }

    public int getSceneRasterWidth() {
        return this.getRasterWidth();
    }

    public int getSceneRasterHeight() {
        return this.getRasterHeight();
    }

    public final int getRasterWidth() {
        return this.rasterWidth;
    }

    public final int getRasterHeight() {
        return this.rasterHeight;
    }

    @Override
    public void setModified(boolean modified) {
        boolean oldState = this.isModified();
        if (oldState != modified) {
            if (!modified && this.overlayMasks != null) {
                this.overlayMasks.setModified(false);
            }
            if (!modified) {
                this.roiMasks.setModified(false);
            }
            super.setModified(modified);
        }
    }

    public GeoCoding getGeoCoding() {
        Product product;
        if (this.geoCoding == null && (product = this.getProduct()) != null) {
            return product.getGeoCoding();
        }
        return this.geoCoding;
    }

    public void setGeoCoding(GeoCoding geoCoding) {
        if (!ObjectUtils.equalObjects(geoCoding, this.geoCoding)) {
            Product product;
            this.geoCoding = geoCoding;
            if (this.geoCoding != null && (product = this.getProduct()) != null && product.getGeoCoding() == null) {
                product.setGeoCoding(this.geoCoding);
            }
            this.fireProductNodeChanged(PROPERTY_NAME_GEOCODING);
        }
    }

    protected Pointing createPointing() {
        if (this.getGeoCoding() == null || this.getProduct() == null) {
            return null;
        }
        PointingFactory factory = this.getProduct().getPointingFactory();
        if (factory == null) {
            return null;
        }
        return factory.createPointing(this);
    }

    public Pointing getPointing() {
        if (this.pointing == null || this.pointing.getGeoCoding() == this.getGeoCoding()) {
            this.pointing = this.createPointing();
        }
        return this.pointing;
    }

    public boolean canBeOrthorectified() {
        Pointing pointing = this.getPointing();
        return pointing != null && pointing.canGetViewDir();
    }

    @Override
    public boolean isFloatingPointType() {
        return this.scalingApplied || super.isFloatingPointType();
    }

    public int getGeophysicalDataType() {
        return ImageManager.getProductDataType(ReinterpretDescriptor.getTargetDataType((int)ImageManager.getDataBufferType(this.getDataType()), (double)this.getScalingFactor(), (double)this.getScalingOffset(), (ScalingType)this.getScalingType(), (InterpretationType)this.getInterpretationType()));
    }

    public final double getScalingFactor() {
        return this.scalingFactor;
    }

    public final void setScalingFactor(double scalingFactor) {
        if (this.scalingFactor != scalingFactor) {
            this.scalingFactor = scalingFactor;
            this.setScalingApplied();
            this.resetGeophysicalImage();
            this.fireProductNodeChanged(PROPERTY_NAME_SCALING_FACTOR);
            this.setGeophysicalNoDataValue();
            this.resetValidMask();
            this.setModified(true);
        }
    }

    public final double getScalingOffset() {
        return this.scalingOffset;
    }

    public final void setScalingOffset(double scalingOffset) {
        if (this.scalingOffset != scalingOffset) {
            this.scalingOffset = scalingOffset;
            this.setScalingApplied();
            this.resetGeophysicalImage();
            this.fireProductNodeChanged(PROPERTY_NAME_SCALING_OFFSET);
            this.setGeophysicalNoDataValue();
            this.resetValidMask();
            this.setModified(true);
        }
    }

    public final boolean isLog10Scaled() {
        return this.log10Scaled;
    }

    public final void setLog10Scaled(boolean log10Scaled) {
        if (this.log10Scaled != log10Scaled) {
            this.log10Scaled = log10Scaled;
            this.setScalingApplied();
            this.resetGeophysicalImage();
            this.setGeophysicalNoDataValue();
            this.resetValidMask();
            this.fireProductNodeChanged(PROPERTY_NAME_LOG_10_SCALED);
            this.setModified(true);
        }
    }

    public final boolean isScalingApplied() {
        return this.scalingApplied;
    }

    public static boolean isValidMaskProperty(String propertyName) {
        return PROPERTY_NAME_NO_DATA_VALUE.equals(propertyName) || PROPERTY_NAME_NO_DATA_VALUE_USED.equals(propertyName) || PROPERTY_NAME_VALID_PIXEL_EXPRESSION.equals(propertyName) || "data".equals(propertyName);
    }

    public boolean isNoDataValueSet() {
        return this.noData != null;
    }

    public void clearNoDataValue() {
        this.noData = null;
        this.setGeophysicalNoDataValue();
    }

    public boolean isNoDataValueUsed() {
        return this.noDataValueUsed;
    }

    public void setNoDataValueUsed(boolean noDataValueUsed) {
        if (this.noDataValueUsed != noDataValueUsed) {
            this.noDataValueUsed = noDataValueUsed;
            this.resetValidMask();
            this.setModified(true);
            this.fireProductNodeChanged(PROPERTY_NAME_NO_DATA_VALUE_USED);
            this.fireProductNodeDataChanged();
        }
    }

    public double getNoDataValue() {
        return this.isNoDataValueSet() ? this.noData.getElemDouble() : 0.0;
    }

    public void setNoDataValue(double noDataValue) {
        if (this.noData == null || this.getNoDataValue() != noDataValue) {
            if (this.noData == null) {
                this.noData = this.createCompatibleProductData(1);
            }
            this.noData.setElemDouble(noDataValue);
            this.setGeophysicalNoDataValue();
            if (this.isNoDataValueUsed()) {
                this.resetValidMask();
            }
            this.setModified(true);
            this.fireProductNodeChanged(PROPERTY_NAME_NO_DATA_VALUE);
            if (this.isNoDataValueUsed()) {
                this.fireProductNodeDataChanged();
            }
        }
    }

    public double getGeophysicalNoDataValue() {
        return this.geophysicalNoDataValue;
    }

    public void setGeophysicalNoDataValue(double noDataValue) {
        this.setNoDataValue(this.scaleInverse(noDataValue));
    }

    public String getValidPixelExpression() {
        return this.validPixelExpression;
    }

    public void setValidPixelExpression(String validPixelExpression) {
        if (!ObjectUtils.equalObjects(this.validPixelExpression, validPixelExpression)) {
            this.validPixelExpression = validPixelExpression;
            this.resetValidMask();
            this.setModified(true);
            this.fireProductNodeChanged(PROPERTY_NAME_VALID_PIXEL_EXPRESSION);
            this.fireProductNodeDataChanged();
        }
    }

    public boolean isValidMaskUsed() {
        return this.isValidPixelExpressionSet() || this.isNoDataValueUsed();
    }

    public void resetValidMask() {
        this.validMaskROI = null;
        this.validMaskImage = null;
        this.stx = null;
    }

    public String getValidMaskExpression() {
        String dataMaskExpression = null;
        if (this.isValidPixelExpressionSet()) {
            String dataMaskExpression2;
            dataMaskExpression = this.getValidPixelExpression();
            if (this.isNoDataValueUsed() && !(dataMaskExpression2 = this.createValidMaskExpressionForNoDataValue()).equals(dataMaskExpression)) {
                dataMaskExpression = "(" + dataMaskExpression + ") && " + dataMaskExpression2;
            }
        } else if (this.isNoDataValueUsed()) {
            dataMaskExpression = this.createValidMaskExpressionForNoDataValue();
        }
        return dataMaskExpression;
    }

    private String createValidMaskExpressionForNoDataValue() {
        String ref = BandArithmetic.createExternalName(this.getName());
        double noDataValue = this.getGeophysicalNoDataValue();
        if (Double.isNaN(noDataValue)) {
            return "!nan(" + ref + ")";
        }
        if (Double.isInfinite(noDataValue)) {
            return "!inf(" + ref + ")";
        }
        if (ProductData.isIntType(this.getDataType())) {
            double rawNoDataValue = this.getNoDataValue();
            String rawSymbol = this.getName() + ".raw";
            String extName = BandArithmetic.createExternalName(rawSymbol);
            return extName + " != " + rawNoDataValue;
        }
        return "fneq(" + ref + "," + noDataValue + ")";
    }

    @Override
    public void updateExpression(String oldExternalName, String newExternalName) {
        if (this.validPixelExpression == null) {
            return;
        }
        String expression = StringUtils.replaceWord(this.validPixelExpression, oldExternalName, newExternalName);
        if (!this.validPixelExpression.equals(expression)) {
            this.validPixelExpression = expression;
            this.setModified(true);
        }
        super.updateExpression(oldExternalName, newExternalName);
    }

    public abstract ProductData getSceneRasterData();

    public boolean hasRasterData() {
        return this.getRasterData() != null;
    }

    public ProductData getRasterData() {
        return this.getData();
    }

    public void setRasterData(ProductData rasterData) {
        this.setData(rasterData);
    }

    @Deprecated
    public void loadRasterData() throws IOException {
        this.loadRasterData(ProgressMonitor.NULL);
    }

    @Deprecated
    public void loadRasterData(ProgressMonitor pm) throws IOException {
    }

    @Deprecated
    public void unloadRasterData() {
    }

    @Override
    public void dispose() {
        if (this.imageInfo != null) {
            this.imageInfo.dispose();
            this.imageInfo = null;
        }
        if (this.sourceImage != null) {
            this.sourceImage.dispose();
            this.sourceImage = null;
        }
        if (this.validMaskROI != null) {
            this.validMaskROI = null;
        }
        if (this.validMaskImage != null) {
            this.validMaskImage.dispose();
            this.validMaskImage = null;
        }
        if (this.geophysicalImage != null && this.geophysicalImage != this.sourceImage) {
            this.geophysicalImage.dispose();
            this.geophysicalImage = null;
        }
        this.overlayMasks.removeAll();
        this.overlayMasks.clearRemovedList();
        this.roiMasks.removeAll();
        this.roiMasks.clearRemovedList();
        this.ancillaryBands.clear();
        super.dispose();
    }

    public boolean isPixelValid(int x, int y) {
        if (!this.isValidMaskUsed()) {
            return true;
        }
        MultiLevelImage image = this.getValidMaskImage();
        if (image != null) {
            int ty;
            int tx = image.XToTileX(x);
            Raster tile = image.getTile(tx, ty = image.YToTileY(y));
            return tile.getSample(x, y, 0) != 0;
        }
        return true;
    }

    public int getSampleInt(int x, int y) {
        MultiLevelImage image = this.getGeophysicalImage();
        int tx = image.XToTileX(x);
        int ty = image.YToTileY(y);
        Raster tile = image.getTile(tx, ty);
        return tile.getSample(x, y, 0);
    }

    public float getSampleFloat(int x, int y) {
        MultiLevelImage image = this.getGeophysicalImage();
        int tx = image.XToTileX(x);
        int ty = image.YToTileY(y);
        Raster tile = image.getTile(tx, ty);
        return tile.getSampleFloat(x, y, 0);
    }

    public boolean isPixelValid(int pixelIndex) {
        if (!this.isValidMaskUsed()) {
            return true;
        }
        int y = pixelIndex / this.getSceneRasterWidth();
        int x = pixelIndex - y * this.getSceneRasterWidth();
        return this.isPixelValid(x, y);
    }

    public boolean isPixelValid(int x, int y, ROI roi) {
        return this.isPixelValid(x, y) && (roi == null || roi.contains(x, y));
    }

    public abstract int getPixelInt(int var1, int var2);

    public abstract float getPixelFloat(int var1, int var2);

    public abstract double getPixelDouble(int var1, int var2);

    public abstract void setPixelInt(int var1, int var2, int var3);

    public abstract void setPixelFloat(int var1, int var2, float var3);

    public abstract void setPixelDouble(int var1, int var2, double var3);

    public int[] getPixels(int x, int y, int w, int h, int[] pixels) {
        return this.getPixels(x, y, w, h, pixels, ProgressMonitor.NULL);
    }

    @Deprecated
    public abstract int[] getPixels(int var1, int var2, int var3, int var4, int[] var5, ProgressMonitor var6);

    public float[] getPixels(int x, int y, int w, int h, float[] pixels) {
        return this.getPixels(x, y, w, h, pixels, ProgressMonitor.NULL);
    }

    @Deprecated
    public abstract float[] getPixels(int var1, int var2, int var3, int var4, float[] var5, ProgressMonitor var6);

    public double[] getPixels(int x, int y, int w, int h, double[] pixels) {
        return this.getPixels(x, y, w, h, pixels, ProgressMonitor.NULL);
    }

    @Deprecated
    public abstract double[] getPixels(int var1, int var2, int var3, int var4, double[] var5, ProgressMonitor var6);

    public abstract void setPixels(int var1, int var2, int var3, int var4, int[] var5);

    public abstract void setPixels(int var1, int var2, int var3, int var4, float[] var5);

    public abstract void setPixels(int var1, int var2, int var3, int var4, double[] var5);

    public int[] readPixels(int x, int y, int w, int h, int[] pixels) throws IOException {
        return this.readPixels(x, y, w, h, pixels, ProgressMonitor.NULL);
    }

    public abstract int[] readPixels(int var1, int var2, int var3, int var4, int[] var5, ProgressMonitor var6) throws IOException;

    public float[] readPixels(int x, int y, int w, int h, float[] pixels) throws IOException {
        return this.readPixels(x, y, w, h, pixels, ProgressMonitor.NULL);
    }

    public abstract float[] readPixels(int var1, int var2, int var3, int var4, float[] var5, ProgressMonitor var6) throws IOException;

    public double[] readPixels(int x, int y, int w, int h, double[] pixels) throws IOException {
        return this.readPixels(x, y, w, h, pixels, ProgressMonitor.NULL);
    }

    public abstract double[] readPixels(int var1, int var2, int var3, int var4, double[] var5, ProgressMonitor var6) throws IOException;

    public void writePixels(int x, int y, int w, int h, int[] pixels) throws IOException {
        this.writePixels(x, y, w, h, pixels, ProgressMonitor.NULL);
    }

    public abstract void writePixels(int var1, int var2, int var3, int var4, int[] var5, ProgressMonitor var6) throws IOException;

    public synchronized void writePixels(int x, int y, int w, int h, float[] pixels) throws IOException {
        this.writePixels(x, y, w, h, pixels, ProgressMonitor.NULL);
    }

    public abstract void writePixels(int var1, int var2, int var3, int var4, float[] var5, ProgressMonitor var6) throws IOException;

    public void writePixels(int x, int y, int w, int h, double[] pixels) throws IOException {
        this.writePixels(x, y, w, h, pixels, ProgressMonitor.NULL);
    }

    public abstract void writePixels(int var1, int var2, int var3, int var4, double[] var5, ProgressMonitor var6) throws IOException;

    public boolean[] readValidMask(int x, int y, int w, int h, boolean[] validMask) throws IOException {
        if (validMask == null) {
            validMask = new boolean[w * h];
        }
        if (this.isValidMaskUsed()) {
            int index = 0;
            ROI roi = this.getValidMaskROI();
            for (int yi = y; yi < y + h; ++yi) {
                for (int xi = x; xi < x + w; ++xi) {
                    validMask[index] = roi.contains(xi, yi);
                    ++index;
                }
            }
        } else {
            Arrays.fill(validMask, true);
        }
        return validMask;
    }

    public void readRasterDataFully() throws IOException {
        this.readRasterDataFully(ProgressMonitor.NULL);
    }

    public abstract void readRasterDataFully(ProgressMonitor var1) throws IOException;

    public void readRasterData(int offsetX, int offsetY, int width, int height, ProductData rasterData) throws IOException {
        this.readRasterData(offsetX, offsetY, width, height, rasterData, ProgressMonitor.NULL);
    }

    public abstract void readRasterData(int var1, int var2, int var3, int var4, ProductData var5, ProgressMonitor var6) throws IOException;

    public void writeRasterDataFully() throws IOException {
        this.writeRasterDataFully(ProgressMonitor.NULL);
    }

    public abstract void writeRasterDataFully(ProgressMonitor var1) throws IOException;

    public void writeRasterData(int offsetX, int offsetY, int width, int height, ProductData rasterData) throws IOException {
        this.writeRasterData(offsetX, offsetY, width, height, rasterData, ProgressMonitor.NULL);
    }

    public abstract void writeRasterData(int var1, int var2, int var3, int var4, ProductData var5, ProgressMonitor var6) throws IOException;

    public ProductData createCompatibleRasterData() {
        return this.createCompatibleRasterData(this.getRasterWidth(), this.getRasterHeight());
    }

    public ProductData createCompatibleSceneRasterData() {
        return this.createCompatibleRasterData(this.getSceneRasterWidth(), this.getSceneRasterHeight());
    }

    public ProductData createCompatibleRasterData(int width, int height) {
        return this.createCompatibleProductData(width * height);
    }

    public boolean isCompatibleRasterData(ProductData rasterData, int w, int h) {
        return rasterData != null && rasterData.getType() == this.getDataType() && rasterData.getNumElems() == w * h;
    }

    public void checkCompatibleRasterData(ProductData rasterData, int w, int h) {
        if (!this.isCompatibleRasterData(rasterData, w, h)) {
            throw new IllegalArgumentException("invalid raster data buffer for '" + this.getName() + "'");
        }
    }

    public boolean hasIntPixels() {
        return ProductData.isIntType(this.getDataType());
    }

    public TransectProfileData createTransectProfileData(Shape shape) throws IOException {
        return new TransectProfileDataBuilder().raster(this).path(shape).build();
    }

    @Override
    public abstract void acceptVisitor(ProductVisitor var1);

    public ImageInfo getImageInfo() {
        return this.imageInfo;
    }

    public void setImageInfo(ImageInfo imageInfo) {
        this.setImageInfo(imageInfo, true);
    }

    protected void setImageInfo(ImageInfo imageInfo, boolean change) {
        if (this.imageInfo != imageInfo) {
            this.imageInfo = imageInfo;
            if (change) {
                this.fireImageInfoChanged();
            }
        }
    }

    public void fireImageInfoChanged() {
        this.fireProductNodeChanged(PROPERTY_NAME_IMAGE_INFO);
        this.setModified(true);
    }

    public final ImageInfo getImageInfo(ProgressMonitor pm) {
        return this.getImageInfo(null, pm);
    }

    public final synchronized ImageInfo getImageInfo(double[] histoSkipAreas, ProgressMonitor pm) {
        ImageInfo imageInfo = this.getImageInfo();
        if (imageInfo == null) {
            imageInfo = this.createDefaultImageInfo(histoSkipAreas, pm);
            this.setImageInfo(imageInfo, false);
        }
        return imageInfo;
    }

    public synchronized ImageInfo createDefaultImageInfo(double[] histoSkipAreas, ProgressMonitor pm) {
        Stx stx = this.getStx(false, pm);
        Histogram histogram = new Histogram(stx.getHistogramBins(), stx.getMinimum(), stx.getMaximum());
        return this.createDefaultImageInfo(histoSkipAreas, histogram);
    }

    public final ImageInfo createDefaultImageInfo(double[] histoSkipAreas, Histogram histogram) {
        double max;
        double min;
        Range range = histoSkipAreas != null ? histogram.findRange(histoSkipAreas[0], histoSkipAreas[1], true, false) : histogram.findRange(0.01, 0.04, true, false);
        try {
            String unit = this.getUnit();
            String filePath = "beam-ui" + File.separator + "auxdata" + File.separator + "color-palettes" + File.separator;
            String name = null;
            if (unit.contains("phase")) {
                name = System.getProperty(SystemUtils.getApplicationContextId() + ".phase.color-palette", null);
            } else if (unit.contains("meters")) {
                name = System.getProperty(SystemUtils.getApplicationContextId() + ".meters.color-palette", null);
            } else if (unit.contains("m^3/m^3") || unit.contains("Farad/m")) {
                name = System.getProperty(SystemUtils.getApplicationContextId() + ".soilmoisture.color-palette", null);
            }
            if (name != null) {
                return RasterDataNode.loadColorPalette(histogram, filePath + name);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (range.getMin() != range.getMax()) {
            min = range.getMin();
            max = range.getMax();
        } else {
            min = histogram.getMin();
            max = histogram.getMax();
        }
        double center = this.scale(0.5 * (this.scaleInverse(min) + this.scaleInverse(max)));
        ColorPaletteDef gradationCurve = new ColorPaletteDef(min, center, max);
        return new ImageInfo(gradationCurve);
    }

    private static ImageInfo loadColorPalette(Histogram histogram, String path) throws IOException {
        File file = new File(SystemUtils.getApplicationDataDir(), path);
        ColorPaletteDef colorPaletteDef = ColorPaletteDef.loadColorPaletteDef(file);
        ImageInfo info = new ImageInfo(colorPaletteDef);
        Range autoStretchRange = histogram.findRangeFor95Percent();
        info.setColorPaletteDef(colorPaletteDef, autoStretchRange.getMin(), autoStretchRange.getMax(), true);
        return info;
    }

    public ProductNodeGroup<Mask> getOverlayMaskGroup() {
        return this.overlayMasks;
    }

    public BufferedImage createColorIndexedImage(ProgressMonitor pm) throws IOException {
        return ProductUtils.createColorIndexedImage(this, pm);
    }

    public BufferedImage createRgbImage(ProgressMonitor pm) throws IOException {
        BufferedImage rgbImage;
        if (this.imageInfo != null) {
            return ProductUtils.createRgbImage(new RasterDataNode[]{this}, this.imageInfo, pm);
        }
        pm.beginTask("Creating image", 4);
        try {
            this.imageInfo = this.createDefaultImageInfo(null, SubProgressMonitor.create((ProgressMonitor)pm, (int)1));
            rgbImage = ProductUtils.createRgbImage(new RasterDataNode[]{this}, this.imageInfo, SubProgressMonitor.create((ProgressMonitor)pm, (int)3));
        }
        finally {
            pm.done();
        }
        return rgbImage;
    }

    public byte[] quantizeRasterData(double newMin, double newMax, double gamma, ProgressMonitor pm) throws IOException {
        byte[] colorIndexes = new byte[this.getSceneRasterWidth() * this.getSceneRasterHeight()];
        this.quantizeRasterData(newMin, newMax, gamma, colorIndexes, 0, 1, pm);
        return colorIndexes;
    }

    public void quantizeRasterData(double newMin, double newMax, double gamma, byte[] samples, int offset, int stride, ProgressMonitor pm) throws IOException {
        ProductData sceneRasterData = this.getSceneRasterData();
        double rawMin = this.scaleInverse(newMin);
        double rawMax = this.scaleInverse(newMax);
        byte[] gammaCurve = null;
        if (gamma != 0.0 && gamma != 1.0) {
            gammaCurve = MathUtils.createGammaCurve(gamma, new byte[256]);
        }
        if (sceneRasterData != null) {
            RasterDataNode.quantizeRasterData(sceneRasterData, rawMin, rawMax, samples, offset, stride, gammaCurve, pm);
        } else {
            this.quantizeRasterDataFromFile(rawMin, rawMax, samples, offset, stride, gammaCurve, pm);
        }
    }

    private void quantizeRasterDataFromFile(final double rawMin, final double rawMax, final byte[] samples, final int offset, final int stride, final byte[] gammaCurve, ProgressMonitor pm) throws IOException {
        this.processRasterData("Quantizing raster '" + this.getDisplayName() + "'", new RasterDataProcessor(){

            @Override
            public void processRasterDataBuffer(ProductData buffer, int y0, int numLines, ProgressMonitor pm) {
                int pos = y0 * RasterDataNode.this.getRasterWidth() * stride;
                RasterDataNode.quantizeRasterData(buffer, rawMin, rawMax, samples, pos + offset, stride, gammaCurve, pm);
            }
        }, pm);
    }

    private static ProductData recycleOrCreateBuffer(int dataType, int buffersize, ProductData readBuffer) {
        if (readBuffer == null || readBuffer.getNumElems() != buffersize) {
            readBuffer = ProductData.createInstance(dataType, buffersize);
        }
        return readBuffer;
    }

    public IndexValidator createPixelValidator(int lineOffset, ROI roi) throws IOException {
        if (this.isValidMaskUsed() && roi != null) {
            return new DelegatingValidator(new RoiValidator(this.rasterWidth, lineOffset, this.getValidMaskROI()), new RoiValidator(this.rasterWidth, lineOffset, roi));
        }
        if (this.isValidMaskUsed()) {
            return new RoiValidator(this.rasterWidth, lineOffset, this.getValidMaskROI());
        }
        if (roi != null) {
            return new RoiValidator(this.rasterWidth, lineOffset, roi);
        }
        return IndexValidator.TRUE;
    }

    @Override
    public final double scale(double v) {
        v = v * this.scalingFactor + this.scalingOffset;
        if (this.log10Scaled) {
            v = Math.pow(10.0, v);
        }
        return v;
    }

    @Override
    public final double scaleInverse(double v) {
        if (this.log10Scaled) {
            v = Math.log10(v);
        }
        return (v - this.scalingOffset) / this.scalingFactor;
    }

    private void setScalingApplied() {
        this.scalingApplied = this.getScalingFactor() != 1.0 || this.getScalingOffset() != 0.0 || this.isLog10Scaled();
    }

    public String getPixelString(int x, int y) {
        if (!this.isPixelWithinImageBounds(x, y)) {
            return INVALID_POS_TEXT;
        }
        if (this.hasRasterData()) {
            if (this.isPixelValid(x, y)) {
                if (this.isFloatingPointType()) {
                    return String.valueOf(this.getPixelFloat(x, y));
                }
                return String.valueOf(this.getPixelInt(x, y));
            }
            return NO_DATA_TEXT;
        }
        try {
            boolean pixelValid = this.readValidMask(x, y, 1, 1, new boolean[1])[0];
            if (pixelValid) {
                if (this.isFloatingPointType()) {
                    float[] pixel = this.readPixels(x, y, 1, 1, new float[1], ProgressMonitor.NULL);
                    return String.valueOf(pixel[0]);
                }
                int[] pixel = this.readPixels(x, y, 1, 1, new int[1], ProgressMonitor.NULL);
                return String.valueOf(pixel[0]);
            }
            return NO_DATA_TEXT;
        }
        catch (IOException e) {
            return IO_ERROR_TEXT;
        }
    }

    private boolean isPixelWithinImageBounds(int x, int y) {
        return x >= 0 && y >= 0 && x < this.getSceneRasterWidth() && y < this.getSceneRasterHeight();
    }

    private boolean isValidPixelExpressionSet() {
        return this.getValidPixelExpression() != null && this.getValidPixelExpression().trim().length() > 0;
    }

    private int getReadBufferLineCount() {
        int sizePerLine = this.getRasterWidth() * ProductData.getElemSize(this.getDataType());
        int bufferLineCount = 0x800000 / sizePerLine;
        if (bufferLineCount == 0) {
            bufferLineCount = 1;
        }
        return bufferLineCount;
    }

    private static void quantizeRasterData(ProductData sceneRasterData, double rawMin, double rawMax, byte[] samples, int offset, int stride, byte[] resampleLUT, ProgressMonitor pm) {
        Quantizer.quantizeGeneric(sceneRasterData.getElems(), sceneRasterData.isUnsigned(), rawMin, rawMax, samples, offset, stride, pm);
        if (resampleLUT != null && resampleLUT.length == 256) {
            for (int i = 0; i < samples.length; ++i) {
                samples[i] = resampleLUT[samples[i] & 0xFF];
            }
        }
    }

    private void setGeophysicalNoDataValue() {
        this.geophysicalNoDataValue = this.scale(this.getNoDataValue());
    }

    public boolean isSourceImageSet() {
        return this.sourceImage != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MultiLevelImage getSourceImage() {
        if (!this.isSourceImageSet()) {
            RasterDataNode rasterDataNode = this;
            synchronized (rasterDataNode) {
                if (!this.isSourceImageSet()) {
                    this.sourceImage = this.toMultiLevelImage(this.createSourceImage());
                }
            }
        }
        return this.sourceImage;
    }

    protected abstract RenderedImage createSourceImage();

    public synchronized void setSourceImage(RenderedImage sourceImage) {
        if (sourceImage != null) {
            this.setSourceImage(this.toMultiLevelImage(sourceImage));
        } else {
            this.setSourceImage((MultiLevelImage)null);
        }
    }

    public synchronized void setSourceImage(MultiLevelImage sourceImage) {
        MultiLevelImage oldValue = this.sourceImage;
        if (oldValue != sourceImage) {
            this.sourceImage = sourceImage;
            this.resetGeophysicalImage();
            this.fireProductNodeChanged("sourceImage", oldValue, sourceImage);
        }
    }

    public boolean isGeophysicalImageSet() {
        return this.geophysicalImage != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MultiLevelImage getGeophysicalImage() {
        if (this.geophysicalImage == null) {
            RasterDataNode rasterDataNode = this;
            synchronized (rasterDataNode) {
                if (this.geophysicalImage == null) {
                    this.geophysicalImage = this.isScalingApplied() || this.getDataType() == 10 || this.getDataType() == 22 ? this.createGeophysicalImage() : this.getSourceImage();
                }
            }
        }
        return this.geophysicalImage;
    }

    private MultiLevelImage createGeophysicalImage() {
        return new DefaultMultiLevelImage((MultiLevelSource)new GenericMultiLevelSource((MultiLevelSource)this.getSourceImage()){

            protected RenderedImage createImage(RenderedImage[] sourceImages, int level) {
                RenderedImage source = sourceImages[0];
                double factor = RasterDataNode.this.getScalingFactor();
                double offset = RasterDataNode.this.getScalingOffset();
                ScalingType scalingType = RasterDataNode.this.getScalingType();
                InterpretationType interpretationType = RasterDataNode.this.getInterpretationType();
                int sourceDataType = source.getSampleModel().getDataType();
                int targetDataType = ReinterpretDescriptor.getTargetDataType((int)sourceDataType, (double)factor, (double)offset, (ScalingType)scalingType, (InterpretationType)interpretationType);
                SingleBandedSampleModel sampleModel = new SingleBandedSampleModel(targetDataType, source.getSampleModel().getWidth(), source.getSampleModel().getHeight());
                ImageLayout imageLayout = ReinterpretDescriptor.createTargetImageLayout((RenderedImage)source, (SampleModel)((Object)sampleModel));
                return ReinterpretDescriptor.create((RenderedImage)source, (double)factor, (double)offset, (ScalingType)scalingType, (InterpretationType)interpretationType, (RenderingHints)new RenderingHints(JAI.KEY_IMAGE_LAYOUT, imageLayout));
            }
        });
    }

    private ScalingType getScalingType() {
        return this.isLog10Scaled() ? ReinterpretDescriptor.EXPONENTIAL : ReinterpretDescriptor.LINEAR;
    }

    private InterpretationType getInterpretationType() {
        switch (this.getDataType()) {
            case 10: {
                return ReinterpretDescriptor.INTERPRET_BYTE_SIGNED;
            }
            case 22: {
                return ReinterpretDescriptor.INTERPRET_INT_UNSIGNED;
            }
        }
        return ReinterpretDescriptor.AWT;
    }

    private void resetGeophysicalImage() {
        this.geophysicalImage = null;
    }

    public boolean isValidMaskImageSet() {
        return this.validMaskImage != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MultiLevelImage getValidMaskImage() {
        if (!this.isValidMaskImageSet() && this.isValidMaskUsed()) {
            RasterDataNode rasterDataNode = this;
            synchronized (rasterDataNode) {
                if (!this.isValidMaskImageSet() && this.isValidMaskUsed()) {
                    this.validMaskImage = ImageManager.getInstance().getMaskImage(this.getValidMaskExpression(), this.getProduct(), this);
                }
            }
        }
        return this.validMaskImage;
    }

    public synchronized boolean isStxSet() {
        return this.stx != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized ROI getValidMaskROI() {
        if (this.validMaskROI == null) {
            RasterDataNode rasterDataNode = this;
            synchronized (rasterDataNode) {
                if (this.validMaskROI == null) {
                    this.validMaskROI = new ROI((RenderedImage)this.getValidMaskImage());
                }
            }
        }
        return this.validMaskROI;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Stx getStx() {
        if (this.stx == null) {
            RasterDataNode rasterDataNode = this;
            synchronized (rasterDataNode) {
                if (this.stx == null) {
                    this.getStx(false, ProgressMonitor.NULL);
                }
            }
        }
        return this.stx;
    }

    public synchronized Stx getStx(boolean accurate, ProgressMonitor pm) {
        if (this.stx == null || this.stx.getResolutionLevel() > 0 && accurate) {
            if (accurate) {
                this.setStx(this.computeStxImpl(0, pm));
            } else {
                int levelCount = this.getSourceImage().getModel().getLevelCount();
                int statisticsLevel = ImageManager.getInstance().getStatisticsLevel(this, levelCount);
                this.setStx(this.computeStxImpl(statisticsLevel, pm));
            }
        }
        return this.stx;
    }

    public synchronized void setStx(Stx stx) {
        Stx oldValue = this.stx;
        if (oldValue != stx) {
            this.stx = stx;
            this.fireProductNodeChanged(PROPERTY_NAME_STX, oldValue, stx);
        }
    }

    protected Stx computeStxImpl(int level, ProgressMonitor pm) {
        return new StxFactory().withResolutionLevel(level).create(this, pm);
    }

    public Shape getValidShape() {
        return this.validMaskImage != null ? this.validMaskImage.getImageShape(0) : null;
    }

    private MultiLevelImage toMultiLevelImage(RenderedImage sourceImage) {
        MultiLevelImage mli;
        if (sourceImage instanceof MultiLevelImage) {
            mli = (MultiLevelImage)sourceImage;
        } else {
            MultiLevelModel model = ImageManager.getMultiLevelModel(this);
            mli = new DefaultMultiLevelImage((MultiLevelSource)new DefaultMultiLevelSource(sourceImage, model));
        }
        return mli;
    }

    @Deprecated
    public ProductNodeGroup<Mask> getRoiMaskGroup() {
        return this.roiMasks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    protected void processRasterData(String message, RasterDataProcessor processor, ProgressMonitor pm) throws IOException {
        Debug.trace("RasterDataNode.processRasterData: " + message);
        int readBufferLineCount = this.getReadBufferLineCount();
        ProductData readBuffer = null;
        int width = this.getRasterWidth();
        int height = this.getRasterHeight();
        int numReadsMax = height / readBufferLineCount;
        if (numReadsMax * readBufferLineCount < height) {
            ++numReadsMax;
        }
        Debug.trace("RasterDataNode.processRasterData: numReadsMax=" + numReadsMax + ", readBufferLineCount=" + readBufferLineCount);
        pm.beginTask(message, numReadsMax * 2);
        try {
            for (int i = 0; i < numReadsMax; ++i) {
                int y0 = i * readBufferLineCount;
                int restheight = height - y0;
                int linesToRead = restheight > readBufferLineCount ? readBufferLineCount : restheight;
                readBuffer = RasterDataNode.recycleOrCreateBuffer(this.getDataType(), width * linesToRead, readBuffer);
                this.readRasterData(0, y0, width, linesToRead, readBuffer, SubProgressMonitor.create((ProgressMonitor)pm, (int)1));
                processor.processRasterDataBuffer(readBuffer, y0, linesToRead, SubProgressMonitor.create((ProgressMonitor)pm, (int)1));
                if (!pm.isCanceled()) continue;
                break;
            }
        }
        finally {
            pm.done();
        }
        Debug.trace("RasterDataNode.processRasterData: done");
    }

    @Deprecated
    public static interface RasterDataProcessor {
        public void processRasterDataBuffer(ProductData var1, int var2, int var3, ProgressMonitor var4) throws IOException;
    }

    public class RasterDataDoubleList
    implements DoubleList {
        private final ProductData _buffer;

        public RasterDataDoubleList(ProductData buffer) {
            this._buffer = buffer;
        }

        @Override
        public final int getSize() {
            return this._buffer.getNumElems();
        }

        @Override
        public final double getDouble(int index) {
            return RasterDataNode.this.scale(this._buffer.getElemDoubleAt(index));
        }
    }

    static final class RoiValidator
    implements IndexValidator {
        private final int rasterWidth;
        private final int lineOffset;
        private final ROI roi;

        RoiValidator(int rasterWidth, int lineOffset, ROI roi) {
            this.rasterWidth = rasterWidth;
            this.lineOffset = lineOffset;
            this.roi = roi;
        }

        @Override
        public boolean validateIndex(int pixelIndex) {
            int x = pixelIndex % this.rasterWidth;
            int y = this.lineOffset + pixelIndex / this.rasterWidth;
            return this.roi.contains(x, y);
        }
    }

    static final class ValidMaskValidator
    implements IndexValidator {
        private final int pixelOffset;
        private final BitRaster validMask;

        ValidMaskValidator(int rasterWidth, int lineOffset, BitRaster validMask) {
            this.pixelOffset = rasterWidth * lineOffset;
            this.validMask = validMask;
        }

        @Override
        public boolean validateIndex(int pixelIndex) {
            return this.validMask.isSet(this.pixelOffset + pixelIndex);
        }
    }

    static final class DelegatingValidator
    implements IndexValidator {
        private final IndexValidator validator1;
        private final IndexValidator validator2;

        DelegatingValidator(IndexValidator validator1, IndexValidator validator2) {
            this.validator1 = validator1;
            this.validator2 = validator2;
        }

        @Override
        public boolean validateIndex(int pixelIndex) {
            return this.validator1.validateIndex(pixelIndex) && this.validator2.validateIndex(pixelIndex);
        }
    }
}

