/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.datamodel;

import java.awt.geom.Dimension2D;
import javax.media.jai.PlanarImage;
import org.esa.beam.framework.datamodel.PixelDimensionEstimator;
import org.esa.beam.util.math.SphericalDistance;

class SimplePixelDimensionEstimator
implements PixelDimensionEstimator {
    SimplePixelDimensionEstimator() {
    }

    @Override
    public Dimension2D getPixelDimension(PlanarImage lonImage, PlanarImage latImage, PlanarImage maskImage) {
        int w = latImage.getWidth();
        int h = latImage.getHeight();
        double pixelSizeX = Double.NaN;
        for (int i = 5; i > 2; --i) {
            if (!Double.isNaN(pixelSizeX)) continue;
            int x0 = w / i;
            int y0 = h / i;
            if (maskImage != null && !SimplePixelDimensionEstimator.getSampleBoolean(maskImage, x0, y0)) continue;
            double lat0 = SimplePixelDimensionEstimator.getSampleDouble(latImage, x0, y0, -90.0, 90.0);
            double lon0 = SimplePixelDimensionEstimator.getSampleDouble(lonImage, x0, y0, -180.0, 180.0);
            SphericalDistance calculator = new SphericalDistance(lon0, lat0);
            int x1 = (i - 1) * w / i;
            if (maskImage != null && !SimplePixelDimensionEstimator.getSampleBoolean(maskImage, x1, y0)) continue;
            double latX = SimplePixelDimensionEstimator.getSampleDouble(latImage, x1, y0, -90.0, 90.0);
            double lonX = SimplePixelDimensionEstimator.getSampleDouble(lonImage, x1, y0, -180.0, 180.0);
            pixelSizeX = Math.toDegrees(calculator.distance(lonX, latX)) / (double)(w * (i - 2) / i);
        }
        return new PixelDimension(pixelSizeX);
    }

    private static boolean getSampleBoolean(PlanarImage image, int x, int y) {
        int tileY;
        int tileX = image.XToTileX(x);
        return image.getTile(tileX, tileY = image.YToTileY(y)).getSample(x, y, 0) != 0;
    }

    private static double getSampleDouble(PlanarImage image, int x, int y, double minValue, double maxValue) {
        int tileY;
        int tileX = image.XToTileX(x);
        double value = image.getTile(tileX, tileY = image.YToTileY(y)).getSampleDouble(x, y, 0);
        if (value >= minValue && value <= maxValue) {
            return value;
        }
        return Double.NaN;
    }

    private static final class PixelDimension
    extends Dimension2D {
        public double pixelSizeX;
        public double pixelSizeY;

        private PixelDimension(double pixelSizeX) {
            this(pixelSizeX, pixelSizeX);
        }

        private PixelDimension(double pixelSizeX, double pixelSizeY) {
            this.pixelSizeX = pixelSizeX;
            this.pixelSizeY = pixelSizeY;
        }

        @Override
        public double getWidth() {
            return this.pixelSizeX;
        }

        @Override
        public double getHeight() {
            return this.pixelSizeY;
        }

        @Override
        public void setSize(double width, double height) {
            this.pixelSizeX = width;
            this.pixelSizeY = height;
        }
    }
}

