/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.datamodel;

import com.bc.ceres.core.Assert;
import javax.media.jai.Histogram;
import org.apache.commons.math3.util.FastMath;
import org.esa.beam.framework.datamodel.Scaling;
import org.esa.beam.framework.datamodel.StxFactory;

public class Stx {
    public static final int DEFAULT_BIN_COUNT = 512;
    public static final Scaling LOG10_SCALING = new Log10Scaling();
    private final long sampleCount;
    private final double minimum;
    private final double maximum;
    private final double mean;
    private final double standardDeviation;
    private final double median;
    private final int resolutionLevel;
    private final boolean logHistogram;
    private final boolean intHistogram;
    private final Histogram histogram;
    private final Scaling histogramScaling;
    private final double coefficientOfVariation;
    private final double enl;

    public Stx(double minimum, double maximum, double mean, double standardDeviation, double coeffOfVariation, double enl, boolean logHistogram, boolean intHistogram, Histogram histogram, int resolutionLevel) {
        Assert.argument((!Double.isNaN(minimum) ? 1 : 0) != 0, (String)"minimum must not be NaN");
        Assert.argument((!Double.isInfinite(minimum) ? 1 : 0) != 0, (String)"minimum must not be infinity");
        Assert.argument((!Double.isNaN(maximum) ? 1 : 0) != 0, (String)"maximum must not be NaN");
        Assert.argument((!Double.isInfinite(maximum) ? 1 : 0) != 0, (String)"minimum must not be infinity");
        Assert.argument((resolutionLevel >= 0 ? 1 : 0) != 0, (String)"resolutionLevel");
        this.sampleCount = StxFactory.computeSum(histogram.getBins(0));
        this.minimum = minimum;
        this.maximum = maximum;
        this.histogramScaling = Stx.getHistogramScaling(logHistogram);
        if (minimum == maximum) {
            this.mean = minimum;
            this.standardDeviation = 0.0;
            this.median = maximum;
        } else {
            this.mean = Double.isNaN(mean) ? this.histogramScaling.scaleInverse(histogram.getMean()[0]) : mean;
            this.standardDeviation = Double.isNaN(standardDeviation) ? this.histogramScaling.scaleInverse(histogram.getStandardDeviation()[0]) : standardDeviation;
            this.median = this.histogramScaling.scaleInverse(StxFactory.computeMedian(histogram, this.sampleCount));
        }
        this.logHistogram = logHistogram;
        this.intHistogram = intHistogram;
        this.histogram = histogram;
        this.resolutionLevel = resolutionLevel;
        this.coefficientOfVariation = coeffOfVariation;
        this.enl = enl;
    }

    public double getMinimum() {
        return this.minimum;
    }

    public double getMaximum() {
        return this.maximum;
    }

    public double getMean() {
        return this.mean;
    }

    public double getMedian() {
        return this.median;
    }

    public double getStandardDeviation() {
        return this.standardDeviation;
    }

    public double getCoefficientOfVariation() {
        return this.coefficientOfVariation;
    }

    public double getEquivalentNumberOfLooks() {
        return this.enl;
    }

    public Histogram getHistogram() {
        return this.histogram;
    }

    public boolean isIntHistogram() {
        return this.intHistogram;
    }

    public boolean isLogHistogram() {
        return this.logHistogram;
    }

    public double getHistogramBinMinimum(int binIndex) {
        double value = this.histogram.getBinLowValue(0, binIndex);
        return this.histogramScaling.scaleInverse(value);
    }

    public double getHistogramBinMaximum(int binIndex) {
        double value = binIndex < this.histogram.getNumBins(0) ? this.histogram.getBinLowValue(0, binIndex + 1) : this.histogram.getHighValue(0);
        return this.histogramScaling.scaleInverse(value);
    }

    public double getHistogramBinWidth() {
        return (this.getMaximum() - this.getMinimum()) / (double)this.getHistogramBinCount();
    }

    public double getHistogramBinWidth(int binIndex) {
        return this.getHistogramBinMaximum(binIndex) - this.getHistogramBinMinimum(binIndex);
    }

    public int[] getHistogramBins() {
        return this.histogram.getBins(0);
    }

    public int getHistogramBinCount() {
        return this.histogram.getNumBins(0);
    }

    public Scaling getHistogramScaling() {
        return this.histogramScaling;
    }

    public long getSampleCount() {
        return this.sampleCount;
    }

    public int getResolutionLevel() {
        return this.resolutionLevel;
    }

    static Scaling getHistogramScaling(boolean logHistogram) {
        return logHistogram ? LOG10_SCALING : Scaling.IDENTITY;
    }

    static final class Log10Scaling
    implements Scaling {
        private static final double LN10 = Math.log(10.0);

        Log10Scaling() {
        }

        @Override
        public double scale(double value) {
            if (value <= 1.0E-9) {
                return -9.0;
            }
            return Math.log10(value);
        }

        @Override
        public double scaleInverse(double value) {
            return FastMath.exp((double)(LN10 * value));
        }
    }
}

