/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.datamodel;

import javax.media.jai.UnpackedImageData;
import org.esa.beam.framework.datamodel.StxOp;
import org.esa.beam.util.math.DoubleList;

public final class SummaryStxOp
extends StxOp {
    private double minimum = Double.POSITIVE_INFINITY;
    private double maximum = Double.NEGATIVE_INFINITY;
    private double mean;
    private double meanSqr;
    private long sampleCount = 0L;
    private double valueSum = 0.0;
    private double sqrSum = 0.0;
    private double power4Sum = 0.0;

    public SummaryStxOp() {
        super("Summary");
    }

    public double getMinimum() {
        return this.minimum == Double.POSITIVE_INFINITY ? Double.NaN : this.minimum;
    }

    public double getMaximum() {
        return this.maximum == Double.NEGATIVE_INFINITY ? Double.NaN : this.maximum;
    }

    public double getMean() {
        return this.sampleCount > 0L ? this.mean : Double.NaN;
    }

    public double getStandardDeviation() {
        return this.sampleCount > 0L ? Math.sqrt(this.getVariance()) : Double.NaN;
    }

    public double getVariance() {
        return this.sampleCount > 1L ? this.meanSqr / (double)(this.sampleCount - 1L) : (this.sampleCount == 1L ? 0.0 : Double.NaN);
    }

    public double getCoefficientOfVariation(String unit) {
        double cv = 0.0;
        if (unit != null && unit.contains("intensity")) {
            double m = this.valueSum / (double)this.sampleCount;
            double m2 = this.sqrSum / (double)this.sampleCount;
            cv = Math.sqrt(m2 - m * m) / m;
        } else {
            double m4 = this.power4Sum / (double)this.sampleCount;
            double m2 = this.sqrSum / (double)this.sampleCount;
            cv = Math.sqrt(m4 - m2 * m2) / m2;
        }
        return cv;
    }

    public double getEquivalentNumberOfLooks(String unit) {
        double enl = 0.0;
        if (unit != null && unit.contains("intensity")) {
            double m = this.valueSum / (double)this.sampleCount;
            double m2 = this.sqrSum / (double)this.sampleCount;
            double mm = m * m;
            enl = mm / (m2 - mm);
        } else {
            double m4 = this.power4Sum / (double)this.sampleCount;
            double m2 = this.sqrSum / (double)this.sampleCount;
            double m2m2 = m2 * m2;
            enl = m2m2 / (m4 - m2m2);
        }
        return enl;
    }

    @Override
    public void accumulateData(UnpackedImageData dataPixels, UnpackedImageData maskPixels) {
        DoubleList values = StxOp.asDoubleList(dataPixels);
        int dataPixelStride = dataPixels.pixelStride;
        int dataLineStride = dataPixels.lineStride;
        int dataBandOffset = dataPixels.bandOffsets[0];
        byte[] mask = null;
        int maskPixelStride = 0;
        int maskLineStride = 0;
        int maskBandOffset = 0;
        if (maskPixels != null) {
            mask = maskPixels.getByteData(0);
            maskPixelStride = maskPixels.pixelStride;
            maskLineStride = maskPixels.lineStride;
            maskBandOffset = maskPixels.bandOffsets[0];
        }
        int width = dataPixels.rect.width;
        int height = dataPixels.rect.height;
        int dataLineOffset = dataBandOffset;
        int maskLineOffset = maskBandOffset;
        double tileMinimum = this.minimum;
        double tileMaximum = this.maximum;
        long tileSampleCount = this.sampleCount;
        double tileMean = this.mean;
        double tileMeanSqr = this.meanSqr;
        double tmpValueSum = this.valueSum;
        double tmpSqrSum = this.sqrSum;
        double tmpPower4Sum = this.power4Sum;
        for (int y = 0; y < height; ++y) {
            int dataPixelOffset = dataLineOffset;
            int maskPixelOffset = maskLineOffset;
            for (int x = 0; x < width; ++x) {
                double value;
                if (!(mask != null && mask[maskPixelOffset] == 0 || Double.isInfinite(value = values.getDouble(dataPixelOffset)) || Double.isNaN(value))) {
                    ++tileSampleCount;
                    if (value < tileMinimum) {
                        tileMinimum = value;
                    }
                    if (value > tileMaximum) {
                        tileMaximum = value;
                    }
                    double delta = value - tileMean;
                    tileMeanSqr += delta * (value - (tileMean += delta / (double)tileSampleCount));
                    tmpValueSum += value;
                    double value2 = value * value;
                    tmpSqrSum += value2;
                    tmpPower4Sum += value2 * value2;
                }
                dataPixelOffset += dataPixelStride;
                maskPixelOffset += maskPixelStride;
            }
            dataLineOffset += dataLineStride;
            maskLineOffset += maskLineStride;
        }
        this.minimum = tileMinimum;
        this.maximum = tileMaximum;
        this.sampleCount = tileSampleCount;
        this.mean = tileMean;
        this.meanSqr = tileMeanSqr;
        this.valueSum = tmpValueSum;
        this.sqrSum = tmpSqrSum;
        this.power4Sum = tmpPower4Sum;
    }
}

