/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.datamodel;

import com.bc.ceres.glevel.MultiLevelImage;
import com.bc.ceres.glevel.MultiLevelModel;
import com.bc.ceres.glevel.MultiLevelSource;
import com.bc.ceres.glevel.support.AbstractMultiLevelSource;
import com.bc.ceres.glevel.support.DefaultMultiLevelImage;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.RenderedImage;
import java.lang.ref.WeakReference;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.datamodel.ProductNodeEvent;
import org.esa.beam.framework.datamodel.ProductNodeListener;
import org.esa.beam.framework.datamodel.RasterDataNode;
import org.esa.beam.framework.datamodel.VectorDataNode;
import org.esa.beam.jai.ImageManager;
import org.esa.beam.jai.ResolutionLevel;
import org.esa.beam.jai.VectorDataMaskOpImage;
import org.geotools.geometry.jts.ReferencedEnvelope;

class VectorDataMultiLevelImage
extends DefaultMultiLevelImage
implements ProductNodeListener {
    private final WeakReference<VectorDataNode> vectorDataReference;

    static MultiLevelImage createMask(VectorDataNode vectorDataNode, final RasterDataNode associatedNode) {
        MultiLevelSource multiLevelSource = VectorDataMultiLevelImage.createMaskMultiLevelSource(vectorDataNode);
        return new VectorDataMultiLevelImage(multiLevelSource, vectorDataNode){

            public void reset() {
                super.reset();
                associatedNode.fireProductNodeDataChanged();
            }
        };
    }

    VectorDataMultiLevelImage(MultiLevelSource multiLevelSource, VectorDataNode vectorDataNode) {
        super(multiLevelSource);
        this.vectorDataReference = new WeakReference<VectorDataNode>(vectorDataNode);
        vectorDataNode.getProduct().addProductNodeListener(this);
    }

    public Shape getImageShape(int level) {
        ReferencedEnvelope envelope;
        VectorDataNode vectorDataNode = (VectorDataNode)((Object)this.vectorDataReference.get());
        if (vectorDataNode != null && !(envelope = vectorDataNode.getEnvelope()).isEmpty()) {
            Rectangle2D.Double modelBounds = new Rectangle2D.Double(envelope.getMinX(), envelope.getMinY(), envelope.getWidth(), envelope.getHeight());
            AffineTransform m2i = this.getModel().getModelToImageTransform(level);
            return m2i.createTransformedShape(modelBounds);
        }
        return null;
    }

    public void dispose() {
        Product product;
        VectorDataNode vectorDataNode = (VectorDataNode)((Object)this.vectorDataReference.get());
        if (vectorDataNode != null && (product = vectorDataNode.getProduct()) != null) {
            product.removeProductNodeListener(this);
        }
        this.vectorDataReference.clear();
        super.dispose();
    }

    @Override
    public void nodeChanged(ProductNodeEvent event) {
        if (event.getSourceNode() == this.vectorDataReference.get() && event.getPropertyName().equals("featureCollection")) {
            this.reset();
        }
    }

    @Override
    public void nodeDataChanged(ProductNodeEvent event) {
    }

    @Override
    public void nodeAdded(ProductNodeEvent event) {
    }

    @Override
    public void nodeRemoved(ProductNodeEvent event) {
    }

    VectorDataNode getVectorData() {
        return (VectorDataNode)((Object)this.vectorDataReference.get());
    }

    static MultiLevelSource createMaskMultiLevelSource(final VectorDataNode vectorDataNode) {
        MultiLevelModel multiLevelModel = ImageManager.createMultiLevelModel(vectorDataNode.getProduct());
        return new AbstractMultiLevelSource(multiLevelModel){

            public RenderedImage createImage(int level) {
                return new VectorDataMaskOpImage(vectorDataNode, ResolutionLevel.create(this.getModel(), level));
            }
        };
    }
}

