/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.datamodel;

import com.bc.ceres.core.ProgressMonitor;
import com.bc.ceres.glevel.MultiLevelImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import org.esa.beam.framework.dataio.ProductSubsetDef;
import org.esa.beam.framework.datamodel.Band;
import org.esa.beam.framework.datamodel.ProductData;
import org.esa.beam.framework.datamodel.ProductVisitor;
import org.esa.beam.framework.datamodel.RasterDataNode;
import org.esa.beam.framework.datamodel.VirtualBandMultiLevelImage;
import org.esa.beam.util.Guardian;
import org.esa.beam.util.StringUtils;

public class VirtualBand
extends Band {
    public static final String PROPERTY_NAME_EXPRESSION = "expression";
    private String expression;

    public VirtualBand(String name, int dataType, int width, int height, String expression) {
        super(name, dataType, width, height);
        this.setSpectralBandIndex(-1);
        this.setSynthetic(true);
        this.expression = expression;
    }

    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String expression) {
        if (expression != null && !this.expression.equals(expression)) {
            this.expression = expression;
            if (this.isSourceImageSet()) {
                this.setSourceImage((MultiLevelImage)null);
            }
            this.resetValidMask();
            this.setStx(null);
            this.setImageInfo(null);
            this.setModified(true);
            this.fireProductNodeChanged(PROPERTY_NAME_EXPRESSION);
            this.fireProductNodeChanged("data");
            this.fireProductNodeDataChanged();
        }
    }

    @Override
    public void updateExpression(String oldExternalName, String newExternalName) {
        String updatedExpression = StringUtils.replaceWord(this.expression, oldExternalName, newExternalName);
        if (!this.expression.equals(updatedExpression)) {
            this.expression = updatedExpression;
            this.setModified(true);
        }
        super.updateExpression(oldExternalName, newExternalName);
    }

    @Override
    public void setPixelInt(int x, int y, int pixelValue) {
        throw new IllegalStateException("set not supported for virtual band");
    }

    @Override
    public void setPixelFloat(int x, int y, float pixelValue) {
        throw new IllegalStateException("set not supported for virtual band");
    }

    @Override
    public void setPixelDouble(int x, int y, double pixelValue) {
        throw new IllegalStateException("set not supported for virtual band");
    }

    @Override
    public void writePixels(int x, int y, int w, int h, int[] pixels, ProgressMonitor pm) throws IOException {
        throw new IllegalStateException("write not supported for virtual band");
    }

    @Override
    public synchronized void writePixels(int x, int y, int w, int h, float[] pixels, ProgressMonitor pm) throws IOException {
        throw new IllegalStateException("write not supported for virtual band");
    }

    @Override
    public void writePixels(int x, int y, int w, int h, double[] pixels, ProgressMonitor pm) throws IOException {
        throw new IllegalStateException("write not supported for virtual band");
    }

    @Override
    public void acceptVisitor(ProductVisitor visitor) {
        Guardian.assertNotNull("visitor", visitor);
        visitor.visit(this);
    }

    @Override
    public long getRawStorageSize(ProductSubsetDef subsetDef) {
        return 256L;
    }

    @Override
    public String toString() {
        return this.getClass().getName() + "[" + this.getName() + "," + ProductData.getTypeString(this.getDataType()) + "," + this.getRasterWidth() + "," + this.getRasterHeight() + "]";
    }

    @Override
    public void dispose() {
        super.dispose();
    }

    @Override
    protected RenderedImage createSourceImage() {
        return VirtualBand.createVirtualSourceImage(this, this.getExpression());
    }

    public static MultiLevelImage createVirtualSourceImage(RasterDataNode raster, String expression) {
        return VirtualBandMultiLevelImage.create(expression, raster);
    }
}

