/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.dataop.barithm;

import com.bc.jexp.EvalEnv;
import com.bc.jexp.EvalException;
import com.bc.jexp.Symbol;
import com.bc.jexp.Term;
import org.esa.beam.framework.datamodel.Mask;
import org.esa.beam.framework.datamodel.ProductData;
import org.esa.beam.framework.datamodel.RasterDataNode;
import org.esa.beam.framework.dataop.barithm.RasterDataEvalEnv;

public class RasterDataSymbol
implements Symbol {
    public static final Source RAW = Source.RAW;
    public static final Source GEOPHYSICAL = Source.GEOPHYSICAL;
    private final String symbolName;
    private final int symbolType;
    private final RasterDataNode raster;
    private final Source source;
    protected ProductData data;

    public RasterDataSymbol(String symbolName, Mask mask) {
        this(symbolName, 1, mask, RAW);
    }

    public RasterDataSymbol(String symbolName, RasterDataNode raster, Source source) {
        this(symbolName, RasterDataSymbol.computeSymbolType(raster, source), raster, source);
    }

    private RasterDataSymbol(String symbolName, int symbolType, RasterDataNode raster, Source source) {
        this.symbolName = symbolName;
        this.symbolType = symbolType;
        this.raster = raster;
        this.source = source;
    }

    private static int computeSymbolType(RasterDataNode raster, Source source) {
        if (raster instanceof Mask) {
            return 1;
        }
        int dataType = raster.getDataType();
        boolean isFloatingPointType = ProductData.isFloatingPointType(dataType);
        boolean isScaled = raster.isScalingApplied();
        switch (source) {
            case RAW: {
                return isFloatingPointType ? 3 : 2;
            }
            case GEOPHYSICAL: {
                return isScaled || isFloatingPointType ? 3 : 2;
            }
        }
        throw new IllegalArgumentException("Source not supported: " + (Object)((Object)source));
    }

    @Override
    public String getName() {
        return this.symbolName;
    }

    @Override
    public int getRetType() {
        return this.symbolType;
    }

    public Source getSource() {
        return this.source;
    }

    public RasterDataNode getRaster() {
        return this.raster;
    }

    public void setData(Object data) {
        if (ProductData.class.isAssignableFrom(data.getClass())) {
            this.data = (ProductData)data;
        } else if (data instanceof float[]) {
            this.data = ProductData.createInstance((float[])data);
        } else if (data instanceof int[]) {
            this.data = ProductData.createInstance((int[])data);
        } else {
            throw new IllegalArgumentException("illegal data type");
        }
    }

    @Override
    public boolean evalB(EvalEnv env) throws EvalException {
        int elemIndex = ((RasterDataEvalEnv)env).getElemIndex();
        return Term.toB(this.data.getElemDoubleAt(elemIndex));
    }

    @Override
    public int evalI(EvalEnv env) throws EvalException {
        int elemIndex = ((RasterDataEvalEnv)env).getElemIndex();
        return this.data.getElemIntAt(elemIndex);
    }

    @Override
    public double evalD(EvalEnv env) throws EvalException {
        int elemIndex = ((RasterDataEvalEnv)env).getElemIndex();
        return this.data.getElemDoubleAt(elemIndex);
    }

    @Override
    public String evalS(EvalEnv env) throws EvalException {
        double value = this.evalD(env);
        return Double.toString(value);
    }

    public static enum Source {
        RAW,
        GEOPHYSICAL;

    }
}

