/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.dataop.dem;

import java.awt.Component;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URLConnection;
import java.util.Date;
import java.util.Properties;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import org.esa.beam.framework.dataop.dem.ElevationModelDescriptor;
import org.esa.beam.framework.dataop.dem.ElevationModelInstaller;
import org.esa.beam.util.Debug;
import org.esa.beam.util.SystemUtils;
import org.esa.beam.util.io.FileChooserFactory;

public abstract class AbstractElevationModelDescriptor
implements ElevationModelDescriptor {
    public static final String PROPERTIES_FILE_NAME = "dem.properties";
    public static final String INSTALL_DIR_PROPERTY_NAME = "dem.installDir";
    private final File demPropertiesDir = new File(SystemUtils.getApplicationDataDir(), "beam-core/auxdata/dem" + File.separator + this.getName());
    private ElevationModelInstaller installer;
    private File demInstallDir;

    protected AbstractElevationModelDescriptor() {
        if (!this.demPropertiesDir.exists()) {
            this.demPropertiesDir.mkdirs();
        }
        this.demInstallDir = this.demPropertiesDir;
        this.maybeOverwriteDemInstallDir();
    }

    public File getDemPropertiesFile() {
        return new File(this.demPropertiesDir, PROPERTIES_FILE_NAME);
    }

    @Override
    public File getDemInstallDir() {
        return this.demInstallDir;
    }

    public void setDemInstallDir(File demInstallDir) {
        this.demInstallDir = demInstallDir;
    }

    @Override
    public boolean isInstallingDem() {
        return this.getInstallationStatus() == 2;
    }

    @Override
    public int getInstallationStatus() {
        if (this.isDemInstalled()) {
            return 1;
        }
        if (this.installer != null) {
            return this.installer.getStatus();
        }
        return 0;
    }

    @Override
    public boolean installDemFiles(Object uiComponent) {
        int archiveSizeB;
        if (this.isDemInstalled()) {
            return true;
        }
        if (this.isInstallingDem()) {
            return true;
        }
        Component parent = uiComponent instanceof Component ? (Component)uiComponent : null;
        String title = "Missing DEM";
        String message = "The DEM '" + this.getName() + "' is not installed yet.\n" + "Please visit the project home page at " + SystemUtils.getApplicationHomepageUrl() + "\n" + "in order to download and install it.\n";
        if (this.getDemInstallDir() == null || this.getDemArchiveUrl() == null) {
            JOptionPane.showMessageDialog(parent, message, "Missing DEM", 0);
            return false;
        }
        try {
            URLConnection urlConnection = this.getDemArchiveUrl().openConnection();
            archiveSizeB = urlConnection.getContentLength();
        }
        catch (IOException e) {
            Debug.trace(e);
            JOptionPane.showMessageDialog(parent, message, "Missing DEM", 0);
            return false;
        }
        double archiveSizeMB = (double)Math.round(10.0 * (double)archiveSizeB / 1048576.0) / 10.0;
        message = message + String.format("\n%s can also download and install the DEM for you now.\nThe size of the DEM archive to be downloaded is %s MB,\ntotal disk space for the DEM will be around 8x the archive size.\nYou can continue using %s while the DEM is installed.\n\nDo you wish to install the DEM now?", SystemUtils.getApplicationName(), archiveSizeMB, SystemUtils.getApplicationName());
        int answer = JOptionPane.showConfirmDialog(parent, message, "Missing DEM", 0, 3);
        if (answer != 0) {
            return false;
        }
        File installDir = this.promptForDemInstallDir(parent);
        if (installDir == null) {
            return false;
        }
        this.setDemInstallDir(installDir);
        this.installer = new ElevationModelInstaller(this, parent);
        this.installer.execute();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Properties loadProperties() {
        Properties properties = new Properties();
        File propertiesFile = this.getDemPropertiesFile();
        if (propertiesFile.exists()) {
            FileInputStream stream = null;
            try {
                stream = new FileInputStream(propertiesFile);
                properties.load(stream);
            }
            catch (IOException e) {
            }
            finally {
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
        return properties;
    }

    protected void storeProperties() {
        Properties properties = new Properties();
        properties.put("dem.name", this.getName());
        properties.put("dem.datum", this.getDatum().getName());
        properties.put("dem.archiveUrl", this.getDemArchiveUrl().toExternalForm());
        properties.put(INSTALL_DIR_PROPERTY_NAME, this.getDemInstallDir().getPath());
        properties.put("dem.installTime", new Date().toString());
        properties.put("dem.version", "1.0");
        this.storeProperties(properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void storeProperties(Properties properties) {
        File demPropertiesFile = this.getDemPropertiesFile();
        File parentDir = demPropertiesFile.getParentFile();
        if (parentDir != null) {
            parentDir.mkdirs();
        }
        FileOutputStream stream = null;
        try {
            stream = new FileOutputStream(this.getDemPropertiesFile());
            properties.store(stream, "BEAM DEM Properties File");
        }
        catch (IOException e) {
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {}
            }
        }
    }

    protected File promptForDemInstallDir(Component parent) {
        File demInstallDir = this.getDemInstallDir();
        File initDir = demInstallDir;
        if (!initDir.exists()) {
            initDir = this.demPropertiesDir;
        }
        JFileChooser fileChooser = FileChooserFactory.getInstance().createDirChooser(initDir);
        String dialogTitle = "Select DEM Installation Directory";
        fileChooser.setDialogTitle("Select DEM Installation Directory");
        fileChooser.setCurrentDirectory(demInstallDir);
        int selectAnswer = fileChooser.showDialog(parent, "Select");
        File selectedDir = fileChooser.getSelectedFile();
        if (selectAnswer == 0 && selectedDir != null) {
            int createAnswer;
            if (!selectedDir.exists() && (createAnswer = JOptionPane.showConfirmDialog(parent, "The selected directory\n" + selectedDir.getPath() + "\n" + "does not exists. Shall it be created?", "Select DEM Installation Directory", 0, 3)) != 0) {
                return null;
            }
            return selectedDir;
        }
        return null;
    }

    private void maybeOverwriteDemInstallDir() {
        File installDir;
        Properties properties = this.loadProperties();
        String installDirPath = properties.getProperty(INSTALL_DIR_PROPERTY_NAME);
        if (installDirPath != null && installDirPath.length() > 0 && (installDir = new File(installDirPath)).exists()) {
            this.demInstallDir = installDir;
        }
    }
}

