/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.dataop.dem;

import com.bc.io.FileDownloader;
import com.bc.io.FileUnpacker;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.logging.Level;
import javax.swing.JOptionPane;
import javax.swing.SwingWorker;
import org.esa.beam.framework.dataop.dem.AbstractElevationModelDescriptor;
import org.esa.beam.util.Debug;
import org.esa.beam.util.logging.BeamLogManager;

class ElevationModelInstaller
extends SwingWorker {
    private final Component _parent;
    private IOException _ioException;
    private int _status;
    private AbstractElevationModelDescriptor _descriptor;
    private File _archiveFile;

    public ElevationModelInstaller(AbstractElevationModelDescriptor descriptor, Component parent) {
        this._descriptor = descriptor;
        this._parent = parent;
    }

    public int getStatus() {
        return this._status;
    }

    public IOException getIOException() {
        return this._ioException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object doInBackground() throws Exception {
        this._status = 2;
        this._ioException = null;
        this._archiveFile = null;
        try {
            boolean success;
            URL archiveUrl = this._descriptor.getDemArchiveUrl();
            File demInstallDir = this._descriptor.getDemInstallDir();
            if (!demInstallDir.exists() && !(success = demInstallDir.mkdirs())) {
                throw new IOException("Failed to create directory " + demInstallDir);
            }
            BeamLogManager.getSystemLogger().info("Downloading DEM archive from " + archiveUrl);
            this._archiveFile = FileDownloader.downloadFile(archiveUrl, demInstallDir, this._parent);
            BeamLogManager.getSystemLogger().info("Unpacking DEM archive " + this._archiveFile + " to " + demInstallDir);
            FileUnpacker.unpackZip(this._archiveFile, demInstallDir, this._parent);
            BeamLogManager.getSystemLogger().info("DEM successfully installed");
        }
        catch (IOException e) {
            this._ioException = e;
        }
        finally {
            if (this._ioException == null) {
                this._status = 1;
                BeamLogManager.getSystemLogger().info("DEM successfully installed");
                this._descriptor.storeProperties();
            } else {
                this._status = 4;
                BeamLogManager.getSystemLogger().log(Level.SEVERE, "Failed to install DEM " + this._descriptor.getName(), this._ioException);
                Debug.trace(this._ioException);
            }
        }
        return null;
    }

    public void finished() {
        this.notifyUser();
        this.promptForArchiveFileDeletion();
    }

    private void notifyUser() {
        if (this._ioException == null) {
            if (this._descriptor.isDemInstalled()) {
                JOptionPane.showMessageDialog(this._parent, "The DEM '" + this._descriptor.getName() + "' has successfully been installed in directory\n" + this._descriptor.getDemInstallDir(), "DEM Installed", 1);
            } else {
                JOptionPane.showMessageDialog(this._parent, "Failed to install DEM '" + this._descriptor.getName() + "' in directory\n" + this._descriptor.getDemInstallDir() + "\n" + "An unknown error occurred.\n", "DEM Installation Error", 0);
            }
        } else {
            JOptionPane.showMessageDialog(this._parent, "Failed to install DEM '" + this._descriptor.getName() + "' in directory\n" + this._descriptor.getDemInstallDir() + "\n" + "An I/O error occurred:\n" + this._ioException.getMessage(), "DEM Installation Error", 0);
        }
    }

    private void promptForArchiveFileDeletion() {
        int answer;
        if (this._archiveFile != null && this._archiveFile.exists() && (answer = JOptionPane.showConfirmDialog(this._parent, "Delete the zipped DEM archive file\n'" + this._archiveFile.getPath() + "'?\n\n" + "(Not required anymore.)", "Delete File", 0, 3)) == 0) {
            this._archiveFile.delete();
        }
    }
}

