/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.dataop.dem;

import org.esa.beam.framework.datamodel.AngularDirection;
import org.esa.beam.framework.datamodel.GeoCoding;
import org.esa.beam.framework.datamodel.GeoCodingMathTransform;
import org.esa.beam.framework.datamodel.GeoPos;
import org.esa.beam.framework.datamodel.PixelPos;
import org.esa.beam.framework.datamodel.Pointing;
import org.esa.beam.framework.dataop.dem.ElevationModel;
import org.esa.beam.framework.dataop.maptransf.Datum;
import org.esa.beam.util.Guardian;
import org.esa.beam.util.math.RsMathUtils;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultDerivedCRS;
import org.geotools.referencing.cs.DefaultCartesianCS;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.operation.MathTransform;

public class Orthorectifier
implements GeoCoding {
    public static final float PIXEL_EPS = 0.1f;
    public static final float PIXEL_EPS_SQR = 0.010000001f;
    private final int sceneRasterWidth;
    private final int sceneRasterHeight;
    private final Pointing pointing;
    private final GeoCoding geoCoding;
    private final ElevationModel elevationModel;
    private final int maxIterationCount;
    private final DefaultDerivedCRS imageCRS;
    private volatile MathTransform imageToMapTransform;

    public Orthorectifier(int sceneRasterWidth, int sceneRasterHeight, Pointing pointing, ElevationModel elevationModel, int maxIterationCount) {
        Guardian.assertGreaterThan("sceneRasterWidth", sceneRasterWidth, 0L);
        Guardian.assertGreaterThan("sceneRasterHeight", sceneRasterHeight, 0L);
        Guardian.assertNotNull("pointing", pointing);
        Guardian.assertNotNull("pointing.getGeoCoding()", pointing.getGeoCoding());
        Guardian.assertGreaterThan("maxIterationCount", maxIterationCount, 1L);
        this.sceneRasterWidth = sceneRasterWidth;
        this.sceneRasterHeight = sceneRasterHeight;
        this.pointing = pointing;
        this.geoCoding = pointing.getGeoCoding();
        this.elevationModel = elevationModel;
        this.maxIterationCount = maxIterationCount;
        CoordinateReferenceSystem geoCRS = this.geoCoding.getGeoCRS();
        this.imageCRS = new DefaultDerivedCRS("Image CS based on " + geoCRS.getName(), geoCRS, (MathTransform)new GeoCodingMathTransform(this), (CoordinateSystem)DefaultCartesianCS.DISPLAY);
    }

    @Override
    public Datum getDatum() {
        return this.geoCoding.getDatum();
    }

    @Override
    public CoordinateReferenceSystem getImageCRS() {
        return this.imageCRS;
    }

    @Override
    public CoordinateReferenceSystem getMapCRS() {
        return this.geoCoding.getMapCRS();
    }

    @Override
    public CoordinateReferenceSystem getGeoCRS() {
        return this.geoCoding.getGeoCRS();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MathTransform getImageToMapTransform() {
        Orthorectifier orthorectifier = this;
        synchronized (orthorectifier) {
            if (this.imageToMapTransform == null) {
                try {
                    this.imageToMapTransform = CRS.findMathTransform((CoordinateReferenceSystem)this.imageCRS, (CoordinateReferenceSystem)this.getMapCRS());
                }
                catch (FactoryException e) {
                    throw new IllegalStateException("Not able to find a math transformation from image to map CRS.", e);
                }
            }
        }
        return this.imageToMapTransform;
    }

    public Pointing getPointing() {
        return this.pointing;
    }

    public GeoCoding getGeoCoding() {
        return this.pointing.getGeoCoding();
    }

    public ElevationModel getElevationModel() {
        return this.elevationModel;
    }

    public int getMaxIterationCount() {
        return this.maxIterationCount;
    }

    @Override
    public PixelPos getPixelPos(GeoPos geoPos, PixelPos pixelPos) {
        if (!this.isPixelPosValid(pixelPos = this.performReverseLocationModel(geoPos, pixelPos))) {
            return pixelPos;
        }
        if (!Orthorectifier.mustCorrect(geoPos, pixelPos)) {
            return pixelPos;
        }
        PixelPos correctedPixelPos = this.performPredictionCorrection(pixelPos);
        if (correctedPixelPos != null) {
            pixelPos.setLocation(correctedPixelPos);
        }
        return pixelPos;
    }

    @Override
    public GeoPos getGeoPos(PixelPos pixelPos, GeoPos geoPos) {
        return this.performDirectLocationModel(pixelPos, 1.0, geoPos);
    }

    @Override
    public boolean canGetGeoPos() {
        return this.getGeoCoding().canGetGeoPos();
    }

    @Override
    public boolean canGetPixelPos() {
        return this.getGeoCoding().canGetPixelPos();
    }

    @Override
    public boolean isCrossingMeridianAt180() {
        return this.getGeoCoding().isCrossingMeridianAt180();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Orthorectifier that = (Orthorectifier)o;
        if (this.elevationModel != null ? !this.elevationModel.equals(that.elevationModel) : that.elevationModel != null) {
            return false;
        }
        return this.geoCoding.equals(that.geoCoding);
    }

    public int hashCode() {
        int result = this.geoCoding.hashCode();
        result = 31 * result + (this.elevationModel != null ? this.elevationModel.hashCode() : 0);
        return result;
    }

    @Override
    public void dispose() {
    }

    private PixelPos performPredictionCorrection(PixelPos pixelPos) {
        PixelPos correctedPixelPos = new PixelPos();
        if (this.correctPrediction(pixelPos, 1.0, correctedPixelPos) || this.correctPrediction(pixelPos, 0.5, correctedPixelPos) || this.correctPrediction(pixelPos, 2.0, correctedPixelPos)) {
            return correctedPixelPos;
        }
        return null;
    }

    private boolean correctPrediction(PixelPos pixelPos, double factor, PixelPos correctedPixelPos) {
        PixelPos pp = new PixelPos();
        GeoPos gp = new GeoPos();
        correctedPixelPos.setLocation(pixelPos);
        for (int i = 0; i < this.maxIterationCount; ++i) {
            this.performDirectLocationModel(correctedPixelPos, factor, gp);
            this.performReverseLocationModel(gp, pp);
            float dx = pixelPos.x - pp.x;
            float dy = pixelPos.y - pp.y;
            correctedPixelPos.x += dx;
            correctedPixelPos.y += dy;
            float r = dx * dx + dy * dy;
            if (!(r < 0.010000001f)) continue;
            return true;
        }
        return false;
    }

    private PixelPos performReverseLocationModel(GeoPos geoPos, PixelPos pixelPos) {
        return this.geoCoding.getPixelPos(geoPos, pixelPos);
    }

    private GeoPos performDirectLocationModel(PixelPos pixelPos, double factor, GeoPos geoPos) {
        geoPos = this.geoCoding.getGeoPos(pixelPos, geoPos);
        float h = this.getElevation(geoPos, pixelPos);
        AngularDirection vg = this.pointing.getViewDir(pixelPos, null);
        RsMathUtils.applyGeodeticCorrection(geoPos, factor * (double)h, vg.zenith, vg.azimuth);
        return geoPos;
    }

    protected final boolean isPixelPosValid(PixelPos pixelPos) {
        return pixelPos.x >= 0.0f && pixelPos.x <= (float)this.sceneRasterWidth && pixelPos.y >= 0.0f && pixelPos.y <= (float)this.sceneRasterHeight;
    }

    protected final float getElevation(GeoPos geoPos, PixelPos pixelPos) {
        float h = 0.0f;
        if (this.elevationModel != null) {
            try {
                h = this.elevationModel.getElevation(geoPos);
            }
            catch (Exception ignored) {
                // empty catch block
            }
            if (h == this.elevationModel.getDescriptor().getNoDataValue()) {
                h = 0.0f;
            }
        } else if (this.pointing.canGetElevation()) {
            if (pixelPos == null) {
                pixelPos = this.geoCoding.getPixelPos(geoPos, null);
            }
            h = this.pointing.getElevation(pixelPos);
        }
        return h;
    }

    private static boolean mustCorrect(GeoPos geoPos, PixelPos pixelPos) {
        return true;
    }
}

