/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.dataop.dem;

import org.esa.beam.framework.datamodel.AngularDirection;
import org.esa.beam.framework.datamodel.GeoPos;
import org.esa.beam.framework.datamodel.PixelPos;
import org.esa.beam.framework.datamodel.Pointing;
import org.esa.beam.framework.dataop.dem.ElevationModel;
import org.esa.beam.framework.dataop.dem.Orthorectifier;

public class Orthorectifier2
extends Orthorectifier {
    public static final float DEGREE_EPS = 2.7777778E-4f;
    public static final float DEGREE_EPS_SQR = 7.71605E-8f;
    public static final double RE = 6370997.0;

    public Orthorectifier2(int sceneRasterWidth, int sceneRasterHeight, Pointing pointing, ElevationModel elevationModel, int maxIterationCount) {
        super(sceneRasterWidth, sceneRasterHeight, pointing, elevationModel, maxIterationCount);
    }

    @Override
    public PixelPos getPixelPos(GeoPos geoPos, PixelPos pixelPos) {
        if (pixelPos == null) {
            pixelPos = new PixelPos();
        }
        this.getPixelPosImpl(geoPos, pixelPos);
        return pixelPos;
    }

    private boolean getPixelPosImpl(GeoPos geoPos, PixelPos pixelPos) {
        pixelPos = this.getGeoCoding().getPixelPos(geoPos, pixelPos);
        if (!this.isPixelPosValid(pixelPos)) {
            return false;
        }
        double phiTrue = Math.PI / 180 * (double)geoPos.lat;
        double lamTrue = Math.PI / 180 * (double)geoPos.lon;
        double reCosPhi = 6370997.0 * Math.cos(phiTrue);
        double hTrue = this.getElevation(geoPos, pixelPos);
        AngularDirection vd = new AngularDirection();
        GeoPos gp = new GeoPos();
        int maxIterationCount = this.getMaxIterationCount();
        for (int iter = 1; iter <= maxIterationCount; ++iter) {
            this.getPointing().getViewDir(pixelPos, vd);
            double thetaV = Math.PI / 180 * vd.zenith;
            double phiV = Math.PI / 180 * vd.azimuth;
            double t = hTrue * Math.tan(thetaV);
            double deltaPhi = t * Math.cos(phiV) / 6370997.0;
            double deltaLam = t * Math.sin(phiV) / reCosPhi;
            double phi = phiTrue - deltaPhi;
            double lam = lamTrue - deltaLam;
            gp.lat = (float)(57.29577951308232 * phi);
            gp.lon = (float)(57.29577951308232 * lam);
            float iOld = pixelPos.x;
            float jOld = pixelPos.y;
            this.getGeoCoding().getPixelPos(gp, pixelPos);
            float iNew = pixelPos.x;
            float jNew = pixelPos.y;
            float deltaI = iNew - iOld;
            float deltaJ = jNew - jOld;
            float d = deltaI * deltaI + deltaJ * deltaJ;
            if (!(d < 0.010000001f)) continue;
            return true;
        }
        return false;
    }
}

