/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.dataop.maptransf;

import org.esa.beam.util.Debug;

@Deprecated
public class MapTransformUtils {
    private static double _c00 = 1.0;
    private static double _c02 = 0.25;
    private static double _c04 = 0.046875;
    private static double _c06 = 0.01953125;
    private static double _c08 = 0.01068115234375;
    private static double _c22 = 0.75;
    private static double _c44 = 0.46875;
    private static double _c46 = 0.013020833333333334;
    private static double _c48 = 0.007120768229166667;
    private static double _c66 = 0.3645833333333333;
    private static double _c68 = 0.005696614583333333;
    private static double _c88 = 0.3076171875;
    private static int _max_iter = 15;
    private static double _eps_10 = 1.0E-10;
    private static double _eps_11 = 1.0E-11;

    public static double meridLength(double phi, double sphi, double cphi, double[] en) {
        double a = cphi * sphi;
        double sphis = sphi * sphi;
        return en[0] * phi - a * (en[1] + sphis * (en[2] + sphis * (en[3] + sphis * en[4])));
    }

    public static double invMeridLength(double arg, double es, double[] en) {
        double k = 1.0 / (1.0 - es);
        double phi = arg;
        for (int n = 0; n < _max_iter; ++n) {
            double s = Math.sin(phi);
            double t = 1.0 - es * s * s;
            t = (MapTransformUtils.meridLength(phi, s, Math.cos(phi), en) - arg) * t * Math.sqrt(t) * k;
            phi -= t;
            if (!(Math.abs(t) < _eps_11)) continue;
            return phi;
        }
        Debug.trace("MapTransformUtils: invMeridLength() - exceeded maximum iterations");
        return phi;
    }

    public static double[] getLengthParams(double es) {
        double[] dRet = new double[5];
        double t = es * es;
        dRet[0] = _c00 - es * (_c02 + es * (_c04 + es * (_c06 + es * _c08)));
        dRet[1] = es * (_c22 - es * (_c04 + es * (_c06 + es * _c08)));
        dRet[2] = t * (_c44 - es * (_c46 + es * _c48));
        dRet[3] = (t *= es) * (_c66 - es * _c68);
        dRet[4] = t * es * _c88;
        return dRet;
    }

    public static double msfn(double sinphi, double cosphi, double es) {
        return cosphi / Math.sqrt(1.0 - es * sinphi * sinphi);
    }

    public static double tsfn(double phi, double sinphi, double e) {
        double temp = sinphi * e;
        return Math.tan(0.5 * (1.5707963267948966 - phi)) / Math.pow((1.0 - temp) / (1.0 + temp), 0.5 * e);
    }

    public static double phi2(double ts, double e) {
        double eccnth = 0.5 * e;
        double phi = 1.5707963267948966 - 2.0 * Math.atan(ts);
        for (int n = 0; n < _max_iter; ++n) {
            double con = e * Math.sin(phi);
            double dphi = 1.5707963267948966 - 2.0 * Math.atan(ts * Math.pow((1.0 - con) / (1.0 + con), eccnth)) - phi;
            phi += dphi;
            if (!(Math.abs(dphi) <= _eps_10)) continue;
            return phi;
        }
        Debug.trace("MapTransformUtils: phi2() - exceeded maximum iterations");
        return phi;
    }

    public static double ssfn(double phi, double sinphi, double e) {
        return Math.tan(0.5 * (1.5707963267948966 + phi)) * Math.pow((1.0 - (sinphi *= e)) / (1.0 + sinphi), 0.5 * e);
    }
}

