/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.dataop.maptransf;

import java.awt.geom.Point2D;
import org.esa.beam.framework.datamodel.GeoPos;
import org.esa.beam.framework.dataop.maptransf.CartographicMapTransform;
import org.esa.beam.framework.dataop.maptransf.DefaultMapTransformUI;
import org.esa.beam.framework.dataop.maptransf.Ellipsoid;
import org.esa.beam.framework.dataop.maptransf.MapProjection;
import org.esa.beam.framework.dataop.maptransf.MapProjectionRegistry;
import org.esa.beam.framework.dataop.maptransf.MapTransform;
import org.esa.beam.framework.dataop.maptransf.MapTransformDescriptor;
import org.esa.beam.framework.dataop.maptransf.MapTransformUI;
import org.esa.beam.framework.dataop.maptransf.MapTransformUtils;
import org.esa.beam.framework.dataop.maptransf.UTM;
import org.esa.beam.framework.param.Parameter;

@Deprecated
public class TransverseMercatorDescriptor
implements MapTransformDescriptor {
    public static final String TYPE_ID = "Transverse_Mercator";
    public static final String NAME = "Transverse Mercator";
    public static final String MAP_UNIT = "meter";
    public static final String[] PARAMETER_NAMES = new String[]{"semi_major", "semi_minor", "latitude_of_origin", "central_meridian", "scale_factor", "false_easting", "false_northing"};
    private static final double[] PARAMETER_DEFAULT_VALUES = new double[]{Ellipsoid.WGS_84.getSemiMajor(), Ellipsoid.WGS_84.getSemiMinor(), 0.0, 0.0, 0.9996, 0.0, 0.0};
    public static final String[] PARAMETER_LABELS = new String[]{"Semi major", "Semi minor", "Latitude of origin", "Central meridian", "Scale factor", "False easting", "False northing"};
    public static final String[] PARAMETER_UNITS = new String[]{"meter", "meter", "degree", "degree", "", "meter", "meter"};
    private static final int SEMI_MAJOR_INDEX = 0;
    private static final int SEMI_MINOR_INDEX = 1;
    private static final int LATITUDE_OF_ORIGIN_INDEX = 2;
    private static final int CENTRAL_MERIDIAN_INDEX = 3;
    private static final int SCALE_FACTOR_INDEX = 4;
    private static final int FALSE_EASING_INDEX = 5;
    private static final int FALSE_NORTHING_INDEX = 6;

    @Override
    public void registerProjections() {
        UTM.registerProjections();
        MapProjectionRegistry.registerProjection(new MapProjection(this.getName(), this.createTransform(null), false));
    }

    @Override
    public String getTypeID() {
        return TYPE_ID;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getMapUnit() {
        return MAP_UNIT;
    }

    @Override
    public double[] getParameterDefaultValues() {
        double[] values = new double[PARAMETER_DEFAULT_VALUES.length];
        System.arraycopy(PARAMETER_DEFAULT_VALUES, 0, values, 0, values.length);
        return values;
    }

    @Override
    public Parameter[] getParameters() {
        Parameter[] parameters = new Parameter[PARAMETER_NAMES.length];
        for (int i = 0; i < parameters.length; ++i) {
            parameters[i] = new Parameter(PARAMETER_NAMES[i], PARAMETER_DEFAULT_VALUES[i]);
            parameters[i].getProperties().setLabel(PARAMETER_LABELS[i]);
            parameters[i].getProperties().setPhysicalUnit(PARAMETER_UNITS[i]);
        }
        return parameters;
    }

    @Override
    public boolean hasTransformUI() {
        return true;
    }

    @Override
    public MapTransformUI getTransformUI(MapTransform transform) {
        return new DefaultMapTransformUI(transform);
    }

    @Override
    public MapTransform createTransform(double[] parameterValues) {
        if (parameterValues == null) {
            parameterValues = PARAMETER_DEFAULT_VALUES;
        }
        return new TMT(parameterValues);
    }

    @Deprecated
    public class TMT
    extends CartographicMapTransform {
        private static final double _epsilon = 1.0E-10;
        private static final double _fc1 = 1.0;
        private static final double _fc2 = 0.5;
        private static final double _fc3 = 0.16666666666666666;
        private static final double _fc4 = 0.08333333333333333;
        private static final double _fc5 = 0.05;
        private static final double _fc6 = 0.03333333333333333;
        private static final double _fc7 = 0.023809523809523808;
        private static final double _fc8 = 0.017857142857142856;
        private static final double _halfPi = 1.5707963267948966;
        private final double[] _parameterValues;
        private final double _es;
        private final double _esp;
        private final double _k0;
        private final double _invK0;
        private final double _ml0;
        private final double[] _en;

        public TMT(double[] parameterValues) {
            super(parameterValues[3], parameterValues[5], parameterValues[6], parameterValues[0]);
            double a = parameterValues[0];
            double b = parameterValues[1];
            this._k0 = parameterValues[4];
            this._invK0 = 1.0 / this._k0;
            double phi0 = parameterValues[2];
            this._es = 1.0 - b * b / (a * a);
            this._esp = this._es / (1.0 - this._es);
            this._en = MapTransformUtils.getLengthParams(this._es);
            phi0 = Math.PI / 180 * phi0;
            this._ml0 = MapTransformUtils.meridLength(phi0, Math.sin(phi0), Math.cos(phi0), this._en);
            this._parameterValues = new double[parameterValues.length];
            System.arraycopy(parameterValues, 0, this._parameterValues, 0, parameterValues.length);
        }

        @Override
        public MapTransformDescriptor getDescriptor() {
            return TransverseMercatorDescriptor.this;
        }

        @Override
        public double[] getParameterValues() {
            double[] values = new double[this._parameterValues.length];
            System.arraycopy(this._parameterValues, 0, values, 0, values.length);
            return values;
        }

        @Override
        public Point2D forward_impl(float lat, float lon, Point2D mapPoint) {
            double phi = Math.PI / 180 * (double)lat;
            double lam = Math.PI / 180 * (double)lon;
            double sinPhi = Math.sin(phi);
            double cosPhi = Math.cos(phi);
            double t = 0.0;
            if (Math.abs(cosPhi) > 1.0E-10) {
                t = sinPhi / cosPhi;
                t *= t;
            }
            double a1 = cosPhi * lam;
            double a1s = a1 * a1;
            double n = this._esp * cosPhi * cosPhi;
            double tempX = this._k0 * (a1 /= Math.sqrt(1.0 - this._es * sinPhi * sinPhi)) * (1.0 + 0.16666666666666666 * a1s * (1.0 - t + n + 0.05 * a1s * (5.0 + t * (t - 18.0) + n * (14.0 - 58.0 * t) + 0.023809523809523808 * a1s * (61.0 + t * (t * (179.0 - t) - 479.0)))));
            double ml = MapTransformUtils.meridLength(phi, sinPhi, cosPhi, this._en);
            double tempY = this._k0 * (ml - this._ml0 + sinPhi * a1 * lam * 0.5 * (1.0 + 0.08333333333333333 * a1s * (5.0 - t + n * (9.0 + 4.0 * n) + 0.03333333333333333 * a1s * (61.0 + t * (t - 58.0) + n * (270.0 - 330.0 * t) + 0.017857142857142856 * a1s * (1385.0 + t * (t * (543.0 - t) - 3111.0))))));
            mapPoint.setLocation(tempX, tempY);
            return mapPoint;
        }

        @Override
        public GeoPos inverse_impl(float x, float y, GeoPos geoPoint) {
            return this.inverse_impl((double)x, (double)y, geoPoint);
        }

        @Override
        public GeoPos inverse_impl(double x, double y, GeoPos geoPoint) {
            double _tempY;
            double _tempX = MapTransformUtils.invMeridLength(this._ml0 + y * this._invK0, this._es, this._en);
            if (Math.abs(_tempX) >= 1.5707963267948966) {
                _tempX = y < 0.0 ? -1.5707963267948966 : 1.5707963267948966;
                _tempY = 0.0;
            } else {
                double sinPhi = Math.sin(_tempX);
                double cosPhi = Math.cos(_tempX);
                double t = 0.0;
                if (Math.abs(cosPhi) > 1.0E-10) {
                    t = sinPhi / cosPhi;
                }
                double n = this._esp * cosPhi * cosPhi;
                double con = 1.0 - this._es * sinPhi * sinPhi;
                double d = x * Math.sqrt(con) * this._invK0;
                con *= t;
                t *= t;
                double ds = d * d;
                _tempX -= con * ds / (1.0 - this._es) * 0.5 * (1.0 - ds * 0.08333333333333333 * (5.0 + t * (3.0 - 9.0 * n) - ds * 0.03333333333333333 * (61.0 + t * (90.0 - 252.0 * n + 45.0 * t) + 46.0 * n - ds * 0.017857142857142856 * (1385.0 + t * (3633.0 + t * (4095.0 + 1574.0 * t))))));
                _tempY = d * (1.0 - ds * 0.16666666666666666 * (1.0 + 2.0 * t + n - ds * 0.05 * (5.0 + t * (28.0 + 24.0 * t + 8.0 * n) + 6.0 * n - ds * 0.023809523809523808 * (61.0 + t * (662.0 + t * (1320.0 + 720.0 * t))))));
                _tempY /= cosPhi;
            }
            geoPoint.setLocation((float)(57.29577951308232 * _tempX), (float)(57.29577951308232 * _tempY));
            return geoPoint;
        }

        @Override
        public MapTransform createDeepClone() {
            return new TMT(this._parameterValues);
        }

        public double getSemiMinor() {
            return this._parameterValues[1];
        }

        public double getLatitudeOfOrigin() {
            return this._parameterValues[2];
        }

        public double getScaleFactor() {
            return this._parameterValues[4];
        }
    }
}

