/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.dataop.projection;

import java.awt.geom.Point2D;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.referencing.NamedIdentifier;
import org.geotools.referencing.operation.projection.MapProjection;
import org.geotools.referencing.operation.projection.ProjectionException;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.operation.ConicProjection;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.Projection;

public class AzimuthalEquidistant
extends MapProjection {
    private static final long serialVersionUID = 2015823327782243331L;
    private static final int NORMAL = 0;
    private static final int NORTH_POLE = 1;
    private static final int SOUTH_POLE = 2;
    private static final double EPSILON_LATITUDE = 1.0E-10;
    private final int mode;
    private final double sinPhi0;
    private final double cosPhi0;

    protected AzimuthalEquidistant(ParameterValueGroup parameters) throws ParameterNotFoundException {
        super(parameters);
        this.mode = Math.abs(Math.abs(this.latitudeOfOrigin) - 1.5707963267948966) < 1.0E-10 ? (this.latitudeOfOrigin < 0.0 ? 2 : 1) : 0;
        this.sinPhi0 = Math.sin(this.latitudeOfOrigin);
        this.cosPhi0 = Math.cos(this.latitudeOfOrigin);
    }

    public ParameterDescriptorGroup getParameterDescriptors() {
        return Provider.PARAMETERS;
    }

    protected Point2D transformNormalized(double lambda, double phi, Point2D ptDst) throws ProjectionException {
        double mapY;
        double mapX;
        double sinPhi = Math.sin(phi);
        double cosPhi = Math.cos(phi);
        double sinLam = Math.sin(lambda);
        double cosLam = Math.cos(lambda);
        double cosC = this.sinPhi0 * sinPhi + this.cosPhi0 * cosPhi * cosLam;
        double c = Math.acos(cosC);
        if (c == 0.0) {
            mapX = 0.0;
            mapY = 0.0;
        } else {
            double kPrime = c / Math.sin(c);
            mapX = kPrime * cosPhi * sinLam;
            mapY = kPrime * (this.cosPhi0 * sinPhi - this.sinPhi0 * cosPhi * cosLam);
        }
        if (ptDst != null) {
            ptDst.setLocation(mapX, mapY);
            return ptDst;
        }
        return new Point2D.Double(mapX, mapY);
    }

    protected Point2D inverseTransformNormalized(double x, double y, Point2D ptDst) throws ProjectionException {
        double lambda;
        double phi;
        double c = Math.sqrt(x * x + y * y);
        if (c == 0.0) {
            phi = 0.0;
            lambda = 0.0;
        } else {
            double sinC = Math.sin(c);
            double cosC = Math.cos(c);
            phi = Math.asin(cosC * this.sinPhi0 + y * sinC * this.cosPhi0 / c);
            switch (this.mode) {
                case 1: {
                    lambda = Math.atan2(-x, y);
                    break;
                }
                case 2: {
                    lambda = Math.atan2(x, y);
                    break;
                }
                default: {
                    lambda = Math.atan2(x * sinC, c * this.cosPhi0 * cosC - y * this.sinPhi0 * sinC);
                }
            }
        }
        if (ptDst != null) {
            ptDst.setLocation(lambda, phi);
            return ptDst;
        }
        return new Point2D.Double(lambda, phi);
    }

    public static final class Provider
    extends MapProjection.AbstractProvider {
        private static final long serialVersionUID = -6627017123664912788L;
        static final ParameterDescriptorGroup PARAMETERS = Provider.createDescriptorGroup((ReferenceIdentifier[])new NamedIdentifier[]{new NamedIdentifier(Citations.EPSG, "Azimuthal Equidistant"), new NamedIdentifier(Citations.OGC, "Azimuthal_Equidistant"), new NamedIdentifier(Citations.GEOTIFF, "CT_AzimuthalEquidistant"), new NamedIdentifier(Citations.GEOTOOLS, "CT_AzimuthalEquidistant"), new NamedIdentifier(Citations.ESRI, "Azimuthal Equidistant")}, (GeneralParameterDescriptor[])new ParameterDescriptor[]{SEMI_MAJOR, SEMI_MINOR, LATITUDE_OF_ORIGIN, CENTRAL_MERIDIAN, FALSE_EASTING, FALSE_NORTHING});

        public Provider() {
            super(PARAMETERS);
        }

        public Class<? extends Projection> getOperationType() {
            return ConicProjection.class;
        }

        public MathTransform createMathTransform(ParameterValueGroup parameters) throws ParameterNotFoundException {
            return new AzimuthalEquidistant(parameters);
        }
    }
}

