/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.dataop.projection;

import java.awt.geom.Point2D;
import org.esa.beam.framework.dataop.projection.PseudoCylindricalProjection;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.referencing.NamedIdentifier;
import org.geotools.referencing.operation.projection.MapProjection;
import org.geotools.referencing.operation.projection.ProjectionException;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.Projection;

public class Mollweide
extends MapProjection {
    private static final int MAX_ITER = 10;
    private static final double TOLERANCE = 1.0E-7;
    private final double cx;
    private final double cy;
    private final double cp;

    protected Mollweide(ParameterValueGroup parameters) throws ParameterNotFoundException {
        super(parameters);
        double p = 1.5707963267948966;
        double p2 = p + p;
        double sp = Math.sin(p);
        double r = Math.sqrt(Math.PI * 2 * sp / (p2 + Math.sin(p2)));
        this.cx = 2.0 * r / Math.PI;
        this.cy = r / sp;
        this.cp = p2 + Math.sin(p2);
    }

    public ParameterDescriptorGroup getParameterDescriptors() {
        return Provider.PARAMETERS;
    }

    protected Point2D transformNormalized(double x, double y, Point2D ptDst) throws ProjectionException {
        int i;
        double k = this.cp * Math.sin(y);
        for (i = 10; i != 0; --i) {
            double v = (y + Math.sin(y) - k) / (1.0 + Math.cos(y));
            y -= v;
            if (Math.abs(v) < 1.0E-7) break;
        }
        y = i == 0 ? (y < 0.0 ? -1.5707963267948966 : 1.5707963267948966) : (y *= 0.5);
        double mapX = this.cx * x * Math.cos(y);
        double mapY = this.cy * Math.sin(y);
        if (ptDst != null) {
            ptDst.setLocation(mapX, mapY);
            return ptDst;
        }
        return new Point2D.Double(mapX, mapY);
    }

    protected Point2D inverseTransformNormalized(double x, double y, Point2D ptDst) throws ProjectionException {
        double lat = Math.asin(y / this.cy);
        double lon = x / (this.cx * Math.cos(lat));
        lat += lat;
        lat = Math.asin((lat + Math.sin(lat)) / this.cp);
        if (ptDst != null) {
            ptDst.setLocation(lon, lat);
            return ptDst;
        }
        return new Point2D.Double(lon, lat);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Mollweide)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Mollweide mollweide = (Mollweide)((Object)o);
        if (Double.compare(mollweide.cp, this.cp) != 0) {
            return false;
        }
        if (Double.compare(mollweide.cx, this.cx) != 0) {
            return false;
        }
        return Double.compare(mollweide.cy, this.cy) == 0;
    }

    public int hashCode() {
        int result = super.hashCode();
        long temp = this.cx != 0.0 ? Double.doubleToLongBits(this.cx) : 0L;
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = this.cy != 0.0 ? Double.doubleToLongBits(this.cy) : 0L;
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = this.cp != 0.0 ? Double.doubleToLongBits(this.cp) : 0L;
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public static final class Provider
    extends MapProjection.AbstractProvider {
        static final ParameterDescriptorGroup PARAMETERS = Provider.createDescriptorGroup((ReferenceIdentifier[])new NamedIdentifier[]{new NamedIdentifier(Citations.OGC, "Mollweide"), new NamedIdentifier(Citations.GEOTOOLS, "Mollweide"), new NamedIdentifier(Citations.ESRI, "Mollweide")}, (GeneralParameterDescriptor[])new ParameterDescriptor[]{SEMI_MAJOR, SEMI_MINOR, CENTRAL_MERIDIAN, SCALE_FACTOR, FALSE_EASTING, FALSE_NORTHING});

        public Provider() {
            super(PARAMETERS);
        }

        public Class<? extends Projection> getOperationType() {
            return PseudoCylindricalProjection.class;
        }

        public MathTransform createMathTransform(ParameterValueGroup parameters) throws ParameterNotFoundException {
            return new Mollweide(parameters);
        }
    }
}

