/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.dataop.projection;

import java.awt.geom.Point2D;
import org.esa.beam.framework.dataop.projection.PseudoCylindricalProjection;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.referencing.NamedIdentifier;
import org.geotools.referencing.operation.projection.MapProjection;
import org.geotools.referencing.operation.projection.ProjectionException;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.Projection;

public class Sinusoidal
extends MapProjection {
    private static final double HALF_PI = 1.5707963267948966;

    protected Sinusoidal(ParameterValueGroup parameters) throws ParameterNotFoundException {
        super(parameters);
    }

    public ParameterDescriptorGroup getParameterDescriptors() {
        return Provider.PARAMETERS;
    }

    protected Point2D transformNormalized(double x, double y, Point2D ptDst) throws ProjectionException {
        double mapX = x * Math.cos(y);
        double mapY = y;
        if (ptDst != null) {
            ptDst.setLocation(mapX, mapY);
            return ptDst;
        }
        return new Point2D.Double(mapX, mapY);
    }

    protected Point2D inverseTransformNormalized(double x, double y, Point2D ptDst) throws ProjectionException {
        double lat;
        double lon = x / Math.cos(y);
        if (lon < -Math.PI) {
            lon = -Math.PI;
        }
        if (lon > Math.PI) {
            lon = Math.PI;
        }
        if ((lat = y) < -1.5707963267948966) {
            lon = 0.0;
            lat = -1.5707963267948966;
        }
        if (lat > 1.5707963267948966) {
            lon = 0.0;
            lat = 1.5707963267948966;
        }
        if (ptDst != null) {
            ptDst.setLocation(lon, lat);
            return ptDst;
        }
        return new Point2D.Double(lon, lat);
    }

    public static final class Provider
    extends MapProjection.AbstractProvider {
        static final ParameterDescriptorGroup PARAMETERS = Provider.createDescriptorGroup((ReferenceIdentifier[])new NamedIdentifier[]{new NamedIdentifier(Citations.OGC, "Sinusoidal"), new NamedIdentifier(Citations.GEOTOOLS, "CT_Sinusoidal"), new NamedIdentifier(Citations.ESRI, "Sinusoidal")}, (GeneralParameterDescriptor[])new ParameterDescriptor[]{SEMI_MAJOR, SEMI_MINOR, CENTRAL_MERIDIAN, SCALE_FACTOR, FALSE_EASTING, FALSE_NORTHING});

        public Provider() {
            super(PARAMETERS);
        }

        public Class<? extends Projection> getOperationType() {
            return PseudoCylindricalProjection.class;
        }

        public MathTransform createMathTransform(ParameterValueGroup parameters) throws ParameterNotFoundException {
            return new Sinusoidal(parameters);
        }
    }
}

