/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.dataop.resamp;

import org.apache.commons.math3.util.FastMath;
import org.esa.beam.framework.dataop.resamp.BiCubicInterpolationResampling;
import org.esa.beam.framework.dataop.resamp.Resampling;

class BiSincInterpolationResampling
implements Resampling {
    private static final double DoublePI = Math.PI * 2;
    private int kernelSize = 0;
    private int halfKernelSize = 0;

    public BiSincInterpolationResampling(int kernelSize) {
        this.kernelSize = kernelSize;
        this.halfKernelSize = kernelSize / 2;
    }

    @Override
    public String getName() {
        return "BISINC_INTERPOLATION";
    }

    @Override
    public final Resampling.Index createIndex() {
        return new Resampling.Index(this.kernelSize, 1);
    }

    @Override
    public final void computeIndex(double x, double y, int width, int height, Resampling.Index index) {
        index.x = x;
        index.y = y;
        index.width = width;
        index.height = height;
        int i0 = (int)Math.floor(x);
        int j0 = (int)Math.floor(y);
        int iMax = width - 1;
        int jMax = height - 1;
        index.i0 = i0;
        index.j0 = j0;
        for (int i = 0; i < this.kernelSize; ++i) {
            index.i[i] = Math.min(Math.max(i0 - this.halfKernelSize + i, 0), iMax);
        }
        index.ki[0] = x - (double)i0;
        for (int j = 0; j < this.kernelSize; ++j) {
            index.j[j] = Math.min(Math.max(j0 - this.halfKernelSize + j, 0), jMax);
        }
        index.kj[0] = y - (double)j0;
    }

    @Override
    public final double resample(Resampling.Raster raster, Resampling.Index index) throws Exception {
        int[] x = new int[this.kernelSize];
        int[] y = new int[this.kernelSize];
        double[][] samples = new double[this.kernelSize][this.kernelSize];
        for (int i = 0; i < this.kernelSize; ++i) {
            x[i] = (int)index.i[i];
            y[i] = (int)index.j[i];
        }
        if (!raster.getSamples(x, y, samples)) {
            if (Double.isNaN(samples[this.halfKernelSize][this.halfKernelSize])) {
                return samples[this.halfKernelSize][this.halfKernelSize];
            }
            BiCubicInterpolationResampling.replaceNaNWithMean(samples);
        }
        double muX = index.ki[0];
        double muY = index.kj[0];
        double cx = muX + (double)this.halfKernelSize;
        double cy = muY + (double)this.halfKernelSize;
        double[] winX = new double[this.kernelSize];
        double[] winY = new double[this.kernelSize];
        double sumX = 0.0;
        double sumY = 0.0;
        for (int n = 0; n < this.kernelSize; ++n) {
            winX[n] = BiSincInterpolationResampling.sinc(cx - (double)n) * this.hanning(cx - (double)n);
            winY[n] = BiSincInterpolationResampling.sinc(cy - (double)n) * this.hanning(cy - (double)n);
            sumX += winX[n];
            sumY += winY[n];
        }
        double v = 0.0;
        for (int j = 0; j < this.kernelSize; ++j) {
            for (int i = 0; i < this.kernelSize; ++i) {
                v += samples[j][i] * winX[i] * winY[j];
            }
        }
        return v /= sumX * sumY;
    }

    private static double sinc(double x) {
        return Double.compare(x, 0.0) == 0 ? 1.0 : FastMath.sin((double)(x * Math.PI)) / (x * Math.PI);
    }

    public double hanning(double x) {
        return x >= (double)(-this.halfKernelSize) && x <= (double)this.halfKernelSize ? 0.5 * (1.0 + FastMath.cos((double)(Math.PI * 2 * x / (double)(this.kernelSize + 1)))) : 0.0;
    }

    @Override
    public int getKernelSize() {
        return this.kernelSize;
    }

    public String toString() {
        return "BiSinc interpolation resampling";
    }
}

