/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.dataop.resamp;

import org.esa.beam.framework.dataop.resamp.Resampling;

final class NearestNeighbourResampling
implements Resampling {
    NearestNeighbourResampling() {
    }

    @Override
    public String getName() {
        return "NEAREST_NEIGHBOUR";
    }

    @Override
    public final Resampling.Index createIndex() {
        return new Resampling.Index(0, 0);
    }

    @Override
    public final void computeIndex(double x, double y, int width, int height, Resampling.Index index) {
        index.x = x;
        index.y = y;
        index.width = width;
        index.height = height;
        index.i0 = Resampling.Index.crop((int)Math.floor(x), width - 1);
        index.j0 = Resampling.Index.crop((int)Math.floor(y), height - 1);
    }

    @Override
    public final double resample(Resampling.Raster raster, Resampling.Index index) throws Exception {
        int[] x = new int[]{(int)index.i0};
        int[] y = new int[]{(int)index.j0};
        double[][] samples = new double[1][1];
        raster.getSamples(x, y, samples);
        return samples[0][0];
    }

    public String toString() {
        return "Nearest neighbour resampling";
    }
}

