/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.dataop.resamp;

import org.esa.beam.framework.dataop.resamp.BiCubicInterpolationResampling;
import org.esa.beam.framework.dataop.resamp.BiSinc11PointInterpolationResampling;
import org.esa.beam.framework.dataop.resamp.BiSinc21PointInterpolationResampling;
import org.esa.beam.framework.dataop.resamp.BiSinc5PointInterpolationResampling;
import org.esa.beam.framework.dataop.resamp.BilinearInterpolationResampling;
import org.esa.beam.framework.dataop.resamp.CubicConvolutionResampling;
import org.esa.beam.framework.dataop.resamp.NearestNeighbourResampling;

public interface Resampling {
    public static final Resampling NEAREST_NEIGHBOUR = new NearestNeighbourResampling();
    public static final Resampling BILINEAR_INTERPOLATION = new BilinearInterpolationResampling();
    public static final Resampling CUBIC_CONVOLUTION = new CubicConvolutionResampling();
    public static final Resampling BISINC_5_POINT_INTERPOLATION = new BiSinc5PointInterpolationResampling();
    public static final Resampling BISINC_11_POINT_INTERPOLATION = new BiSinc11PointInterpolationResampling();
    public static final Resampling BISINC_21_POINT_INTERPOLATION = new BiSinc21PointInterpolationResampling();
    public static final Resampling BICUBIC_INTERPOLATION = new BiCubicInterpolationResampling();

    public String getName();

    public Index createIndex();

    public void computeIndex(double var1, double var3, int var5, int var6, Index var7);

    public double resample(Raster var1, Index var2) throws Exception;

    default public int getKernelSize() {
        return 4;
    }

    public static final class Index {
        public double x;
        public double y;
        public int width;
        public int height;
        public double i0;
        public double j0;
        public final double[] i;
        public final double[] j;
        public final double[] ki;
        public final double[] kj;

        public Index(int m, int n) {
            this.i = new double[m];
            this.j = new double[m];
            this.ki = new double[n];
            this.kj = new double[n];
        }

        public static double crop(double i, double max) {
            return i < 0.0 ? 0.0 : (i > max ? max : i);
        }
    }

    public static interface Raster {
        public int getWidth();

        public int getHeight();

        public boolean getSamples(int[] var1, int[] var2, double[][] var3) throws Exception;
    }
}

