/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.draw;

import java.awt.BasicStroke;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Map;
import org.esa.beam.framework.draw.AbstractFigure;
import org.esa.beam.framework.draw.AreaFigure;
import org.esa.beam.framework.draw.LineFigure;
import org.esa.beam.util.Guardian;

@Deprecated
public class ShapeFigure
extends AbstractFigure {
    private final Shape shape;
    private final boolean oneDimensional;

    public ShapeFigure(Shape shape, boolean oneDimensional, Map<String, Object> attributes) {
        super(attributes);
        Guardian.assertNotNull("shape", shape);
        this.shape = shape;
        this.oneDimensional = oneDimensional;
    }

    @Override
    public Shape getShape() {
        return this.shape;
    }

    @Override
    public Area getAsArea() {
        if (this.getShape() instanceof Area) {
            return (Area)this.getShape();
        }
        if (this.isOneDimensional()) {
            return new Area(new BasicStroke(1.0f).createStrokedShape(this.getShape()));
        }
        return new Area(this.getShape());
    }

    @Override
    public Point2D getCenterPoint() {
        Rectangle2D bounds = this.getBounds();
        return new Point2D.Double(bounds.getCenterX(), bounds.getCenterY());
    }

    @Override
    public Rectangle2D getBounds() {
        return this.shape.getBounds2D();
    }

    @Override
    public boolean containsPoint(double x, double y) {
        return this.shape.contains(x, y);
    }

    @Override
    public boolean isOneDimensional() {
        return this.oneDimensional;
    }

    @Override
    public void draw(Graphics2D g2d) {
        if (!this.isOneDimensional()) {
            this.fillShape(g2d);
        }
        this.outlineShape(g2d);
    }

    public void fillShape(Graphics2D g2d) {
        boolean filled = false;
        Stroke strokeNew = null;
        Stroke strokeOld = null;
        Paint paintNew = null;
        Paint paintOld = null;
        Composite compositeNew = null;
        Composite compositeOld = null;
        Object value = this.getAttribute("fill_paint");
        if (value instanceof Paint) {
            paintNew = (Paint)value;
            paintOld = g2d.getPaint();
            g2d.setPaint(paintNew);
            filled = true;
        }
        if ((value = this.getAttribute("fill_stroke")) instanceof Stroke) {
            strokeNew = (Stroke)value;
            strokeOld = g2d.getStroke();
            g2d.setStroke(strokeNew);
            filled = true;
        }
        if ((value = this.getAttribute("fill_composite")) instanceof Composite) {
            compositeNew = (Composite)value;
            compositeOld = g2d.getComposite();
            g2d.setComposite(compositeNew);
        }
        if ((value = this.getAttribute("filled")) instanceof Boolean) {
            filled = (Boolean)value;
        }
        if (filled) {
            g2d.fill(this.shape);
        }
        if (compositeNew != null) {
            g2d.setComposite(compositeOld);
        }
        if (paintNew != null) {
            g2d.setPaint(paintOld);
        }
        if (strokeNew != null) {
            g2d.setStroke(strokeOld);
        }
    }

    public void outlineShape(Graphics2D g2d) {
        boolean outlined = false;
        Stroke strokeNew = null;
        Stroke strokeOld = null;
        Paint paintNew = null;
        Paint paintOld = null;
        Composite compositeNew = null;
        Composite compositeOld = null;
        Object value = this.getAttribute("outl_color");
        if (value instanceof Paint) {
            paintNew = (Paint)value;
            paintOld = g2d.getPaint();
            g2d.setPaint(paintNew);
            outlined = true;
        }
        if ((value = this.getAttribute("outl_stroke")) instanceof Stroke) {
            strokeNew = (Stroke)value;
            strokeOld = g2d.getStroke();
            g2d.setStroke(strokeNew);
            outlined = true;
        }
        if ((value = this.getAttribute("outl_composite")) instanceof Composite) {
            compositeNew = (Composite)value;
            compositeOld = g2d.getComposite();
            g2d.setComposite(compositeNew);
        }
        if ((value = this.getAttribute("outline")) instanceof Boolean) {
            outlined = (Boolean)value;
        }
        if (outlined) {
            g2d.draw(this.shape);
        }
        if (compositeNew != null) {
            g2d.setComposite(compositeOld);
        }
        if (paintNew != null) {
            g2d.setPaint(paintOld);
        }
        if (strokeNew != null) {
            g2d.setStroke(strokeOld);
        }
    }

    public static LineFigure createLine(float x1, float y1, float x2, float y2, Map<String, Object> attributes) {
        return new LineFigure(new Line2D.Float(x1, y1, x2, y2), attributes);
    }

    public static LineFigure createPolyline(GeneralPath path, Map<String, Object> attributes) {
        return new LineFigure(path, attributes);
    }

    public static AreaFigure createRectangleArea(float x, float y, float w, float h, Map<String, Object> attributes) {
        return new AreaFigure(new Rectangle2D.Float(x, y, w, h), attributes);
    }

    public static AreaFigure createEllipseArea(float x, float y, float w, float h, Map<String, Object> attributes) {
        return new AreaFigure(new Ellipse2D.Float(x, y, w, h), attributes);
    }

    public static AreaFigure createPolygonArea(GeneralPath path, Map<String, Object> attributes) {
        return new AreaFigure(path, attributes);
    }

    public static AreaFigure createArbitraryArea(Area area, Map<String, Object> attributes) {
        return new AreaFigure(area, attributes);
    }
}

