/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.param;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.InputVerifier;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import org.esa.beam.framework.param.ParamEditor;
import org.esa.beam.framework.param.ParamException;
import org.esa.beam.framework.param.ParamExceptionHandler;
import org.esa.beam.framework.param.ParamParseException;
import org.esa.beam.framework.param.ParamValidateException;
import org.esa.beam.framework.param.Parameter;
import org.esa.beam.util.Debug;

public abstract class AbstractParamEditor
implements ParamEditor,
ParamExceptionHandler {
    private final Parameter _parameter;
    private final DefaultInputVerifier _defaultInputVerifier;
    private JLabel _labelComponent;
    private JLabel _physUnitLabelComponent;
    private boolean _enabled;
    private boolean _ensureTrailingColon;
    private boolean _ensureLeadingSpace;

    protected AbstractParamEditor(Parameter parameter, boolean useDefaultVerifier) {
        this._parameter = parameter;
        this._defaultInputVerifier = useDefaultVerifier ? new DefaultInputVerifier() : null;
        this._labelComponent = null;
        this._enabled = true;
        this.initUI();
        this.updateUI();
    }

    @Override
    public Parameter getParameter() {
        return this._parameter;
    }

    @Override
    public JLabel getLabelComponent() {
        return this._labelComponent;
    }

    @Override
    public void setLabelComponent(JLabel labelComponent) {
        this._labelComponent = labelComponent;
        this.nameLabelComponent(this._labelComponent);
    }

    @Override
    public JLabel getPhysUnitLabelComponent() {
        return this._physUnitLabelComponent;
    }

    @Override
    public void setPhysUnitLabelComponent(JLabel labelComponent) {
        this._physUnitLabelComponent = labelComponent;
        this.nameUnitComponent(this._physUnitLabelComponent);
    }

    protected void setDefaultLabelComponent(boolean ensureTrailingColon) {
        String labelText = this.getParameter().getProperties().getLabel();
        if (labelText == null) {
            return;
        }
        this._ensureTrailingColon = ensureTrailingColon;
        labelText = this.ensureTrailingColon(labelText);
        JLabel label = new JLabel(labelText);
        String toolTipText = this.getParameter().getProperties().getDescription();
        if (toolTipText != null) {
            label.setToolTipText(toolTipText);
        }
        this.setLabelComponent(label);
    }

    private String ensureTrailingColon(String labelText) {
        if (this._ensureTrailingColon && !labelText.endsWith(": ")) {
            labelText = labelText.trim().endsWith(":") ? labelText.trim().concat(" ") : labelText.trim().concat(": ");
        }
        return labelText;
    }

    protected void setDefaultPhysUnitLabelComponent(boolean ensureLeadingSpace) {
        String labelText = this.getParameter().getProperties().getPhysicalUnit();
        if (labelText == null) {
            return;
        }
        this._ensureLeadingSpace = ensureLeadingSpace;
        labelText = this.ensureLeadingSpace(labelText);
        JLabel label = new JLabel(labelText);
        this.setPhysUnitLabelComponent(label);
    }

    private String ensureLeadingSpace(String labelText) {
        if (this._ensureLeadingSpace && !labelText.startsWith(" ")) {
            return " " + labelText;
        }
        return labelText;
    }

    @Override
    public boolean isEnabled() {
        return this._enabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (this._enabled == enabled) {
            return;
        }
        this._enabled = enabled;
        this.updateUI();
    }

    protected void initUI() {
        this.setDefaultLabelComponent(true);
        this.setDefaultPhysUnitLabelComponent(true);
    }

    @Override
    public void updateUI() {
        String labelText;
        if (this._labelComponent != null) {
            labelText = this.ensureTrailingColon(this.getParameter().getProperties().getLabel());
            this._labelComponent.setText(labelText);
            if (this._labelComponent.isEnabled() != this._enabled) {
                this._labelComponent.setEnabled(this._enabled);
            }
        }
        if (this._physUnitLabelComponent != null) {
            labelText = this.ensureLeadingSpace(this.getParameter().getProperties().getPhysicalUnit());
            this._physUnitLabelComponent.setText(labelText);
            if (this._physUnitLabelComponent.isEnabled() != this._enabled) {
                this._physUnitLabelComponent.setEnabled(this._enabled);
            }
        }
    }

    @Override
    public void reconfigureUI() {
        this.updateUI();
    }

    @Override
    public boolean handleParamException(ParamException e) {
        JComponent editorComponent = this.getEditorComponent();
        JOptionPane.showMessageDialog(editorComponent, e.getMessage(), "Input Error", 0);
        editorComponent.requestFocus();
        if (editorComponent instanceof JTextField) {
            ((JTextField)editorComponent).selectAll();
        } else if (editorComponent instanceof JComboBox) {
            ((JComboBox)editorComponent).getEditor().selectAll();
        } else if (editorComponent instanceof JPanel) {
            Component[] components;
            for (Component component : components = editorComponent.getComponents()) {
                if (!(component instanceof JTextField)) continue;
                JTextField jTextField = (JTextField)component;
                jTextField.requestFocus();
                jTextField.selectAll();
                break;
            }
        }
        return true;
    }

    protected InputVerifier getDefaultInputVerifier() {
        return this._defaultInputVerifier;
    }

    protected ActionListener getDefaultActionListener() {
        return this._defaultInputVerifier;
    }

    protected boolean setParameterValue(JTextComponent textComponent) {
        Debug.assertNotNull(textComponent);
        return this.getParameter().setValueAsText(textComponent.getText(), this.getExceptionHandler());
    }

    protected boolean checkParameterValue(JTextComponent textComponent) {
        Debug.assertNotNull(textComponent);
        try {
            Object value = this.getParameter().parseValue(textComponent.getText());
            this.getParameter().validateValue(value);
        }
        catch (ParamParseException e) {
            return false;
        }
        catch (ParamValidateException e) {
            return false;
        }
        return true;
    }

    @Override
    public ParamExceptionHandler getExceptionHandler() {
        return this;
    }

    @Override
    public JComponent getComponent() {
        return this.getEditorComponent();
    }

    protected void nameLabelComponent(JComponent component) {
        this.nameComponent(component, "Label");
    }

    protected void nameEditorComponent(JComponent component) {
        this.nameComponent(component, "Editor");
    }

    protected void nameUnitComponent(JComponent component) {
        this.nameComponent(component, "Unit");
    }

    protected void nameComponent(JComponent component, String suffix) {
        if (component != null && component.getName() == null) {
            component.setName(this.getParameter().getName() + "." + suffix);
        }
    }

    class DefaultInputVerifier
    extends InputVerifier
    implements ActionListener {
        private boolean _settingValue;

        DefaultInputVerifier() {
        }

        @Override
        public boolean verify(JComponent input) {
            Debug.trace("AbstractParamEditor: parameter '" + AbstractParamEditor.this.getParameter().getName() + "': DefaultInputVerifier.verify called");
            if (input instanceof JTextComponent) {
                return AbstractParamEditor.this.checkParameterValue((JTextComponent)input);
            }
            return false;
        }

        @Override
        public boolean shouldYieldFocus(JComponent input) {
            Debug.trace("AbstractParamEditor: parameter '" + AbstractParamEditor.this.getParameter().getName() + "': DefaultInputVerifier.shouldYieldFocus called");
            if (!this._settingValue && input instanceof JTextComponent) {
                this._settingValue = true;
                boolean success = AbstractParamEditor.this.setParameterValue((JTextComponent)input);
                this._settingValue = false;
                return success;
            }
            return true;
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            Debug.trace("AbstractParamEditor: parameter '" + AbstractParamEditor.this.getParameter().getName() + "': DefaultInputVerifier.actionPerformed called");
            if (event.getSource() instanceof JTextComponent) {
                AbstractParamEditor.this.setParameterValue((JTextComponent)event.getSource());
            }
        }
    }
}

