/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.param;

import java.util.logging.Logger;
import org.esa.beam.framework.param.ParamParseException;
import org.esa.beam.framework.param.ParamValidateException;
import org.esa.beam.framework.param.ParamValidator;
import org.esa.beam.framework.param.Parameter;
import org.esa.beam.util.Debug;
import org.esa.beam.util.logging.BeamLogManager;

public abstract class AbstractParamValidator
implements ParamValidator {
    protected Logger _logger = BeamLogManager.getSystemLogger();

    protected AbstractParamValidator() {
    }

    @Override
    public boolean equalValues(Parameter parameter, Object value1, Object value2) {
        if (value1 == value2) {
            return true;
        }
        if (value1 == null) {
            return value2 == null;
        }
        return value1.equals(value2);
    }

    protected void validateThatNullValueIsAllowed(Parameter parameter, Object value) throws ParamValidateException {
        Debug.assertNotNull(parameter);
        if (value == null && !parameter.getProperties().isNullValueAllowed()) {
            throw new ParamValidateException(parameter, "Value must not be null.");
        }
    }

    protected void validateThatValuesAreInValueSet(Parameter parameter, Object[] values) throws ParamValidateException {
        Debug.assertNotNull(parameter);
        Debug.assertNotNull(values);
        for (int i = 0; i < values.length; ++i) {
            this.validateThatValueIsInValueSet(parameter, values[i]);
        }
    }

    protected void validateThatValueIsInValueSet(Parameter parameter, Object value) throws ParamValidateException {
        Debug.assertNotNull(parameter);
        if (parameter.getProperties().getValueSet() != null && parameter.getProperties().isValueSetBound() && !this.isValueContainedInValueSet(parameter, value)) {
            throw new ParamValidateException(parameter, "Value is not allowed.");
        }
    }

    protected boolean isValueContainedInValueSet(Parameter parameter, Object value) {
        Debug.assertNotNull(parameter);
        String[] valueSet = parameter.getProperties().getValueSet();
        if (valueSet == null) {
            return false;
        }
        for (int i = 0; i < valueSet.length; ++i) {
            String valueSetEntry = valueSet[i];
            Object value2 = null;
            try {
                value2 = this.parse(parameter, valueSetEntry);
                if (!this.equalValues(parameter, value, value2)) continue;
                return true;
            }
            catch (ParamParseException e) {
                Debug.trace("Invalid value set entry for parameter '" + parameter.getName() + "'");
                Debug.trace(e);
                this._logger.fine("Invalid value set entry for parameter '" + parameter.getName() + "'");
                this._logger.fine(e.getMessage());
            }
        }
        return false;
    }

    protected static boolean isAllowedNullText(Parameter parameter, String text) {
        Debug.assertNotNull(parameter);
        Debug.assertNotNull(text);
        return text.trim().length() == 0 && parameter.getProperties().isNullValueAllowed();
    }

    protected static boolean isAllowedNullValue(Parameter parameter, Object value) {
        Debug.assertNotNull(parameter);
        return value == null && parameter.getProperties().isNullValueAllowed();
    }
}

