/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.param;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.filechooser.FileFilter;
import org.esa.beam.framework.param.ParamValidator;
import org.esa.beam.framework.param.ParamValidatorRegistry;
import org.esa.beam.util.Debug;
import org.esa.beam.util.Guardian;
import org.esa.beam.util.ObjectUtils;
import org.esa.beam.util.PropertyMap;
import org.esa.beam.util.StringUtils;

public class ParamProperties {
    public static final String VALUETYPE_KEY = "valueType";
    public static final String DEFAULTVALUE_KEY = "defaultValue";
    public static final String NUMCOLS_KEY = "numCols";
    public static final String NUMROWS_KEY = "numRows";
    public static final String WORD_WRAP_KEY = "wordWrap";
    public static final String MINVALUE_KEY = "minValue";
    public static final String MAXVALUE_KEY = "maxValue";
    public static final String INCREMENT_KEY = "increment";
    public static final String VALUESET_KEY = "valueSet";
    public static final String VALUESETBOUND_KEY = "valueSetBound";
    public static final String VALUESETDELIM_KEY = "valueSetDelim";
    public static final String NULLVALUEALLOWED_KEY = "nullValueAllowed";
    public static final String EMPTYVALUESNOTALLOWED_KEY = "emptyValueAllowed";
    public static final String IDENTIFIERSONLY_KEY = "namesOnly";
    public static final String CASESENSITIVE_KEY = "caseSensitive";
    public static final String READONLY_KEY = "readOnly";
    public static final String HIDDEN_KEY = "hidden";
    public static final String LABEL_KEY = "label";
    public static final String DESCRIPTION_KEY = "description";
    public static final String PHYSICALUNIT_KEY = "physUnit";
    public static final String VALIDATORCLASS_KEY = "validatorClass";
    public static final String EDITORCLASS_KEY = "editorClass";
    public static final String LISTMODEL_KEY = "listModel";
    public static final String FILE_SELECTION_MODE_KEY = "fsm";
    public static final String LAST_DIR_KEY = "lastDir";
    public static final String CHOOSABLE_FILE_FILTERS_KEY = "choosableFileFilters";
    public static final String CURRENT_FILE_FILTER_KEY = "currentFileFilter";
    public static final String COMP_PRODUCTS_FOR_BAND_ARITHMETHIK_KEY = "compatibleProductsForBandArithmethik";
    public static final String SEL_PRODUCT_FOR_BAND_ARITHMETHIK_KEY = "selectedProductForBandArithmethik";
    public static final String SELECT_ALL_ON_FOCUS_KEY = "selectAllOnFocus";
    public static final int FSM_FILES_ONLY = 0;
    public static final int FSM_DIRECTORIES_ONLY = 1;
    public static final int FSM_FILES_AND_DIRECTORIES = 2;
    private Map<String, Object> _propertyMap;
    private PropertyChangeSupport _propertyChangeSupport;

    public ParamProperties() {
    }

    public ParamProperties(Class valueType) {
        this(valueType, null);
    }

    public ParamProperties(Class valueType, Object defaultValue) {
        this(valueType, defaultValue, null);
    }

    public ParamProperties(Class valueType, Object defaultValue, String[] valueSet) {
        this(valueType, defaultValue, valueSet, false);
    }

    public ParamProperties(Class valueType, Object defaultValue, String[] valueSet, boolean valueSetBound) {
        this.setValueType(valueType);
        this.setDefaultValue(defaultValue);
        this.setValueSet(valueSet);
        this.setValueSetBound(valueSetBound);
    }

    public ParamProperties(Class valueType, Number defaultValue, Number minValue, Number maxValue) {
        this(valueType, defaultValue, minValue, maxValue, null);
    }

    public ParamProperties(Class valueType, Number defaultValue, Number minValue, Number maxValue, Number increment) {
        this.setValueType(valueType);
        this.setDefaultValue(defaultValue);
        this.setMinValue(minValue);
        this.setMaxValue(maxValue);
        this.setIncrement(increment);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this._propertyChangeSupport == null) {
            this._propertyChangeSupport = new PropertyChangeSupport(this);
        }
        this._propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this._propertyChangeSupport == null) {
            return;
        }
        this._propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public void setValueType(Class valueType) {
        this.setPropertyValue(VALUETYPE_KEY, valueType);
    }

    public Class getValueType() {
        return this.convertClassValue(VALUETYPE_KEY);
    }

    public void setValidatorClass(Class validatorClass) {
        this.setPropertyValue(VALIDATORCLASS_KEY, validatorClass);
    }

    public Class getValidatorClass() {
        return this.convertClassValue(VALIDATORCLASS_KEY);
    }

    public void setEditorClass(Class editorClass) {
        this.setPropertyValue(EDITORCLASS_KEY, editorClass);
    }

    public Class getEditorClass() {
        return this.convertClassValue(EDITORCLASS_KEY);
    }

    public void setDefaultValue(Object defaultValue) {
        this.setPropertyValue(DEFAULTVALUE_KEY, defaultValue);
    }

    public Object getDefaultValue() {
        return this.getPropertyValue(DEFAULTVALUE_KEY);
    }

    public void setNumCols(int numCols) {
        this.setPropertyValue(NUMCOLS_KEY, numCols);
    }

    public int getNumCols() {
        Number n = this.convertNumberValue(NUMCOLS_KEY);
        return n != null ? n.intValue() : 0;
    }

    public void setNumRows(int numRows) {
        this.setPropertyValue(NUMROWS_KEY, numRows);
    }

    public int getNumRows() {
        Number n = this.convertNumberValue(NUMROWS_KEY);
        return n != null ? n.intValue() : 0;
    }

    public void setMinValue(Number minValue) {
        this.setPropertyValue(MINVALUE_KEY, minValue);
    }

    public Number getMinValue() {
        return this.convertNumberValue(MINVALUE_KEY);
    }

    public void setMaxValue(Number maxValue) {
        this.setPropertyValue(MAXVALUE_KEY, maxValue);
    }

    public Number getMaxValue() {
        return this.convertNumberValue(MAXVALUE_KEY);
    }

    public void setIncrement(Number increment) {
        this.setPropertyValue(INCREMENT_KEY, increment);
    }

    public Number getIncrement() {
        return this.convertNumberValue(INCREMENT_KEY);
    }

    public void setValueSet(String[] valueSet) {
        this.setPropertyValue(VALUESET_KEY, valueSet);
    }

    public String[] getValueSet() {
        return this.convertStringArrayValue(VALUESET_KEY);
    }

    public void setValueSetDelim(char delim) {
        this.setPropertyValue(VALUESETDELIM_KEY, new Character(delim));
    }

    public char getValueSetDelim() {
        String delimStr;
        char delim = ',';
        Object delimValue = this.getPropertyValue(VALUESETDELIM_KEY);
        if (delimValue != null && (delimStr = delimValue.toString()).length() > 0) {
            delim = delimStr.charAt(0);
        }
        return delim;
    }

    public void setValueSetBound(boolean valueSetBound) {
        this.setPropertyValue(VALUESETBOUND_KEY, valueSetBound);
    }

    public boolean isValueSetBound() {
        return this.getPropertyValue(VALUESETBOUND_KEY, false);
    }

    public void setNullValueAllowed(boolean nullAllowed) {
        this.setPropertyValue(NULLVALUEALLOWED_KEY, nullAllowed);
    }

    public boolean isNullValueAllowed() {
        return this.getPropertyValue(NULLVALUEALLOWED_KEY, false);
    }

    public void setEmptyValuesNotAllowed(boolean emptyAllowed) {
        this.setPropertyValue(EMPTYVALUESNOTALLOWED_KEY, emptyAllowed);
    }

    public boolean isEmptyValuesNotAllowed() {
        return this.getPropertyValue(EMPTYVALUESNOTALLOWED_KEY, false);
    }

    public void setIdentifiersOnly(boolean identifiersOnly) {
        this.setPropertyValue(IDENTIFIERSONLY_KEY, identifiersOnly);
    }

    public boolean isIdentifiersOnly() {
        return this.getPropertyValue(IDENTIFIERSONLY_KEY, false);
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.setPropertyValue(CASESENSITIVE_KEY, caseSensitive);
    }

    public boolean isCaseSensitive() {
        return this.getPropertyValue(CASESENSITIVE_KEY, true);
    }

    public void setReadOnly(boolean readOnly) {
        this.setPropertyValue(READONLY_KEY, readOnly);
    }

    public boolean isReadOnly() {
        return this.getPropertyValue(READONLY_KEY, false);
    }

    public void setHidden(boolean hidden) {
        this.setPropertyValue(HIDDEN_KEY, hidden);
    }

    public boolean isHidden() {
        return this.getPropertyValue(HIDDEN_KEY, false);
    }

    public void setLabel(String label) {
        this.setPropertyValue(LABEL_KEY, label);
    }

    public String getLabel() {
        return this.getPropertyValue(LABEL_KEY, "");
    }

    public void setDescription(String description) {
        this.setPropertyValue(DESCRIPTION_KEY, description);
    }

    public String getDescription() {
        return this.convertStringValue(DESCRIPTION_KEY);
    }

    public void setPhysicalUnit(String unit) {
        this.setPropertyValue(PHYSICALUNIT_KEY, unit);
    }

    public String getPhysicalUnit() {
        return this.convertStringValue(PHYSICALUNIT_KEY);
    }

    public void setFileSelectionMode(int fsm) {
        this.setPropertyValue(FILE_SELECTION_MODE_KEY, fsm);
    }

    public int getFileSelectionMode() {
        return this.getPropertyValue(FILE_SELECTION_MODE_KEY, 2);
    }

    public void setCurrentFileFilter(FileFilter filter) {
        this.setPropertyValue(CURRENT_FILE_FILTER_KEY, filter);
    }

    public FileFilter getCurrentFileFilter() {
        return (FileFilter)this.getPropertyValue(CURRENT_FILE_FILTER_KEY);
    }

    public void setChoosableFileFilters(FileFilter[] filters) {
        this.setPropertyValue(CHOOSABLE_FILE_FILTERS_KEY, filters);
    }

    public FileFilter[] getChoosableFileFilters() {
        return (FileFilter[])this.getPropertyValue(CHOOSABLE_FILE_FILTERS_KEY);
    }

    public void setPropertyValue(String key, boolean value) {
        this.setPropertyValue(key, (Object)value);
    }

    public void setPropertyValue(String key, int value) {
        this.setPropertyValue(key, new Integer(value));
    }

    public void setPropertyValue(String key, long value) {
        this.setPropertyValue(key, new Long(value));
    }

    public void setPropertyValue(String key, float value) {
        this.setPropertyValue(key, new Float(value));
    }

    public void setPropertyValue(String key, double value) {
        this.setPropertyValue(key, new Double(value));
    }

    public void setPropertyValue(String key, Object value) {
        Object oldValue = null;
        if (this._propertyChangeSupport != null) {
            oldValue = this.getPropertyValue(key);
        }
        if (this._propertyMap == null) {
            this._propertyMap = this.createPropertyMap(null);
        }
        this._propertyMap.put(key, value);
        if (this._propertyChangeSupport != null && !ObjectUtils.equalObjects(oldValue, value)) {
            this._propertyChangeSupport.firePropertyChange(key, oldValue, value);
        }
    }

    public void setPropertyValues(String paramName, PropertyMap propertyMap) {
        String namePrefix = paramName + ".";
        Enumeration e = propertyMap.getPropertyKeys();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            if (!name.startsWith(namePrefix)) continue;
            String paramPropName = name.substring(namePrefix.length());
            String paramPropValue = propertyMap.getPropertyString(name);
            this.setPropertyValue(paramPropName, paramPropValue);
        }
    }

    public Map<String, Object> getProperties(String namePrefix) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        Set<Map.Entry<String, Object>> entrySet = this._propertyMap.entrySet();
        for (Map.Entry<String, Object> entry : entrySet) {
            String key = entry.getKey();
            if (!key.startsWith(namePrefix)) continue;
            properties.put(key, entry.getValue());
        }
        return properties;
    }

    public Object getPropertyValue(String key) {
        Guardian.assertNotNull("key", key);
        return this._propertyMap != null ? this._propertyMap.get(key) : null;
    }

    public boolean containsProperty(String key) {
        return this.getPropertyValue(key) != null;
    }

    public boolean getPropertyValue(String key, boolean defaultValue) {
        Boolean boolValue = this.convertBooleanValue(key);
        return boolValue != null ? boolValue : defaultValue;
    }

    public int getPropertyValue(String key, int defaultValue) {
        Number numberValue = this.convertNumberValue(key);
        return numberValue != null ? numberValue.intValue() : defaultValue;
    }

    public double getPropertyValue(String key, double defaultValue) {
        Number numberValue = this.convertNumberValue(key);
        return numberValue != null ? numberValue.doubleValue() : defaultValue;
    }

    public Class getPropertyValue(String key, Class defaultValue) {
        Class classValue = this.convertClassValue(key);
        return classValue != null ? classValue : defaultValue;
    }

    public String getPropertyValue(String key, String defaultValue) {
        String stringValue = this.convertStringValue(key);
        return stringValue != null ? stringValue : defaultValue;
    }

    public Object getPropertyValue(String key, Object defaultValue) {
        Object objectValue = this.getPropertyValue(key);
        return objectValue != null ? objectValue : defaultValue;
    }

    public ParamValidator createValidator() {
        ParamValidator validator = null;
        Class validatorClass = this.getValidatorClass();
        if (validatorClass != null) {
            try {
                validator = (ParamValidator)validatorClass.newInstance();
            }
            catch (Exception e) {
                Debug.trace(e);
            }
        }
        if (validator == null) {
            validator = ParamValidatorRegistry.getValidator(this.getValueType());
        }
        Debug.assertTrue(validator != null);
        return validator;
    }

    public ParamProperties createCopy() {
        ParamProperties copy = new ParamProperties();
        copy._propertyMap = this.createPropertyMap(this._propertyMap);
        copy._propertyChangeSupport = this._propertyChangeSupport;
        return copy;
    }

    protected Map<String, Object> createPropertyMap(Map<String, Object> map) {
        if (map != null) {
            return new HashMap<String, Object>(map);
        }
        return new HashMap<String, Object>();
    }

    protected Class loadClass(String className) throws ClassNotFoundException {
        return this.getClass().getClassLoader().loadClass(className);
    }

    private Class convertClassValue(String key) {
        Object value = this.getPropertyValue(key);
        Class classValue = null;
        if (value != null) {
            if (value instanceof Class) {
                classValue = (Class)value;
            } else if (value instanceof String) {
                try {
                    classValue = this.loadClass((String)value);
                    this.setPropertyValue(key, classValue);
                }
                catch (ClassNotFoundException e) {
                    Debug.trace(key + " = " + value + ": class could not be loaded");
                    Debug.trace(e);
                }
            }
        }
        return classValue;
    }

    private Boolean convertBooleanValue(String key) {
        Object value = this.getPropertyValue(key);
        Boolean booleanValue = null;
        if (value != null) {
            if (value instanceof Boolean) {
                booleanValue = (Boolean)value;
            } else if (value instanceof String) {
                booleanValue = Boolean.valueOf(value.toString());
                this.setPropertyValue(key, booleanValue);
            }
        }
        return booleanValue;
    }

    private String convertStringValue(String key) {
        Object value = this.getPropertyValue(key);
        String stringValue = null;
        if (value != null) {
            if (value instanceof String) {
                stringValue = (String)value;
            } else {
                stringValue = value.toString();
                this.setPropertyValue(key, stringValue);
            }
        }
        return stringValue;
    }

    private Number convertNumberValue(String key) {
        Object value = this.getPropertyValue(key);
        Number numberValue = null;
        if (value != null) {
            if (value instanceof Number) {
                numberValue = (Number)value;
            } else if (value instanceof String) {
                try {
                    numberValue = Integer.valueOf(value.toString());
                    this.setPropertyValue(key, numberValue);
                }
                catch (Exception e1) {
                    try {
                        numberValue = Double.valueOf(value.toString());
                        this.setPropertyValue(key, numberValue);
                    }
                    catch (Exception e2) {
                        Debug.trace(key + " = " + value + ": numeric value expected");
                        Debug.trace(e2);
                    }
                }
            }
        }
        return numberValue;
    }

    private String[] convertStringArrayValue(String key) {
        Object value = this.getPropertyValue(key);
        String[] arrayValue = null;
        if (value != null) {
            if (value instanceof String[]) {
                arrayValue = (String[])value;
            } else if (value instanceof String) {
                char separator = this.getValueSetDelim();
                arrayValue = StringUtils.split(value.toString(), new char[]{separator}, true);
                this.setPropertyValue(key, arrayValue);
            }
        }
        return arrayValue;
    }
}

