/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.param;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.event.EventListenerList;
import org.esa.beam.framework.param.ParamChangeEvent;
import org.esa.beam.framework.param.ParamChangeListener;
import org.esa.beam.framework.param.ParamEditor;
import org.esa.beam.framework.param.ParamEditorFactory;
import org.esa.beam.framework.param.ParamException;
import org.esa.beam.framework.param.ParamExceptionHandler;
import org.esa.beam.framework.param.ParamFormatException;
import org.esa.beam.framework.param.ParamParseException;
import org.esa.beam.framework.param.ParamProperties;
import org.esa.beam.framework.param.ParamValidateException;
import org.esa.beam.framework.param.ParamValidator;
import org.esa.beam.util.Guardian;
import org.esa.beam.util.PropertyMap;

@Deprecated
public class Parameter {
    private final String _name;
    private ParamProperties _properties;
    private Object _value;
    private EventListenerList _listenerList;
    private PropertyChangeListener _propertyChangeListener;
    private ParamEditor _editor;
    private boolean _uiEnabled;
    private ParamValidator _validator;

    public Parameter(String name) {
        this(name, null, null);
    }

    public Parameter(String name, Object value) {
        this(name, value, null);
    }

    public Parameter(String name, ParamProperties properties) {
        this(name, null, properties, true);
    }

    public Parameter(String name, Object value, ParamProperties properties) {
        this(name, value, properties, false);
    }

    private Parameter(String name, Object value, ParamProperties properties, boolean useDefaultValue) {
        Guardian.assertNotNullOrEmpty("name", name);
        this._name = name;
        this._value = value == null && properties != null && useDefaultValue ? properties.getDefaultValue() : value;
        this._properties = properties != null ? properties : new ParamProperties();
        this._uiEnabled = true;
        this._propertyChangeListener = this.createParamPropertiesPropertyChangeListener();
        this._properties.addPropertyChangeListener(this._propertyChangeListener);
        if (this._properties.getValueType() == null && this._value != null) {
            this._properties.setValueType(this._value.getClass());
        }
        if (this._properties.getDefaultValue() == null && this._value != null) {
            this._properties.setDefaultValue(this._value);
        }
    }

    public String getName() {
        return this._name;
    }

    public Class getType() {
        return this.getProperties().getValueType();
    }

    public Object getValue() {
        return this._value;
    }

    public void setValue(Object newValue) throws ParamValidateException {
        if (this.equalsValue(newValue)) {
            return;
        }
        this.validateValue(newValue);
        Object oldValue = this.getValue();
        this._value = newValue;
        this.fireParamValueChanged(this, oldValue);
        this.updateUI();
    }

    public boolean setValue(Object newValue, ParamExceptionHandler handler) {
        try {
            this.setValue(newValue);
            return true;
        }
        catch (ParamValidateException e) {
            this.handleParamException(handler, e);
            return false;
        }
    }

    public void setDefaultValue() {
        Object defaultValue = this.getProperties().getDefaultValue();
        if (!this.isLegalValue(defaultValue) && defaultValue instanceof String) {
            this.setValueAsText((String)defaultValue, null);
        } else {
            this.setValue(defaultValue, null);
        }
    }

    public Class getValueType() {
        Class<String> valueType = this.getProperties().getValueType();
        return valueType != null ? valueType : String.class;
    }

    public boolean isTypeOf(Class valueType) {
        return valueType.isAssignableFrom(this.getValueType());
    }

    public boolean isLegalValue(Object value) {
        try {
            this.validateValue(value);
            return true;
        }
        catch (ParamValidateException e) {
            return false;
        }
    }

    public ParamProperties getProperties() {
        return this._properties;
    }

    public void setProperties(ParamProperties properties) {
        Guardian.assertNotNull("properties", properties);
        this._properties.removePropertyChangeListener(this._propertyChangeListener);
        this._properties = properties;
        this._properties.addPropertyChangeListener(this._propertyChangeListener);
        if (this._editor != null) {
            this._editor.updateUI();
            this._editor.reconfigureUI();
        }
    }

    public void setValueAsText(String textValue) throws ParamParseException, ParamValidateException {
        Object value = this.parseValue(textValue);
        this.setValue(value);
    }

    public boolean setValueAsText(String textValue, ParamExceptionHandler handler) {
        try {
            this.setValueAsText(textValue);
            return true;
        }
        catch (ParamException e) {
            this.handleParamException(handler, e);
            return false;
        }
    }

    public String getValueAsText() {
        try {
            return this.formatValue(this.getValue());
        }
        catch (ParamFormatException e) {
            return "";
        }
    }

    public Object parseValue(String text) throws ParamParseException {
        return this.getValidator().parse(this, text);
    }

    public String formatValue(Object value) throws ParamFormatException {
        return this.getValidator().format(this, value);
    }

    public void validateValue(Object value) throws ParamValidateException {
        this.getValidator().validate(this, value);
    }

    public boolean equalsValue(Object value) {
        return this.getValidator().equalValues(this, this.getValue(), value);
    }

    public void setPropertyValues(PropertyMap propertyMap) {
        this.getProperties().setPropertyValues(this.getName(), propertyMap);
    }

    public ParamValidator getValidator() {
        if (this._validator == null) {
            this._validator = this.createValidator();
        }
        return this._validator;
    }

    protected ParamValidator createValidator() {
        return this.getProperties().createValidator();
    }

    public ParamEditor getEditor() {
        if (this._editor == null) {
            this._editor = this.createEditor();
        }
        return this._editor;
    }

    public boolean isUIEnabled() {
        if (this._editor != null) {
            return this._editor.isEnabled();
        }
        return false;
    }

    public void setUIEnabled(boolean enabled) {
        this._uiEnabled = enabled;
        if (this._editor != null) {
            this._editor.setEnabled(enabled);
        }
    }

    public void updateUI() {
        if (this._editor != null) {
            this._editor.updateUI();
        }
    }

    protected ParamEditor createEditor() {
        ParamEditor editor = ParamEditorFactory.createParamEditor(this);
        if (editor != null) {
            editor.setEnabled(this._uiEnabled);
        }
        return editor;
    }

    public void setValueSet(String[] valueSet) {
        this.getProperties().setValueSet(valueSet);
        if (this._editor != null) {
            this._editor.reconfigureUI();
        }
    }

    public void addParamChangeListener(ParamChangeListener listener) {
        if (listener != null) {
            if (this._listenerList == null) {
                this._listenerList = new EventListenerList();
            }
            this._listenerList.add(ParamChangeListener.class, listener);
        }
    }

    public void removeParamChangeListener(ParamChangeListener listener) {
        if (listener != null && this._listenerList != null) {
            this._listenerList.add(ParamChangeListener.class, listener);
        }
    }

    protected void fireParamValueChanged(Parameter parameter, Object oldValue) {
        if (this._listenerList == null) {
            return;
        }
        ParamChangeEvent event = null;
        Object[] listeners = this._listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ParamChangeListener.class) continue;
            if (event == null) {
                event = new ParamChangeEvent(this, parameter, oldValue);
            }
            ((ParamChangeListener)listeners[i + 1]).parameterValueChanged(event);
        }
    }

    private PropertyChangeListener createParamPropertiesPropertyChangeListener() {
        return new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (Parameter.this._editor != null) {
                    Parameter.this._editor.reconfigureUI();
                }
            }
        };
    }

    private void handleParamException(ParamExceptionHandler handler, ParamException e) {
        boolean handled = false;
        if (handler != null) {
            handled = handler.handleParamException(e);
        }
        if (!handled) {
            throw new IllegalArgumentException("illegal value for parameter '" + this.getName() + "': " + e.getMessage());
        }
    }
}

