/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.param.editors;

import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.EventListener;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.esa.beam.framework.param.AbstractParamEditor;
import org.esa.beam.framework.param.Parameter;
import org.esa.beam.framework.param.validators.StringArrayValidator;
import org.esa.beam.util.Debug;
import org.esa.beam.util.StringUtils;

public class ListEditor
extends AbstractParamEditor {
    private JList _list;
    private JScrollPane _listScrollPane;

    public ListEditor(Parameter parameter) {
        super(parameter, false);
    }

    public JList getList() {
        return this._list;
    }

    public JScrollPane getListScrollPane() {
        return this._listScrollPane;
    }

    @Override
    public JComponent getEditorComponent() {
        return this.getListScrollPane();
    }

    @Override
    protected void initUI() {
        this.setDefaultLabelComponent(true);
        this._list = new JList();
        this.nameEditorComponent(this._list);
        this._listScrollPane = new JScrollPane(this._list);
        this.nameComponent(this._listScrollPane, "ScrollPane");
        this._listScrollPane.setAutoscrolls(true);
        this._listScrollPane.setHorizontalScrollBarPolicy(30);
        this._listScrollPane.setVerticalScrollBarPolicy(20);
        if (this.getParameter().getProperties().getDescription() != null) {
            this._list.setToolTipText(this.getParameter().getProperties().getDescription());
        }
        this._list.setListData(this.getParameter().getProperties().getValueSet());
        this._list.setEnabled(!this.getParameter().getProperties().isReadOnly());
        this._list.setVisibleRowCount(6);
        this._list.setSelectionMode(2);
        this.setSelectedIndices(this.getParameter());
        this._list.addListSelectionListener(this.createListSelectionListener());
        this._list.addFocusListener(this.createListFocusListener());
    }

    @Override
    public void updateUI() {
        super.updateUI();
        EventListener[] li = this._list.getListeners(ListSelectionListener.class);
        this.removeListSelectionListener(li);
        this.setSelectedIndices(this.getParameter());
        this.addListSelectionListener(li);
        if (this._list.isEnabled() != this.isEnabled()) {
            this._list.setEnabled(this.isEnabled());
        }
    }

    @Override
    public void reconfigureUI() {
        EventListener[] li = this._list.getListeners(ListSelectionListener.class);
        this.removeListSelectionListener(li);
        this._list.setListData(this.getParameter().getProperties().getValueSet());
        this.setSelectedIndices(this.getParameter());
        this.addListSelectionListener(li);
    }

    private FocusAdapter createListFocusListener() {
        return new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                JList list = (JList)e.getSource();
                Object[] values = list.getSelectedValues();
                if (values.length == 0) {
                    ListEditor.this.getParameter().setValue(null, ListEditor.this.getExceptionHandler());
                } else {
                    ListEditor.this.getParameter().setValue(StringUtils.toStringArray(values), ListEditor.this.getExceptionHandler());
                }
            }
        };
    }

    private ListSelectionListener createListSelectionListener() {
        return new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                JList list = (JList)e.getSource();
                Object[] values = list.getSelectedValues();
                if (values.length == 0) {
                    ListEditor.this.getParameter().setValue(null, ListEditor.this.getExceptionHandler());
                } else {
                    ListEditor.this.getParameter().setValue(StringUtils.toStringArray(values), ListEditor.this.getExceptionHandler());
                }
            }
        };
    }

    private void addListSelectionListener(EventListener[] li) {
        for (int i = 0; i < li.length; ++i) {
            this._list.addListSelectionListener((ListSelectionListener)li[i]);
        }
    }

    private void removeListSelectionListener(EventListener[] li) {
        for (int i = 0; i < li.length; ++i) {
            this._list.removeListSelectionListener((ListSelectionListener)li[i]);
        }
    }

    private void setSelectedIndices(Parameter parameter) {
        if (parameter.getValue() != null) {
            Debug.assertTrue(parameter.getValue() instanceof String[]);
            Debug.assertTrue(parameter.getValidator() instanceof StringArrayValidator);
            int[] indexes = ((StringArrayValidator)parameter.getValidator()).getValueSetIndices(parameter);
            this._list.setSelectedIndices(indexes);
        }
    }
}

