/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.param.validators;

import java.awt.Color;
import org.esa.beam.framework.param.AbstractParamValidator;
import org.esa.beam.framework.param.ParamFormatException;
import org.esa.beam.framework.param.ParamParseException;
import org.esa.beam.framework.param.ParamValidateException;
import org.esa.beam.framework.param.Parameter;
import org.esa.beam.util.Debug;
import org.esa.beam.util.StringUtils;

public class ColorValidator
extends AbstractParamValidator {
    @Override
    public Object parse(Parameter parameter, String text) throws ParamParseException {
        Debug.assertTrue(text != null);
        if (ColorValidator.isAllowedNullText(parameter, text.trim())) {
            return null;
        }
        Color c = StringUtils.parseColor(text);
        if (c == null) {
            throw new ParamParseException(parameter, "Color value must have the form R,G,B or R,G,B,Alpha (decimal)\nor #RRGGBB or #RRGGBBAA (hexadecimal).");
        }
        return c;
    }

    @Override
    public String format(Parameter parameter, Object value) throws ParamFormatException {
        if (ColorValidator.isAllowedNullValue(parameter, value)) {
            return "";
        }
        Color c = ColorValidator.castToColor(value);
        if (c == null) {
            throw new ParamFormatException(parameter, "Value must be of type 'Color'");
        }
        return StringUtils.formatColor(c);
    }

    @Override
    public void validate(Parameter parameter, Object value) throws ParamValidateException {
        this.validateThatNullValueIsAllowed(parameter, value);
        if (value == null) {
            return;
        }
        Color colorValue = ColorValidator.castToColor(value);
        if (colorValue == null) {
            throw new ParamValidateException(parameter, "Value must be a R,G,B color.");
        }
        this.validateThatValueIsInValueSet(parameter, value);
    }

    @Override
    public boolean equalValues(Parameter parameter, Object value1, Object value2) {
        Color c2;
        Color c1 = ColorValidator.castToColor(value1);
        if (c1 == (c2 = ColorValidator.castToColor(value2))) {
            return true;
        }
        if (c1 == null && c2 != null) {
            return false;
        }
        if (c1 != null && c2 == null) {
            return false;
        }
        return c1.equals(c2);
    }

    protected static Color castToColor(Object value) {
        return value instanceof Color ? (Color)value : null;
    }
}

