/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.glayer;

import com.bc.ceres.binding.ConversionException;
import com.bc.ceres.binding.Converter;
import com.bc.ceres.binding.ConverterRegistry;
import com.bc.ceres.binding.ValidationException;
import com.bc.ceres.binding.dom.DefaultDomConverter;
import com.bc.ceres.binding.dom.DomConverter;
import com.bc.ceres.binding.dom.DomElement;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.util.HashMap;
import java.util.Map;
import org.esa.beam.framework.draw.AbstractFigure;
import org.esa.beam.framework.draw.AreaFigure;
import org.esa.beam.framework.draw.LineFigure;
import org.esa.beam.framework.draw.ShapeFigure;

public class AbstractFigureDomConverter
implements DomConverter {
    public Class<?> getValueType() {
        return AbstractFigure.class;
    }

    public AbstractFigure convertDomToValue(DomElement parentElement, Object figure) throws ConversionException, ValidationException {
        String className = parentElement.getAttribute("class");
        Shape shapeObject = this.convertDomToShape(parentElement);
        Map<String, Object> attributes = this.convertDomToAttributes(parentElement);
        if (LineFigure.class.getName().equals(className)) {
            return new LineFigure(shapeObject, attributes);
        }
        if (AreaFigure.class.getName().equals(className)) {
            return new AreaFigure(shapeObject, attributes);
        }
        if (ShapeFigure.class.getName().equals(className)) {
            DomElement dimensionalChild = (DomElement)parentElement.getChild("oneDimensional");
            boolean oneDimensional = Boolean.valueOf(dimensionalChild.getValue());
            return new ShapeFigure(shapeObject, oneDimensional, attributes);
        }
        return null;
    }

    public void convertValueToDom(Object value, DomElement parentElement) throws ConversionException {
        Class<?> valueType = value.getClass();
        parentElement.setAttribute("class", valueType.getName());
        AbstractFigure figure = (AbstractFigure)value;
        Shape figureShape = figure.getShape();
        this.convertShapeToDom(figureShape, parentElement);
        Map<String, Object> attributes = figure.getAttributes();
        this.convertAttributesToDom(attributes, parentElement);
        if (valueType == ShapeFigure.class) {
            ShapeFigure shapeFigure = (ShapeFigure)value;
            DomElement dimensionalChild = parentElement.createChild("oneDimensional");
            dimensionalChild.setValue(String.valueOf(shapeFigure.isOneDimensional()));
        }
    }

    private void convertShapeToDom(Shape figureShape, DomElement parentElement) throws ConversionException {
        DomElement shapeChild = parentElement.createChild("shape");
        shapeChild.setAttribute("class", figureShape.getClass().getName());
        DefaultDomConverter domConverter = new DefaultDomConverter(Shape.class);
        domConverter.convertValueToDom((Object)figureShape, shapeChild);
    }

    private Shape convertDomToShape(DomElement parentElement) throws ConversionException, ValidationException {
        DomElement shapeChild = (DomElement)parentElement.getChild("shape");
        DefaultDomConverter domConverter = new DefaultDomConverter(Shape.class);
        return (Shape)domConverter.convertDomToValue(shapeChild, null);
    }

    private void convertAttributesToDom(Map<String, Object> attributes, DomElement parentElement) throws ConversionException {
        Stroke outlineStroke;
        Composite outlineComposite;
        Paint outlinePaint;
        Boolean outlined;
        Stroke fillStroke;
        Paint fillPaint;
        Composite fillComposite;
        DomElement attrChild = parentElement.createChild("attributes");
        Boolean filled = (Boolean)attributes.get("filled");
        if (filled != null) {
            this.convertAttributeToDom(attrChild, "filled", filled);
        }
        if ((fillComposite = (Composite)attributes.get("fill_composite")) != null && fillComposite instanceof AlphaComposite) {
            AlphaComposite alphaComposite = (AlphaComposite)fillComposite;
            this.convertAttributeToDom(attrChild, "fillTransparency", Float.valueOf(alphaComposite.getAlpha()));
        }
        if ((fillPaint = (Paint)attributes.get("fill_paint")) != null && fillPaint instanceof Color) {
            this.convertAttributeToDom(attrChild, "fillColor", fillPaint);
        }
        if ((fillStroke = (Stroke)attributes.get("fill_stroke")) != null && fillStroke instanceof BasicStroke) {
            BasicStrokeDomConverter strokeDomConverter = new BasicStrokeDomConverter();
            DomElement fillStrokeElement = attrChild.createChild("fillStroke");
            strokeDomConverter.convertValueToDom(fillStroke, fillStrokeElement);
        }
        if ((outlined = (Boolean)attributes.get("outline")) != null) {
            this.convertAttributeToDom(attrChild, "outlined", outlined);
        }
        if ((outlinePaint = (Paint)attributes.get("outl_color")) != null && outlinePaint instanceof Color) {
            this.convertAttributeToDom(attrChild, "outlineColor", outlinePaint);
        }
        if ((outlineComposite = (Composite)attributes.get("outl_composite")) != null && outlineComposite instanceof AlphaComposite) {
            AlphaComposite alphaComposite = (AlphaComposite)outlineComposite;
            this.convertAttributeToDom(attrChild, "outlineTransparency", Float.valueOf(alphaComposite.getAlpha()));
        }
        if ((outlineStroke = (Stroke)attributes.get("outl_stroke")) != null && outlineStroke instanceof BasicStroke) {
            BasicStrokeDomConverter strokeDomConverter = new BasicStrokeDomConverter();
            DomElement outlineStrokeElement = attrChild.createChild("outlineStroke");
            strokeDomConverter.convertValueToDom(outlineStroke, outlineStrokeElement);
        }
    }

    private void convertAttributeToDom(DomElement parentChild, String elementName, Object attributeValue) {
        ConverterRegistry converterRegistry = ConverterRegistry.getInstance();
        Converter converter = converterRegistry.getConverter(attributeValue.getClass());
        DomElement domElement = parentChild.createChild(elementName);
        domElement.setValue(converter.format(attributeValue));
    }

    private Map<String, Object> convertDomToAttributes(DomElement parentElement) throws ConversionException, ValidationException {
        DomElement outlineStrokeElement;
        DomElement outlineTransparencyElement;
        DomElement outlineColorElement;
        DomElement outlinedElement;
        DomElement fillStrokeElement;
        DomElement fillColorElement;
        DomElement fillTransparencyElement;
        ConverterRegistry converterRegistry = ConverterRegistry.getInstance();
        DomElement attrChild = (DomElement)parentElement.getChild("attributes");
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        DomElement filledElement = (DomElement)attrChild.getChild("filled");
        if (filledElement != null) {
            Converter converter = converterRegistry.getConverter(Boolean.class);
            attributes.put("filled", converter.parse(filledElement.getValue()));
        }
        if ((fillTransparencyElement = (DomElement)attrChild.getChild("fillTransparency")) != null) {
            Converter converter = converterRegistry.getConverter(Float.class);
            Float transparency = (Float)converter.parse(fillTransparencyElement.getValue());
            attributes.put("fill_composite", AlphaComposite.SrcOver.derive(transparency.floatValue()));
        }
        if ((fillColorElement = (DomElement)attrChild.getChild("fillColor")) != null) {
            Converter converter = converterRegistry.getConverter(Color.class);
            attributes.put("fill_paint", converter.parse(fillColorElement.getValue()));
        }
        if ((fillStrokeElement = (DomElement)attrChild.getChild("fillStroke")) != null) {
            BasicStrokeDomConverter strokeDomConverter = new BasicStrokeDomConverter();
            Object fillStroke = strokeDomConverter.convertDomToValue(fillStrokeElement, null);
            attributes.put("fill_stroke", fillStroke);
        }
        if ((outlinedElement = (DomElement)attrChild.getChild("outlined")) != null) {
            Converter converter = converterRegistry.getConverter(Boolean.class);
            attributes.put("outline", converter.parse(outlinedElement.getValue()));
        }
        if ((outlineColorElement = (DomElement)attrChild.getChild("outlineColor")) != null) {
            Converter converter = converterRegistry.getConverter(Color.class);
            attributes.put("outl_color", converter.parse(outlineColorElement.getValue()));
        }
        if ((outlineTransparencyElement = (DomElement)attrChild.getChild("outlineTransparency")) != null) {
            Converter converter = converterRegistry.getConverter(Float.class);
            Float transparency = (Float)converter.parse(outlineTransparencyElement.getValue());
            attributes.put("outl_composite", AlphaComposite.SrcOver.derive(transparency.floatValue()));
        }
        if ((outlineStrokeElement = (DomElement)attrChild.getChild("outlineStroke")) != null) {
            BasicStrokeDomConverter strokeDomConverter = new BasicStrokeDomConverter();
            Object outlineStroke = strokeDomConverter.convertDomToValue(outlineStrokeElement, null);
            attributes.put("outl_stroke", outlineStroke);
        }
        return attributes;
    }

    private static class BasicStrokeDomConverter
    implements DomConverter {
        private BasicStrokeDomConverter() {
        }

        public Class<?> getValueType() {
            return BasicStroke.class;
        }

        public Object convertDomToValue(DomElement parentElement, Object value) throws ConversionException, ValidationException {
            ConverterRegistry registry = ConverterRegistry.getInstance();
            DomElement widthElement = (DomElement)parentElement.getChild("width");
            Float width = (Float)registry.getConverter(Float.class).parse(widthElement.getValue());
            DomElement capElement = (DomElement)parentElement.getChild("cap");
            Integer cap = (Integer)registry.getConverter(Integer.class).parse(capElement.getValue());
            DomElement joinElement = (DomElement)parentElement.getChild("join");
            Integer join = (Integer)registry.getConverter(Integer.class).parse(joinElement.getValue());
            DomElement miterlimitElement = (DomElement)parentElement.getChild("miterlimit");
            Float miterlimit = (Float)registry.getConverter(Float.class).parse(miterlimitElement.getValue());
            DomElement dashElement = (DomElement)parentElement.getChild("dash");
            float[] dash = null;
            if (dashElement != null) {
                dash = (float[])registry.getConverter(float[].class).parse(dashElement.getValue());
            }
            DomElement dashPhaseElement = (DomElement)parentElement.getChild("dashPhase");
            Float dashPhase = (Float)registry.getConverter(Float.class).parse(dashPhaseElement.getValue());
            return new BasicStroke(width.floatValue(), cap, join, miterlimit.floatValue(), dash, dashPhase.floatValue());
        }

        public void convertValueToDom(Object value, DomElement parentElement) throws ConversionException {
            ConverterRegistry registry = ConverterRegistry.getInstance();
            BasicStroke basicStroke = (BasicStroke)BasicStroke.class.cast(value);
            DomElement widthElement = parentElement.createChild("width");
            widthElement.setValue(registry.getConverter(Float.class).format((Object)Float.valueOf(basicStroke.getLineWidth())));
            DomElement capElement = parentElement.createChild("cap");
            capElement.setValue(registry.getConverter(Integer.class).format((Object)basicStroke.getEndCap()));
            DomElement joinElement = parentElement.createChild("join");
            joinElement.setValue(registry.getConverter(Integer.class).format((Object)basicStroke.getLineJoin()));
            DomElement miterlimitElement = parentElement.createChild("miterlimit");
            miterlimitElement.setValue(registry.getConverter(Float.class).format((Object)Float.valueOf(basicStroke.getMiterLimit())));
            float[] dashArray = basicStroke.getDashArray();
            if (dashArray != null) {
                DomElement dashElement = parentElement.createChild("dash");
                dashElement.setValue(registry.getConverter(float[].class).format((Object)dashArray));
            }
            DomElement dashPhaseElement = parentElement.createChild("dashPhase");
            dashPhaseElement.setValue(registry.getConverter(Float.class).format((Object)Float.valueOf(basicStroke.getDashPhase())));
        }
    }
}

