/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.glayer;

import com.bc.ceres.binding.Property;
import com.bc.ceres.binding.PropertyContainer;
import com.bc.ceres.binding.PropertySet;
import com.bc.ceres.glayer.Layer;
import com.bc.ceres.glayer.LayerContext;
import com.bc.ceres.glayer.LayerType;
import com.bc.ceres.glayer.annotations.LayerTypeMetadata;
import java.awt.Color;
import java.awt.Font;
import java.awt.geom.AffineTransform;
import org.esa.beam.framework.datamodel.RasterDataNode;
import org.esa.beam.glayer.GraticuleLayer;

@LayerTypeMetadata(name="GraticuleLayerType", aliasNames={"org.esa.beam.glayer.GraticuleLayerType"})
public class GraticuleLayerType
extends LayerType {
    public static final String PROPERTY_NAME_RASTER = "raster";
    public static final String PROPERTY_NAME_RES_AUTO = "graticule.res.auto";
    public static final String PROPERTY_NAME_RES_PIXELS = "graticule.res.pixels";
    public static final String PROPERTY_NAME_RES_LAT = "graticule.res.lat";
    public static final String PROPERTY_NAME_RES_LON = "graticule.res.lon";
    public static final String PROPERTY_NAME_LINE_COLOR = "graticule.line.color";
    public static final String PROPERTY_NAME_LINE_TRANSPARENCY = "graticule.line.transparency";
    public static final String PROPERTY_NAME_LINE_WIDTH = "graticule.line.width";
    public static final String PROPERTY_NAME_TEXT_ENABLED = "graticule.text.enabled";
    public static final String PROPERTY_NAME_TEXT_FONT = "graticule.text.font";
    public static final String PROPERTY_NAME_TEXT_FG_COLOR = "graticule.text.fg.color";
    public static final String PROPERTY_NAME_TEXT_BG_COLOR = "graticule.text.bg.color";
    public static final String PROPERTY_NAME_TEXT_BG_TRANSPARENCY = "graticule.text.bg.transparency";
    public static final boolean DEFAULT_RES_AUTO = true;
    public static final int DEFAULT_RES_PIXELS = 128;
    public static final double DEFAULT_RES_LAT = 1.0;
    public static final double DEFAULT_RES_LON = 1.0;
    public static final Color DEFAULT_LINE_COLOR = new Color(204, 204, 255);
    public static final double DEFAULT_LINE_TRANSPARENCY = 0.0;
    public static final double DEFAULT_LINE_WIDTH = 0.5;
    public static final boolean DEFAULT_TEXT_ENABLED = true;
    public static final Font DEFAULT_TEXT_FONT = new Font("SansSerif", 2, 12);
    public static final Color DEFAULT_TEXT_FG_COLOR = Color.WHITE;
    public static final Color DEFAULT_TEXT_BG_COLOR = Color.BLACK;
    public static final double DEFAULT_TEXT_BG_TRANSPARENCY = 0.7;
    private static final String ALIAS_NAME_RES_AUTO = "resAuto";
    private static final String ALIAS_NAME_RES_PIXELS = "resPixels";
    private static final String ALIAS_NAME_RES_LAT = "resLat";
    private static final String ALIAS_NAME_RES_LON = "resLon";
    private static final String ALIAS_NAME_LINE_COLOR = "lineColor";
    private static final String ALIAS_NAME_LINE_TRANSPARENCY = "lineTransparency";
    private static final String ALIAS_NAME_LINE_WIDTH = "lineWidth";
    private static final String ALIAS_NAME_TEXT_ENABLED = "textEnabled";
    private static final String ALIAS_NAME_TEXT_FONT = "textFont";
    private static final String ALIAS_NAME_TEXT_FG_COLOR = "textFgColor";
    private static final String ALIAS_NAME_TEXT_BG_COLOR = "textBgColor";
    private static final String ALIAS_NAME_TEXT_BG_TRANSPARENCY = "textBgTransparency";
    @Deprecated
    private static final String PROPERTY_NAME_TRANSFORM = "imageToModelTransform";

    public boolean isValidFor(LayerContext ctx) {
        return true;
    }

    public Layer createLayer(LayerContext ctx, PropertySet configuration) {
        return new GraticuleLayer(this, (RasterDataNode)configuration.getValue(PROPERTY_NAME_RASTER), configuration);
    }

    public PropertySet createLayerConfig(LayerContext ctx) {
        PropertyContainer vc = new PropertyContainer();
        Property rasterModel = Property.create((String)PROPERTY_NAME_RASTER, RasterDataNode.class);
        rasterModel.getDescriptor().setNotNull(true);
        vc.addProperty(rasterModel);
        Property transformModel = Property.create((String)PROPERTY_NAME_TRANSFORM, (Object)new AffineTransform());
        transformModel.getDescriptor().setTransient(true);
        vc.addProperty(transformModel);
        Property resAutoModel = Property.create((String)PROPERTY_NAME_RES_AUTO, Boolean.class, (Object)true, (boolean)true);
        resAutoModel.getDescriptor().setAlias(ALIAS_NAME_RES_AUTO);
        vc.addProperty(resAutoModel);
        Property resPixelsModel = Property.create((String)PROPERTY_NAME_RES_PIXELS, Integer.class, (Object)128, (boolean)true);
        resPixelsModel.getDescriptor().setAlias(ALIAS_NAME_RES_PIXELS);
        vc.addProperty(resPixelsModel);
        Property resLatModel = Property.create((String)PROPERTY_NAME_RES_LAT, Double.class, (Object)1.0, (boolean)true);
        resLatModel.getDescriptor().setAlias(ALIAS_NAME_RES_LAT);
        vc.addProperty(resLatModel);
        Property resLonModel = Property.create((String)PROPERTY_NAME_RES_LON, Double.class, (Object)1.0, (boolean)true);
        resLonModel.getDescriptor().setAlias(ALIAS_NAME_RES_LON);
        vc.addProperty(resLonModel);
        Property lineColorModel = Property.create((String)PROPERTY_NAME_LINE_COLOR, Color.class, (Object)DEFAULT_LINE_COLOR, (boolean)true);
        lineColorModel.getDescriptor().setAlias(ALIAS_NAME_LINE_COLOR);
        vc.addProperty(lineColorModel);
        Property lineTransparencyModel = Property.create((String)PROPERTY_NAME_LINE_TRANSPARENCY, Double.class, (Object)0.0, (boolean)true);
        lineTransparencyModel.getDescriptor().setAlias(ALIAS_NAME_LINE_TRANSPARENCY);
        vc.addProperty(lineTransparencyModel);
        Property lineWidthModel = Property.create((String)PROPERTY_NAME_LINE_WIDTH, Double.class, (Object)0.5, (boolean)true);
        lineWidthModel.getDescriptor().setAlias(ALIAS_NAME_LINE_WIDTH);
        vc.addProperty(lineWidthModel);
        Property textEnabledModel = Property.create((String)PROPERTY_NAME_TEXT_ENABLED, Boolean.class, (Object)true, (boolean)true);
        textEnabledModel.getDescriptor().setAlias(ALIAS_NAME_TEXT_ENABLED);
        vc.addProperty(textEnabledModel);
        Property textFontModel = Property.create((String)PROPERTY_NAME_TEXT_FONT, Font.class, (Object)DEFAULT_TEXT_FONT, (boolean)true);
        textFontModel.getDescriptor().setAlias(ALIAS_NAME_TEXT_FONT);
        vc.addProperty(textFontModel);
        Property textFgColorModel = Property.create((String)PROPERTY_NAME_TEXT_FG_COLOR, Color.class, (Object)DEFAULT_TEXT_FG_COLOR, (boolean)true);
        textFgColorModel.getDescriptor().setAlias(ALIAS_NAME_TEXT_FG_COLOR);
        vc.addProperty(textFgColorModel);
        Property textBgColorModel = Property.create((String)PROPERTY_NAME_TEXT_BG_COLOR, Color.class, (Object)DEFAULT_TEXT_BG_COLOR, (boolean)true);
        textBgColorModel.getDescriptor().setAlias(ALIAS_NAME_TEXT_BG_COLOR);
        vc.addProperty(textBgColorModel);
        Property textBgTransparencyModel = Property.create((String)PROPERTY_NAME_TEXT_BG_TRANSPARENCY, Double.class, (Object)0.7, (boolean)true);
        textBgTransparencyModel.getDescriptor().setAlias(ALIAS_NAME_TEXT_BG_TRANSPARENCY);
        vc.addProperty(textBgTransparencyModel);
        return vc;
    }
}

