/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.glayer;

import com.bc.ceres.binding.Property;
import com.bc.ceres.binding.PropertySet;
import com.bc.ceres.core.ProgressMonitor;
import com.bc.ceres.glayer.Layer;
import com.bc.ceres.glayer.LayerContext;
import com.bc.ceres.glayer.annotations.LayerTypeMetadata;
import com.bc.ceres.glayer.support.ImageLayer;
import com.bc.ceres.glevel.MultiLevelSource;
import org.esa.beam.framework.datamodel.Band;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.datamodel.RGBImageProfile;
import org.esa.beam.framework.datamodel.RasterDataNode;
import org.esa.beam.framework.datamodel.VirtualBand;
import org.esa.beam.framework.dataop.barithm.BandArithmetic;
import org.esa.beam.glevel.BandImageMultiLevelSource;

@LayerTypeMetadata(name="RgbImageLayerType", aliasNames={"org.esa.beam.glayer.RgbImageLayerType"})
public class RgbImageLayerType
extends ImageLayer.Type {
    private static final String PROPERTY_NAME_PRODUCT = "product";
    private static final String PROPERTY_NAME_EXPRESSION_R = "expressionR";
    private static final String PROPERTY_NAME_EXPRESSION_G = "expressionG";
    private static final String PROPERTY_NAME_EXPRESSION_B = "expressionB";

    public ImageLayer createLayer(LayerContext ctx, PropertySet configuration) {
        Object multiLevelSource = (MultiLevelSource)configuration.getValue("multiLevelSource");
        if (multiLevelSource == null) {
            Product product = (Product)((Object)configuration.getValue(PROPERTY_NAME_PRODUCT));
            String[] rgbExpressions = new String[]{(String)configuration.getValue(PROPERTY_NAME_EXPRESSION_R), (String)configuration.getValue(PROPERTY_NAME_EXPRESSION_G), (String)configuration.getValue(PROPERTY_NAME_EXPRESSION_B)};
            RasterDataNode[] rasters = RgbImageLayerType.getRgbBands(product, rgbExpressions);
            multiLevelSource = BandImageMultiLevelSource.create(rasters, rasters[0].getSourceImage().getModel(), ProgressMonitor.NULL);
        }
        configuration.setValue("multiLevelSource", multiLevelSource);
        configuration.setValue("borderShown", (Object)true);
        configuration.setValue("borderColor", (Object)ImageLayer.DEFAULT_BORDER_COLOR);
        configuration.setValue("borderWidth", (Object)1.0);
        ImageLayer layer = new ImageLayer((ImageLayer.Type)this, multiLevelSource, configuration);
        layer.setName("RGB Layer");
        return layer;
    }

    public PropertySet createLayerConfig(LayerContext ctx) {
        PropertySet prototype = super.createLayerConfig(ctx);
        Property productModel = Property.create((String)PROPERTY_NAME_PRODUCT, Product.class);
        productModel.getDescriptor().setNotNull(true);
        prototype.addProperty(productModel);
        Property redModel = Property.create((String)PROPERTY_NAME_EXPRESSION_R, String.class);
        redModel.getDescriptor().setNotNull(true);
        prototype.addProperty(redModel);
        Property greenModel = Property.create((String)PROPERTY_NAME_EXPRESSION_G, String.class);
        greenModel.getDescriptor().setNotNull(true);
        prototype.addProperty(greenModel);
        Property blueModel = Property.create((String)PROPERTY_NAME_EXPRESSION_B, String.class);
        blueModel.getDescriptor().setNotNull(true);
        prototype.addProperty(blueModel);
        return prototype;
    }

    public Layer createLayer(RasterDataNode[] rasters, BandImageMultiLevelSource multiLevelSource) {
        if (rasters.length != 3) {
            throw new IllegalArgumentException("rasters.length != 3");
        }
        Product product = rasters[0].getProduct();
        if (product == null) {
            throw new IllegalArgumentException("rasters[0].getProduct() == null");
        }
        if (product != rasters[1].getProduct()) {
            throw new IllegalArgumentException("rasters[0].getProduct() != rasters[1].getProduct()");
        }
        if (product != rasters[2].getProduct()) {
            throw new IllegalArgumentException("rasters[0].getProduct() != rasters[2].getProduct()");
        }
        PropertySet configuration = this.createLayerConfig(null);
        String expressionR = RgbImageLayerType.getExpression(rasters[0]);
        String expressionG = RgbImageLayerType.getExpression(rasters[1]);
        String expressionB = RgbImageLayerType.getExpression(rasters[2]);
        configuration.setValue(PROPERTY_NAME_PRODUCT, (Object)product);
        configuration.setValue(PROPERTY_NAME_EXPRESSION_R, (Object)expressionR);
        configuration.setValue(PROPERTY_NAME_EXPRESSION_G, (Object)expressionG);
        configuration.setValue(PROPERTY_NAME_EXPRESSION_B, (Object)expressionB);
        if (multiLevelSource == null) {
            multiLevelSource = BandImageMultiLevelSource.create(rasters, ProgressMonitor.NULL);
        }
        configuration.setValue("multiLevelSource", (Object)multiLevelSource);
        configuration.setValue("borderShown", (Object)true);
        configuration.setValue("borderColor", (Object)ImageLayer.DEFAULT_BORDER_COLOR);
        configuration.setValue("borderWidth", (Object)1.0);
        configuration.setValue("pixelBorderShown", (Object)true);
        configuration.setValue("pixelBorderColor", (Object)ImageLayer.DEFAULT_PIXEL_BORDER_COLOR);
        configuration.setValue("pixelBorderWidth", (Object)0.0);
        return this.createLayer(null, configuration);
    }

    private static String getExpression(RasterDataNode raster) {
        Product product = raster.getProduct();
        if (product != null) {
            if (product.containsBand(raster.getName())) {
                return BandArithmetic.createExternalName(raster.getName());
            }
            if (raster instanceof VirtualBand) {
                return ((VirtualBand)raster).getExpression();
            }
        }
        return null;
    }

    private static RasterDataNode[] getRgbBands(Product product, String[] rgbExpressions) {
        RasterDataNode[] rgbBands = new RasterDataNode[3];
        for (int i = 0; i < rgbBands.length; ++i) {
            rgbBands[i] = RgbImageLayerType.getRgbBand(product, RGBImageProfile.RGB_BAND_NAMES[i], rgbExpressions[i]);
        }
        return rgbBands;
    }

    private static Band getRgbBand(Product product, String bandName, String expression) {
        Band band = null;
        if (expression != null && !expression.isEmpty()) {
            band = product.getBand(expression);
        }
        if (band == null) {
            if (expression == null || expression.isEmpty()) {
                expression = "0.0";
            }
            band = new RgbBand(product, bandName, expression);
        }
        return band;
    }

    private static class RgbBand
    extends VirtualBand {
        private RgbBand(Product product, String bandName, String expression) {
            super(bandName, 30, product.getSceneRasterWidth(), product.getSceneRasterHeight(), expression);
            this.setOwner(product);
        }
    }
}

