/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.glevel;

import com.bc.ceres.core.Assert;
import com.bc.ceres.core.ProgressMonitor;
import com.bc.ceres.glevel.MultiLevelModel;
import com.bc.ceres.glevel.support.AbstractMultiLevelSource;
import com.bc.ceres.glevel.support.DefaultMultiLevelModel;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.image.RenderedImage;
import org.esa.beam.framework.datamodel.ImageInfo;
import org.esa.beam.framework.datamodel.RasterDataNode;
import org.esa.beam.jai.ImageManager;

public class BandImageMultiLevelSource
extends AbstractMultiLevelSource {
    private final RasterDataNode[] rasterDataNodes;
    private ImageInfo imageInfo;

    public static BandImageMultiLevelSource create(RasterDataNode rasterDataNode, ProgressMonitor pm) {
        return BandImageMultiLevelSource.create(new RasterDataNode[]{rasterDataNode}, pm);
    }

    public static BandImageMultiLevelSource create(RasterDataNode[] rasterDataNodes, ProgressMonitor pm) {
        RasterDataNode rdn = rasterDataNodes[0];
        MultiLevelModel model = ImageManager.getMultiLevelModel(rdn);
        return BandImageMultiLevelSource.create(rasterDataNodes, model, pm);
    }

    public static BandImageMultiLevelSource create(RasterDataNode[] rasterDataNodes, MultiLevelModel model, ProgressMonitor pm) {
        ImageManager.getInstance().prepareImageInfos(rasterDataNodes, pm);
        return new BandImageMultiLevelSource(model, rasterDataNodes);
    }

    @Deprecated
    public static BandImageMultiLevelSource create(RasterDataNode rasterDataNode, AffineTransform i2mTransform, ProgressMonitor pm) {
        return BandImageMultiLevelSource.create(new RasterDataNode[]{rasterDataNode}, i2mTransform, pm);
    }

    @Deprecated
    public static BandImageMultiLevelSource create(RasterDataNode[] rasterDataNodes, AffineTransform i2mTransform, ProgressMonitor pm) {
        return BandImageMultiLevelSource.create(rasterDataNodes, i2mTransform, DefaultMultiLevelModel.getLevelCount((int)rasterDataNodes[0].getSceneRasterWidth(), (int)rasterDataNodes[0].getSceneRasterHeight()), pm);
    }

    @Deprecated
    private static BandImageMultiLevelSource create(RasterDataNode[] rasterDataNodes, AffineTransform i2mTransform, int levelCount, ProgressMonitor pm) {
        Assert.notNull((Object)rasterDataNodes);
        Assert.argument((rasterDataNodes.length > 0 ? 1 : 0) != 0);
        int w = rasterDataNodes[0].getSceneRasterWidth();
        int h = rasterDataNodes[0].getSceneRasterHeight();
        DefaultMultiLevelModel model = new DefaultMultiLevelModel(levelCount, i2mTransform, w, h);
        return BandImageMultiLevelSource.create(rasterDataNodes, (MultiLevelModel)model, pm);
    }

    private BandImageMultiLevelSource(MultiLevelModel model, RasterDataNode[] rasterDataNodes) {
        super(model);
        this.rasterDataNodes = (RasterDataNode[])rasterDataNodes.clone();
        this.imageInfo = ImageManager.getInstance().getImageInfo(rasterDataNodes);
    }

    public void setImageInfo(ImageInfo imageInfo) {
        this.imageInfo = imageInfo;
    }

    public ImageInfo getImageInfo() {
        return this.imageInfo;
    }

    public Shape getImageShape(int level) {
        return this.rasterDataNodes[0].getSourceImage().getImageShape(level);
    }

    public RenderedImage createImage(int level) {
        return ImageManager.getInstance().createColoredBandImage(this.rasterDataNodes, this.imageInfo, level);
    }
}

