/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.jai;

import com.bc.ceres.glevel.MultiLevelModel;
import com.bc.ceres.glevel.support.DefaultMultiLevelModel;
import com.bc.ceres.glevel.support.DefaultMultiLevelSource;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.imageio.stream.FileImageOutputStream;
import javax.imageio.stream.MemoryCacheImageOutputStream;
import javax.media.jai.Interpolation;
import javax.media.jai.PlanarImage;
import javax.media.jai.operator.FileLoadDescriptor;
import javax.media.jai.operator.FileStoreDescriptor;
import org.esa.beam.jai.TiledFileOpImage;

public class PyramidBuilder {
    public static void main(String[] args) throws IOException {
        File imageFile = new File(args[0]);
        File outputDir = new File(args[1]);
        String tileFormat = args[2];
        int levelCount = Integer.parseInt(args[3]);
        int tileWidth0 = Integer.parseInt(args[4]);
        int tileHeight0 = Integer.parseInt(args[5]);
        new PyramidBuilder().doit(imageFile, outputDir, tileFormat, levelCount, tileWidth0, tileHeight0);
    }

    private void doit(File imageFile, File outputDir, String tileFormat, int levelCount, int tileWidth0, int tileHeight0) throws IOException {
        TiledFileOpImage image0;
        Interpolation interpolation;
        boolean raw;
        outputDir.mkdir();
        int tileWidth = tileWidth0;
        int tileHeight = tileHeight0;
        boolean rawZip = tileFormat.equalsIgnoreCase("raw.zip");
        boolean bl = raw = tileFormat.equalsIgnoreCase("raw") || rawZip;
        if (raw) {
            interpolation = Interpolation.getInstance((int)0);
            image0 = TiledFileOpImage.create(imageFile, new Properties());
        } else {
            interpolation = Interpolation.getInstance((int)2);
            image0 = FileLoadDescriptor.create((String)imageFile.getPath(), null, (Boolean)true, null);
        }
        int dataType = image0.getSampleModel().getDataType();
        DefaultMultiLevelModel model = new DefaultMultiLevelModel(levelCount, new AffineTransform(), (Rectangle2D)new Rectangle(image0.getWidth(), image0.getHeight()));
        DefaultMultiLevelSource multiLevelSource = new DefaultMultiLevelSource((RenderedImage)((Object)image0), (MultiLevelModel)model, interpolation);
        for (int level = 0; level < levelCount; ++level) {
            int numYTiles;
            int numXTiles;
            PlanarImage image = PlanarImage.wrapRenderedImage((RenderedImage)multiLevelSource.getImage(level));
            int width = image.getWidth();
            int height = image.getHeight();
            System.out.println("width = " + width + ", height = " + height);
            while (true) {
                numXTiles = width / tileWidth;
                numYTiles = height / tileHeight;
                System.out.println("tileWidth = " + tileWidth + ", tileHeight = " + tileHeight);
                System.out.println("numXTiles = " + numXTiles + ", numYTiles = " + numYTiles);
                if (numXTiles * tileWidth == width && numYTiles * tileHeight == image.getHeight()) break;
                if (numXTiles * tileWidth < width) {
                    tileWidth /= 2;
                }
                if (numYTiles * tileHeight >= height) continue;
                tileHeight /= 2;
            }
            if (numXTiles == 0 || numYTiles == 0) {
                throw new IllegalStateException("numXTiles == 0 || numYTiles == 0");
            }
            if (tileWidth < tileWidth0 && tileHeight < tileHeight0) {
                tileWidth = width;
                tileHeight = height;
                numYTiles = 1;
                numXTiles = 1;
            }
            File outputLevelDir = new File(outputDir, "" + level);
            outputLevelDir.mkdir();
            File imagePropertiesFile = new File(outputLevelDir, "image.properties");
            System.out.println("Writing " + imagePropertiesFile + "...");
            PrintWriter printWriter = new PrintWriter(new FileWriter(imagePropertiesFile));
            this.writeImageProperties(level, dataType, width, height, tileWidth, tileHeight, numXTiles, numYTiles, new PrintWriter(System.out));
            this.writeImageProperties(level, dataType, width, height, tileWidth, tileHeight, numXTiles, numYTiles, printWriter);
            System.out.flush();
            printWriter.close();
            if (raw) {
                this.writeRawTiles(outputLevelDir, image, tileWidth, tileHeight, numXTiles, numYTiles, rawZip);
                continue;
            }
            this.writeTiles(outputLevelDir, tileFormat, image, tileWidth, tileHeight, numXTiles, numYTiles);
        }
    }

    private void writeTiles(File outputLevelDir, String tileFormat, PlanarImage image, int tileWidth, int tileHeight, int numXTiles, int numYTiles) {
        for (int tileY = 0; tileY < numYTiles; ++tileY) {
            for (int tileX = 0; tileX < numXTiles; ++tileX) {
                int x = tileX * tileWidth;
                int y = tileY * tileHeight;
                Rectangle region = new Rectangle(x, y, tileWidth, tileHeight);
                BufferedImage bufferedImage = image.getAsBufferedImage(region, null);
                String baseName = tileX + "-" + tileY + "." + tileFormat;
                FileStoreDescriptor.create((RenderedImage)bufferedImage, (String)new File(outputLevelDir, baseName).getPath(), (String)tileFormat, null, (Boolean)false, null);
            }
        }
    }

    private void writeRawTiles(File levelDir, PlanarImage image, int tileWidth, int tileHeight, int numXTiles, int numYTiles, boolean rawZip) throws IOException {
        for (int tileY = 0; tileY < numYTiles; ++tileY) {
            for (int tileX = 0; tileX < numXTiles; ++tileX) {
                int x = tileX * tileWidth;
                int y = tileY * tileHeight;
                Raster raster = image.getData(new Rectangle(x, y, tileWidth, tileHeight));
                int[] data = ((DataBufferInt)raster.getDataBuffer()).getData();
                if (data.length != tileWidth * tileHeight) {
                    data = new int[tileWidth * tileHeight];
                    raster.getDataElements(x, y, tileWidth, tileHeight, data);
                }
                this.writeRawData(levelDir, tileX, tileY, data, rawZip);
            }
        }
    }

    private void writeRawData(File levelDir, int tileX, int tileY, int[] data, boolean rawZip) throws IOException {
        String baseName = tileX + "-" + tileY + ".raw";
        if (rawZip) {
            File file = new File(levelDir, baseName + ".zip");
            ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(file));
            zipOutputStream.putNextEntry(new ZipEntry(baseName));
            MemoryCacheImageOutputStream imageOutputStream = new MemoryCacheImageOutputStream(zipOutputStream);
            imageOutputStream.writeInts(data, 0, data.length);
            imageOutputStream.flush();
            zipOutputStream.closeEntry();
            zipOutputStream.close();
        } else {
            File file = new File(levelDir, baseName);
            FileImageOutputStream outputStream = new FileImageOutputStream(file);
            outputStream.writeInts(data, 0, data.length);
            outputStream.close();
        }
    }

    private void writeImageProperties(int level, int dataType, int width, int height, int tileWidth, int tileHeight, int numXTiles, int numYTiles, PrintWriter printWriter) {
        printWriter.println("level      = " + level);
        printWriter.println("dataType   = " + dataType);
        printWriter.println("width      = " + width);
        printWriter.println("height     = " + height);
        printWriter.println("tileWidth  = " + tileWidth);
        printWriter.println("tileHeight = " + tileHeight);
        printWriter.println("numXTiles  = " + numXTiles);
        printWriter.println("numYTiles  = " + numYTiles);
    }
}

