/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.jai;

import com.bc.ceres.core.VirtualDir;
import java.awt.Point;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.imageio.stream.FileCacheImageInputStream;
import javax.imageio.stream.FileImageInputStream;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;
import javax.media.jai.DataBufferDouble;
import javax.media.jai.DataBufferFloat;
import javax.media.jai.JAI;
import javax.media.jai.RenderedOp;
import javax.media.jai.SourcelessOpImage;
import javax.media.jai.operator.FileLoadDescriptor;
import org.esa.beam.jai.ImageHeader;

public class TiledFileOpImage
extends SourcelessOpImage {
    private VirtualDir imageDir;
    private ImageInputStreamFactory inputStreamFactory;
    private boolean disposed;
    private ImageHeader imageHeader;

    public static TiledFileOpImage create(File imageDir, Properties defaultImageProperties) throws IOException {
        VirtualDir dir = VirtualDir.create((File)imageDir);
        File file = new File(dir.getBasePath());
        ImageHeader imageHeader = ImageHeader.load(file, defaultImageProperties);
        return new TiledFileOpImage(imageHeader, null, dir);
    }

    public static TiledFileOpImage create(VirtualDir imageDir, Properties defaultImageProperties) throws IOException {
        return TiledFileOpImage.create(new File(imageDir.getBasePath()), defaultImageProperties);
    }

    private TiledFileOpImage(ImageHeader imageHeader, Map configuration, VirtualDir imageDir) throws IOException {
        super(imageHeader.getImageLayout(), configuration, imageHeader.getImageLayout().getSampleModel(null), imageHeader.getImageLayout().getMinX(null), imageHeader.getImageLayout().getMinY(null), imageHeader.getImageLayout().getWidth(null), imageHeader.getImageLayout().getHeight(null));
        this.imageDir = imageDir;
        this.imageHeader = imageHeader;
        if (this.imageHeader.getTileFormat().equalsIgnoreCase("raw.zip")) {
            this.inputStreamFactory = new RawZipImageInputStreamFactory();
        } else if (this.imageHeader.getTileFormat().equalsIgnoreCase("raw")) {
            this.inputStreamFactory = new RawImageInputStreamFactory();
        } else if (this.imageHeader.getTileFormat().equalsIgnoreCase("zip")) {
            this.inputStreamFactory = new ZipInputStreamFactory();
        }
        if (this.getTileCache() == null) {
            this.setTileCache(JAI.getDefaultInstance().getTileCache());
        }
    }

    public Raster computeTile(int tileX, int tileY) {
        Raster raster;
        Point location = new Point(this.tileXToX(tileX), this.tileYToY(tileY));
        if (this.imageHeader.getTileFormat().startsWith("raw")) {
            WritableRaster targetRaster = this.createWritableRaster(this.sampleModel, location);
            try {
                this.readRawDataTile(tileX, tileY, targetRaster);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to read image tile.", e);
            }
            raster = targetRaster;
        } else {
            raster = this.readImageTile(tileX, tileY, location);
        }
        return raster;
    }

    private Raster readImageTile(int tileX, int tileY, Point location) {
        File imageFile = new File(this.imageDir.getBasePath(), this.getTileFilename(tileX, tileY));
        RenderedOp renderedOp = FileLoadDescriptor.create((String)imageFile.getPath(), null, (Boolean)true, null);
        Raster data = renderedOp.getData();
        return WritableRaster.createRaster(data.getSampleModel(), data.getDataBuffer(), location);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readRawDataTile(int tileX, int tileY, WritableRaster targetRaster) throws IOException {
        try (ImageInputStream imageInputStream = this.inputStreamFactory.createImageInputStream(tileX, tileY);){
            TiledFileOpImage.readRawDataTile(imageInputStream, targetRaster);
        }
    }

    public static void readRawDataTile(ImageInputStream stream, WritableRaster raster) throws IOException {
        Object dataObject = TiledFileOpImage.getDataObject(raster);
        if (dataObject instanceof byte[]) {
            byte[] data = (byte[])dataObject;
            stream.readFully(data, 0, data.length);
        } else if (dataObject instanceof short[]) {
            short[] data = (short[])dataObject;
            stream.readFully(data, 0, data.length);
        } else if (dataObject instanceof int[]) {
            int[] data = (int[])dataObject;
            stream.readFully(data, 0, data.length);
        } else if (dataObject instanceof float[]) {
            float[] data = (float[])dataObject;
            stream.readFully(data, 0, data.length);
        } else if (dataObject instanceof double[]) {
            double[] data = (double[])dataObject;
            stream.readFully(data, 0, data.length);
        } else {
            throw new IllegalArgumentException("raster: Unexpected type returned by raster.getDataBuffer().getData(): " + dataObject);
        }
    }

    public static void writeRawDataTile(Raster raster, ImageOutputStream stream) throws IOException {
        Object dataObject = TiledFileOpImage.getDataObject(raster);
        if (dataObject instanceof byte[]) {
            byte[] data = (byte[])dataObject;
            stream.write(data);
        } else if (dataObject instanceof short[]) {
            short[] data = (short[])dataObject;
            stream.writeShorts(data, 0, data.length);
        } else if (dataObject instanceof int[]) {
            int[] data = (int[])dataObject;
            stream.writeInts(data, 0, data.length);
        } else if (dataObject instanceof float[]) {
            float[] data = (float[])dataObject;
            stream.writeFloats(data, 0, data.length);
        } else if (dataObject instanceof double[]) {
            double[] data = (double[])dataObject;
            stream.writeDoubles(data, 0, data.length);
        } else {
            throw new IllegalArgumentException("raster: Unexpected type returned by raster.getDataBuffer().getData(): " + dataObject);
        }
    }

    public static Object getDataObject(Raster raster) {
        Object arrayObject;
        DataBuffer dataBuffer = raster.getDataBuffer();
        if (dataBuffer instanceof DataBufferByte) {
            arrayObject = ((DataBufferByte)dataBuffer).getData();
        } else if (dataBuffer instanceof DataBufferShort) {
            arrayObject = ((DataBufferShort)dataBuffer).getData();
        } else if (dataBuffer instanceof DataBufferUShort) {
            arrayObject = ((DataBufferUShort)dataBuffer).getData();
        } else if (dataBuffer instanceof DataBufferInt) {
            arrayObject = ((DataBufferInt)dataBuffer).getData();
        } else if (dataBuffer instanceof java.awt.image.DataBufferFloat) {
            arrayObject = ((java.awt.image.DataBufferFloat)dataBuffer).getData();
        } else if (dataBuffer instanceof java.awt.image.DataBufferDouble) {
            arrayObject = ((java.awt.image.DataBufferDouble)dataBuffer).getData();
        } else if (dataBuffer instanceof DataBufferFloat) {
            arrayObject = ((DataBufferFloat)dataBuffer).getData();
        } else if (dataBuffer instanceof DataBufferDouble) {
            arrayObject = ((DataBufferDouble)dataBuffer).getData();
        } else {
            try {
                Method method = dataBuffer.getClass().getMethod("getData", new Class[0]);
                arrayObject = method.invoke((Object)dataBuffer, new Object[0]);
            }
            catch (Throwable t) {
                throw new IllegalArgumentException("raster: Failed to invoke raster.getDataBuffer().getData().", t);
            }
        }
        if (arrayObject == null) {
            throw new IllegalArgumentException("raster: raster.getDataBuffer().getData() returned null.");
        }
        return arrayObject;
    }

    public synchronized void dispose() {
        if (this.disposed) {
            return;
        }
        this.disposed = true;
        this.inputStreamFactory = null;
        super.dispose();
    }

    private String getTileFilename(int tileX, int tileY) {
        return TiledFileOpImage.getTileBasename(tileX, tileY) + "." + this.imageHeader.getTileFormat();
    }

    private static String getTileBasename(int tileX, int tileY) {
        return tileX + "-" + tileY;
    }

    private class ZipInputStreamFactory
    implements ImageInputStreamFactory {
        private File tmpDir = VirtualDir.createUniqueTempDir();

        private ZipInputStreamFactory() throws IOException {
        }

        @Override
        public ImageInputStream createImageInputStream(int tileX, int tileY) throws IOException {
            String entryName = TiledFileOpImage.getTileBasename(tileX, tileY);
            File file = new File(TiledFileOpImage.this.imageDir.getBasePath());
            ZipFile zipFile = new ZipFile(file);
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry zipEntry = entries.nextElement();
                if (!zipEntry.getName().startsWith(entryName)) continue;
                InputStream inputStream = zipFile.getInputStream(zipEntry);
                return new FileCacheImageInputStream(inputStream, this.tmpDir);
            }
            throw new IOException("No tile for coordinates " + tileX + ", " + tileY + ".");
        }
    }

    private class RawZipImageInputStreamFactory
    implements ImageInputStreamFactory {
        private File tmpDir = VirtualDir.createUniqueTempDir();

        private RawZipImageInputStreamFactory() throws IOException {
        }

        @Override
        public ImageInputStream createImageInputStream(int tileX, int tileY) throws IOException {
            String entryName = TiledFileOpImage.getTileBasename(tileX, tileY) + ".raw";
            File file = new File(TiledFileOpImage.this.imageDir.getBasePath(), entryName + ".zip");
            ZipFile zipFile = new ZipFile(file);
            ZipEntry zipEntry = zipFile.getEntry(entryName);
            InputStream inputStream = zipFile.getInputStream(zipEntry);
            return new FileCacheImageInputStream(inputStream, this.tmpDir);
        }
    }

    private class RawImageInputStreamFactory
    implements ImageInputStreamFactory {
        private RawImageInputStreamFactory() {
        }

        @Override
        public ImageInputStream createImageInputStream(int tileX, int tileY) throws IOException {
            return new FileImageInputStream(new File(TiledFileOpImage.this.imageDir.getBasePath(), TiledFileOpImage.this.getTileFilename(tileX, tileY)));
        }
    }

    private static interface ImageInputStreamFactory {
        public ImageInputStream createImageInputStream(int var1, int var2) throws IOException;
    }
}

