/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.jai;

import com.bc.ceres.core.Assert;
import com.bc.ceres.jai.NoDataRaster;
import com.bc.jexp.ParseException;
import com.bc.jexp.Term;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.DataBuffer;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.text.MessageFormat;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.media.jai.PlanarImage;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.datamodel.ProductData;
import org.esa.beam.framework.datamodel.RasterDataNode;
import org.esa.beam.framework.dataop.barithm.BandArithmetic;
import org.esa.beam.framework.dataop.barithm.RasterDataEvalEnv;
import org.esa.beam.framework.dataop.barithm.RasterDataSymbol;
import org.esa.beam.jai.ImageManager;
import org.esa.beam.jai.ResolutionLevel;
import org.esa.beam.jai.SingleBandedOpImage;
import org.esa.beam.util.ImageUtils;

public class VirtualBandOpImage
extends SingleBandedOpImage {
    private static final int TRUE = 255;
    private static final int FALSE = 0;
    private final String expression;
    private final int dataType;
    private final Number fillValue;
    private final boolean mask;
    private final Product[] products;
    private final int defaultProductIndex;
    private final Map<Point, Term> termMap = new ConcurrentHashMap<Point, Term>();
    private volatile NoDataRaster noDataRaster;

    public static VirtualBandOpImage createMask(RasterDataNode raster, ResolutionLevel level) {
        return VirtualBandOpImage.createMask(raster.getValidMaskExpression(), raster.getProduct(), raster.getRasterWidth(), raster.getRasterHeight(), level);
    }

    public static VirtualBandOpImage createMask(String expression, Product product, int width, int height, ResolutionLevel level) {
        return VirtualBandOpImage.create(expression, 20, null, true, product, width, height, level);
    }

    public static VirtualBandOpImage createMask(String expression, Product[] products, int width, int height, int defaultProductIndex, ResolutionLevel level) {
        return VirtualBandOpImage.create(expression, 20, null, true, products, width, height, defaultProductIndex, level);
    }

    public static VirtualBandOpImage create(String expression, int dataType, Number fillValue, Product product, int width, int height, ResolutionLevel level) {
        return VirtualBandOpImage.create(expression, dataType, fillValue, false, product, width, height, level);
    }

    public static VirtualBandOpImage create(String expression, int dataType, Number fillValue, Product[] products, int width, int height, int defaultProductIndex, ResolutionLevel level) {
        return VirtualBandOpImage.create(expression, dataType, fillValue, false, products, width, height, defaultProductIndex, level);
    }

    private static VirtualBandOpImage create(String expression, int dataType, Number fillValue, boolean mask, Product product, int width, int height, ResolutionLevel level) {
        int defaultProductIndex;
        Product[] products;
        Assert.notNull((Object)((Object)product), (String)"product");
        Assert.notNull((Object)level, (String)"level");
        if (product.getProductManager() != null) {
            products = product.getProductManager().getProducts();
            defaultProductIndex = product.getProductManager().getProductIndex(product);
        } else {
            products = new Product[]{product};
            defaultProductIndex = 0;
        }
        Assert.state((defaultProductIndex >= 0 && defaultProductIndex < products.length ? 1 : 0) != 0);
        Assert.state((products[defaultProductIndex] == product ? 1 : 0) != 0);
        return VirtualBandOpImage.create(expression, dataType, fillValue, mask, products, width, height, defaultProductIndex, level);
    }

    private static VirtualBandOpImage create(String expression, int dataType, Number fillValue, boolean mask, Product[] products, int width, int height, int defaultProductIndex, ResolutionLevel level) {
        Assert.notNull((Object)expression, (String)"expression");
        Assert.notNull((Object)products, (String)"products");
        Assert.argument((products.length > 0 ? 1 : 0) != 0, (String)"products");
        Assert.argument((defaultProductIndex >= 0 ? 1 : 0) != 0, (String)"defaultProductIndex");
        Assert.argument((defaultProductIndex < products.length ? 1 : 0) != 0, (String)"defaultProductIndex");
        Assert.notNull((Object)level, (String)"level");
        return new VirtualBandOpImage(expression, dataType, fillValue, mask, products, width, height, defaultProductIndex, level);
    }

    private VirtualBandOpImage(String expression, int dataType, Number fillValue, boolean mask, Product[] products, int width, int height, int defaultProductIndex, ResolutionLevel level) {
        super(ImageManager.getDataBufferType(dataType), width, height, products[defaultProductIndex].getPreferredTileSize(), null, level);
        this.expression = expression;
        this.dataType = dataType;
        this.mask = mask;
        this.products = products;
        this.defaultProductIndex = defaultProductIndex;
        this.fillValue = fillValue;
    }

    public String getExpression() {
        return this.expression;
    }

    public int getDataType() {
        return this.dataType;
    }

    public boolean isMask() {
        return this.mask;
    }

    public Product[] getProducts() {
        return (Product[])this.products.clone();
    }

    public int getDefaultProductIndex() {
        return this.defaultProductIndex;
    }

    public synchronized void dispose() {
        this.termMap.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Raster computeTile(int tileX, int tileY) {
        Term term = this.parseExpression();
        if (this.addDataToReferredRasterDataSymbols(this.getTileRect(tileX, tileY), term)) {
            this.termMap.put(new Point(tileX, tileY), term);
            return super.computeTile(tileX, tileY);
        }
        if (this.noDataRaster == null) {
            VirtualBandOpImage virtualBandOpImage = this;
            synchronized (virtualBandOpImage) {
                if (this.noDataRaster == null) {
                    this.noDataRaster = this.createNoDataRaster(this.fillValue == null ? 0.0 : this.fillValue.doubleValue());
                }
            }
        }
        return this.noDataRaster.createTranslatedChild(this.tileXToX(tileX), this.tileYToY(tileY));
    }

    protected void computeRect(PlanarImage[] planarImages, WritableRaster writableRaster, Rectangle destRect) {
        Term term = this.termMap.remove(this.getTileIndices(destRect)[0]);
        ProductData productData = ProductData.createInstance(this.dataType, ImageUtils.getPrimitiveArray(writableRaster.getDataBuffer()));
        int x = destRect.x - writableRaster.getMinX();
        int y = destRect.y - writableRaster.getMinY();
        int w = writableRaster.getWidth();
        int colCount = destRect.width;
        int rowCount = destRect.height;
        int pixelCount = colCount * rowCount;
        RasterDataEvalEnv env = new RasterDataEvalEnv(destRect.x, destRect.y, colCount, rowCount, this.getLevelImageSupport());
        if (this.mask) {
            int i = 0;
            int k = w * y;
            while (i < pixelCount) {
                int j = 0;
                int l = x;
                while (j < colCount) {
                    env.setElemIndex(i + j);
                    productData.setElemUIntAt(k + l, term.evalB(env) ? 255L : 0L);
                    ++j;
                    ++l;
                }
                i += colCount;
                k += w;
            }
        } else if (this.fillValue != null) {
            double fv = this.fillValue.doubleValue();
            int i = 0;
            int k = w * y;
            while (i < pixelCount) {
                int j = 0;
                int l = x;
                while (j < colCount) {
                    env.setElemIndex(i + j);
                    double v = term.evalD(env);
                    if (!Double.isNaN(v)) {
                        productData.setElemDoubleAt(k + l, v);
                    } else {
                        productData.setElemDoubleAt(k + l, fv);
                    }
                    ++j;
                    ++l;
                }
                i += colCount;
                k += w;
            }
        } else {
            int i = 0;
            int k = w * y;
            while (i < pixelCount) {
                int j = 0;
                int l = x;
                while (j < colCount) {
                    env.setElemIndex(i + j);
                    productData.setElemDoubleAt(k + l, term.evalD(env));
                    ++j;
                    ++l;
                }
                i += colCount;
                k += w;
            }
        }
    }

    private Term parseExpression() {
        Term term;
        try {
            term = BandArithmetic.parseExpression(this.expression, this.products, this.defaultProductIndex);
        }
        catch (ParseException e) {
            throw new RuntimeException(MessageFormat.format("Could not parse expression: ''{0}''.", this.expression), e);
        }
        ImageManager imageManager = ImageManager.getInstance();
        for (RasterDataSymbol symbol : BandArithmetic.getRefRasterDataSymbols(term)) {
            if (imageManager.getSourceImage(symbol.getRaster(), this.getLevel()) != this) continue;
            throw new RuntimeException(MessageFormat.format("Invalid reference ''{0}''.", symbol.getName()));
        }
        return term;
    }

    private boolean addDataToReferredRasterDataSymbols(Rectangle destRect, Term term) {
        for (RasterDataSymbol symbol : BandArithmetic.getRefRasterDataSymbols(term)) {
            int dataType;
            PlanarImage sourceImage;
            RasterDataNode rasterDataNode = symbol.getRaster();
            if (symbol.getSource() == RasterDataSymbol.GEOPHYSICAL) {
                sourceImage = ImageManager.getInstance().getGeophysicalImage(rasterDataNode, this.getLevel());
                dataType = rasterDataNode.getGeophysicalDataType();
            } else {
                sourceImage = ImageManager.getInstance().getSourceImage(rasterDataNode, this.getLevel());
                dataType = rasterDataNode.getDataType();
            }
            Raster sourceRaster = sourceImage.getData(destRect);
            if (sourceRaster instanceof NoDataRaster) {
                return false;
            }
            DataBuffer dataBuffer = sourceRaster.getDataBuffer();
            if (dataBuffer.getSize() != destRect.width * destRect.height) {
                WritableRaster writableRaster = sourceRaster.createCompatibleWritableRaster(destRect);
                sourceImage.copyData(writableRaster);
                dataBuffer = writableRaster.getDataBuffer();
            }
            symbol.setData(ProductData.createInstance(dataType, ImageUtils.getPrimitiveArray(dataBuffer)));
        }
        return true;
    }
}

