/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.nn;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import org.esa.beam.nn.NNCalc;
import org.esa.beam.nn.util.FormattedStringReader;

public class NNffbpAlphaTabFast {
    private static final double ALPHA_START = -10.0;
    private static final int NUM_ALPHA = 100000;
    private double[] inmin;
    private double[] inmax;
    private double[] outmin;
    private double[] outmax;
    private int nplanes;
    private int[] size;
    private double[][][] wgt;
    private double[][] bias;
    private double[][] act;
    private int nn_in;
    private int nn_out;
    private double[] alphaTab = new double[100000];
    private double recDeltaAlpha;
    private double[][][] dActDX;
    private double[][] help;
    private NNCalc NNresjacob;

    public NNffbpAlphaTabFast(String neuralNet) throws IOException {
        this.readNeuralNetFromString(neuralNet);
        this.makeAlphaTab();
        this.NNresjacob = new NNCalc();
        this.declareArrays();
    }

    public NNffbpAlphaTabFast(InputStream neuralNetStream) throws IOException {
        this(NNffbpAlphaTabFast.readNeuralNet(neuralNetStream));
    }

    public double[] getInmin() {
        return this.inmin;
    }

    public void setInmin(double[] inmin) {
        this.inmin = inmin;
    }

    public double[] getInmax() {
        return this.inmax;
    }

    public void setInmax(double[] inmax) {
        this.inmax = inmax;
    }

    public double[] getOutmin() {
        return this.outmin;
    }

    public double[] getOutmax() {
        return this.outmax;
    }

    private void makeAlphaTab() {
        double delta = 2.000020000200002E-4;
        double sum = -10.0 + 0.5 * delta;
        for (int i = 0; i < 100000; ++i) {
            this.alphaTab[i] = 1.0 / (1.0 + Math.exp(-sum));
            sum += delta;
        }
        this.recDeltaAlpha = 1.0 / delta;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readNeuralNet(InputStream neuralNetStream) throws IOException {
        String neuralNet;
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(neuralNetStream));){
            String line = reader.readLine();
            StringBuilder sb = new StringBuilder();
            while (line != null) {
                sb.append(line).append('\n');
                line = reader.readLine();
            }
            neuralNet = sb.toString();
        }
        return neuralNet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readNeuralNetFromString(String net) throws IOException {
        try (StringReader in = null;){
            int i;
            int pl;
            int i2;
            double[] h;
            int i3;
            in = new StringReader(net);
            FormattedStringReader inf = new FormattedStringReader(in);
            inf.noComments();
            int ch = 48;
            while (ch != 35) {
                ch = (char)in.read();
            }
            inf.rString();
            this.nn_in = (int)inf.rlong();
            this.inmin = new double[this.nn_in];
            this.inmax = new double[this.nn_in];
            for (i3 = 0; i3 < this.nn_in; ++i3) {
                h = inf.rdouble(2);
                this.inmin[i3] = h[0];
                this.inmax[i3] = h[1];
            }
            this.nn_out = (int)inf.rlong();
            this.outmin = new double[this.nn_out];
            this.outmax = new double[this.nn_out];
            for (i3 = 0; i3 < this.nn_out; ++i3) {
                h = inf.rdouble(2);
                this.outmin[i3] = h[0];
                this.outmax[i3] = h[1];
            }
            while (ch != 61) {
                ch = (char)in.read();
            }
            in.mark(1000000);
            this.nplanes = (int)inf.rlong();
            in.reset();
            long[] hh = inf.rlong(this.nplanes + 1);
            this.size = new int[this.nplanes];
            for (i2 = 0; i2 < this.nplanes; ++i2) {
                this.size[i2] = (int)hh[i2 + 1];
            }
            this.wgt = new double[this.nplanes - 1][][];
            for (i2 = 0; i2 < this.nplanes - 1; ++i2) {
                this.wgt[i2] = new double[this.size[i2 + 1]][this.size[i2]];
            }
            this.bias = new double[this.nplanes - 1][];
            for (i2 = 0; i2 < this.nplanes - 1; ++i2) {
                this.bias[i2] = new double[this.size[i2 + 1]];
            }
            this.act = new double[this.nplanes][];
            for (i2 = 0; i2 < this.nplanes; ++i2) {
                this.act[i2] = new double[this.size[i2]];
            }
            for (pl = 0; pl < this.nplanes - 1; ++pl) {
                inf.rString();
                for (i = 0; i < this.size[pl + 1]; ++i) {
                    this.bias[pl][i] = inf.rdouble();
                }
            }
            for (pl = 0; pl < this.nplanes - 1; ++pl) {
                inf.rString();
                for (i = 0; i < this.size[pl + 1]; ++i) {
                    for (int j = 0; j < this.size[pl]; ++j) {
                        this.wgt[pl][i][j] = inf.rdouble();
                    }
                }
            }
        }
    }

    private double activation(double x) {
        int index = (int)((x - -10.0) * this.recDeltaAlpha);
        if (index < 0) {
            index = 0;
        }
        if (index >= 100000) {
            index = 99999;
        }
        return this.alphaTab[index];
    }

    private static double scp(double[] x, double[] y) {
        double sum = 0.0;
        for (int i = 0; i < x.length; ++i) {
            sum += x[i] * y[i];
        }
        return sum;
    }

    public NNCalc calcJacobi(double[] nnInp) {
        NNCalc res = this.NNresjacob;
        for (int i = 0; i < this.nn_in; ++i) {
            this.act[0][i] = (nnInp[i] - this.inmin[i]) / (this.inmax[i] - this.inmin[i]);
        }
        for (int pl = 0; pl < this.nplanes - 1; ++pl) {
            double[] act_pl_1 = this.act[pl + 1];
            double[] help_pl = this.help[pl];
            double[][] wgt_pl = this.wgt[pl];
            double[] bias_pl = this.bias[pl];
            double[] act_pl = this.act[pl];
            for (int i = 0; i < this.size[pl + 1]; ++i) {
                act_pl_1[i] = this.activation(bias_pl[i] + NNffbpAlphaTabFast.scp(wgt_pl[i], act_pl));
                help_pl[i] = act_pl_1[i] * (1.0 - act_pl_1[i]);
            }
            double[][] dActDX_pl = this.dActDX[pl];
            double[][] dActDX_pl1 = this.dActDX[pl + 1];
            for (int i = 0; i < this.size[pl + 1]; ++i) {
                for (int j = 0; j < this.nn_in; ++j) {
                    double sum = 0.0;
                    double help_pl_i = help_pl[i];
                    double[] wgt_pl_i = wgt_pl[i];
                    for (int k = 0; k < this.size[pl]; ++k) {
                        sum += help_pl_i * wgt_pl_i[k] * dActDX_pl[k][j];
                    }
                    dActDX_pl1[i][j] = sum;
                }
            }
        }
        double[] act_nplanes_1 = this.act[this.nplanes - 1];
        double[][] dActDX_nplanes_1 = this.dActDX[this.nplanes - 1];
        double[][] jacobiMatrix = res.getJacobiMatrix();
        double[] nnOutput = res.getNnOutput();
        for (int i = 0; i < this.nn_out; ++i) {
            double diff = this.outmax[i] - this.outmin[i];
            nnOutput[i] = act_nplanes_1[i] * diff + this.outmin[i];
            double[] res_jacobiMatrix_i = jacobiMatrix[i];
            double[] dActDX_nplanes_1_i = dActDX_nplanes_1[i];
            for (int k = 0; k < this.nn_in; ++k) {
                res_jacobiMatrix_i[k] = dActDX_nplanes_1_i[k] * diff;
            }
        }
        return res;
    }

    private void declareArrays() {
        this.NNresjacob.setNnOutput(new double[this.nn_out]);
        this.NNresjacob.setJacobiMatrix(new double[this.nn_out][this.nn_in]);
        this.dActDX = new double[this.nplanes][][];
        this.dActDX[0] = new double[this.nn_in][this.nn_in];
        for (int i = 0; i < this.nn_in; ++i) {
            for (int j = 0; j < this.nn_in; ++j) {
                this.dActDX[0][i][j] = 0.0;
            }
            this.dActDX[0][i][i] = 1.0 / (this.inmax[i] - this.inmin[i]);
        }
        this.help = new double[this.nplanes - 1][];
        for (int pl = 0; pl < this.nplanes - 1; ++pl) {
            this.help[pl] = new double[this.size[pl + 1]];
            this.dActDX[pl + 1] = new double[this.size[pl + 1]][this.nn_in];
        }
    }

    public double[] calc(double[] nninp) {
        double[] res = new double[this.nn_out];
        for (int i = 0; i < this.nn_in; ++i) {
            this.act[0][i] = (nninp[i] - this.inmin[i]) / (this.inmax[i] - this.inmin[i]);
        }
        for (int pl = 0; pl < this.nplanes - 1; ++pl) {
            double[] bias_pl = this.bias[pl];
            double[][] wgt_pl = this.wgt[pl];
            double[] act_pl = this.act[pl];
            double[] act_pl1 = this.act[pl + 1];
            int size_pl1 = this.size[pl + 1];
            for (int i = 0; i < size_pl1; ++i) {
                act_pl1[i] = this.activation(bias_pl[i] + NNffbpAlphaTabFast.scp(wgt_pl[i], act_pl));
            }
        }
        double[] act_nnplanes1 = this.act[this.nplanes - 1];
        for (int i = 0; i < this.nn_out; ++i) {
            res[i] = act_nnplanes1[i] * (this.outmax[i] - this.outmin[i]) + this.outmin[i];
        }
        return res;
    }
}

