/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.util;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.awt.Shape;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;

public class AwtGeomToJtsGeomConverter {
    private final GeometryFactory geometryFactory;
    private final double flatness;

    public AwtGeomToJtsGeomConverter() {
        this(new GeometryFactory(), -1.0);
    }

    public AwtGeomToJtsGeomConverter(GeometryFactory geometryFactory, double flatness) {
        this.geometryFactory = geometryFactory;
        this.flatness = flatness;
    }

    public Point createPoint(Point2D point) {
        return this.geometryFactory.createPoint(new Coordinate(point.getX(), point.getY()));
    }

    public MultiLineString createMultiLineString(Shape shape) {
        List<LineString> lineStringList = this.createLineStringList(shape);
        LineString[] lineStrings = lineStringList.toArray(new LineString[lineStringList.size()]);
        return this.geometryFactory.createMultiLineString(lineStrings);
    }

    public Polygon createPolygon(Shape shape) {
        List<LinearRing> linearRings = this.createLinearRingList(shape);
        LinearRing exteriorRing = linearRings.get(0);
        LinearRing[] interiorRings = null;
        if (linearRings.size() > 1) {
            List<LinearRing> subList = linearRings.subList(1, linearRings.size());
            interiorRings = subList.toArray(new LinearRing[subList.size()]);
        }
        return this.geometryFactory.createPolygon(exteriorRing, interiorRings);
    }

    public MultiPolygon createMultiPolygon(Shape shape) {
        List<LinearRing> linearRings = this.createLinearRingList(shape);
        Polygon[] polygons = new Polygon[linearRings.size()];
        for (int i = 0; i < linearRings.size(); ++i) {
            LinearRing linearRing = linearRings.get(i);
            polygons[i] = this.geometryFactory.createPolygon(linearRing, null);
        }
        return this.geometryFactory.createMultiPolygon(polygons);
    }

    public List<LinearRing> createLinearRingList(Shape shape) {
        List<List<Coordinate>> pathList = this.createPathList(shape, true);
        ArrayList<LinearRing> linearRingList = new ArrayList<LinearRing>();
        for (List<Coordinate> path : pathList) {
            Coordinate[] pathCoordinates = path.toArray(new Coordinate[path.size()]);
            linearRingList.add(this.geometryFactory.createLinearRing(pathCoordinates));
        }
        return linearRingList;
    }

    public List<LineString> createLineStringList(Shape geometry) {
        List<List<Coordinate>> pathList = this.createPathList(geometry, false);
        ArrayList<LineString> strings = new ArrayList<LineString>();
        for (List<Coordinate> path : pathList) {
            strings.add(this.geometryFactory.createLineString(path.toArray(new Coordinate[path.size()])));
        }
        return strings;
    }

    public List<List<Coordinate>> createPathList(Shape shape, boolean forceClosedPaths) {
        return this.createPathList(shape, this.flatness, forceClosedPaths);
    }

    private List<List<Coordinate>> createPathList(Shape shape, double flatness, boolean forceClosedPaths) {
        ArrayList<Object> path = new ArrayList<Coordinate>(16);
        ArrayList<List<Coordinate>> pathList = new ArrayList<List<Coordinate>>(4);
        if (flatness <= 0.0) {
            Rectangle2D d = shape.getBounds2D();
            flatness = Math.max(d.getWidth(), d.getHeight()) / 100.0;
        }
        PathIterator pathIterator = shape.getPathIterator(null, flatness);
        double[] seg = new double[6];
        int segType = -1;
        while (!pathIterator.isDone()) {
            segType = pathIterator.currentSegment(seg);
            if (segType == 4) {
                this.collectPath(path, forceClosedPaths, pathList);
                path = new ArrayList(16);
            } else {
                path.add(new Coordinate(seg[0], seg[1]));
            }
            pathIterator.next();
        }
        if (segType != 4) {
            this.collectPath(path, forceClosedPaths, pathList);
        }
        return pathList;
    }

    private void collectPath(List<Coordinate> path, boolean forceClosedPaths, List<List<Coordinate>> pathList) {
        if (forceClosedPaths) {
            this.forcePathClosed(path);
        }
        pathList.add(path);
    }

    private void forcePathClosed(List<Coordinate> path) {
        Coordinate last;
        Coordinate first = path.get(0);
        if (!first.equals2D(last = path.get(path.size() - 1))) {
            path.add(new Coordinate(first.x, first.y));
        }
    }
}

