/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.util;

public final class BitRaster {
    private final int width;
    private final int height;
    private final long[] words;

    public BitRaster(int width, int height) {
        this.width = width;
        this.height = height;
        int size = width * height;
        this.words = new long[(size >> 6) + 1];
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public void set(int x, int y, boolean value) {
        this.set(y * this.width + x, value);
    }

    public void set(int pixelIndex, boolean value) {
        if (value) {
            this.set(pixelIndex);
        } else {
            this.clear(pixelIndex);
        }
    }

    public boolean isSet(int x, int y) {
        return this.isSet(y * this.width + x);
    }

    public boolean isSet(int pixelIndex) {
        int wordIndex = pixelIndex >> 6;
        return (this.words[wordIndex] & 1L << pixelIndex) != 0L;
    }

    public void set(int pixelIndex) {
        int wordIndex;
        int n = wordIndex = pixelIndex >> 6;
        this.words[n] = this.words[n] | 1L << pixelIndex;
    }

    public void clear(int pixelIndex) {
        int wordIndex;
        int n = wordIndex = pixelIndex >> 6;
        this.words[n] = this.words[n] & (1L << pixelIndex ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public byte[] createBytePackedBitmaskRasterData() {
        int packedWidth = this.getBytePackedBitmaskRasterWidth();
        byte[] bytes = new byte[packedWidth * this.getHeight()];
        for (int y = 0; y < this.getHeight(); ++y) {
            for (int x = 0; x < this.getWidth(); ++x) {
                int n = y * packedWidth + x;
                bytes[n] = (byte)(bytes[n] | 1 << x % 8);
            }
        }
        return bytes;
    }

    public final int getBytePackedBitmaskRasterWidth() {
        int bytePackedBitmaskRasterWidth = this.getWidth() / 8;
        if (this.getWidth() % 8 != 0) {
            ++bytePackedBitmaskRasterWidth;
        }
        return bytePackedBitmaskRasterWidth;
    }
}

