/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.util;

public class ForLoop {
    private final int[] sizes;
    private final int[] indexes;
    private final int dim;

    public ForLoop(int[] sizes) {
        this.sizes = (int[])sizes.clone();
        this.indexes = new int[sizes.length];
        this.dim = sizes.length - 1;
    }

    public static ForLoop execute(int[] sizes, Body body) {
        ForLoop forLoop = new ForLoop(sizes);
        forLoop.execute(body);
        return forLoop;
    }

    public ForLoop execute(Body body) {
        if (this.dim >= 0) {
            this.loopN(body, this.dim);
        }
        return this;
    }

    private void loopN(Body body, int off) {
        for (int k = 0; k < this.sizes[this.dim - off]; ++k) {
            this.indexes[this.dim - off] = k;
            if (off == 0) {
                body.execute(this.indexes, this.sizes);
                continue;
            }
            this.loopN(body, off - 1);
        }
    }

    public static interface Body {
        public void execute(int[] var1, int[] var2);
    }
}

