/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.util;

import com.bc.ceres.core.Assert;
import org.esa.beam.util.ObjectUtils;

public class Guardian {
    public static void assertTrue(String message, boolean condition) {
        Assert.argument((boolean)condition, (String)message);
    }

    public static void assertNotNull(String exprText, Object exprValue) {
        if (exprValue == null) {
            throw new IllegalArgumentException("[" + exprText + "] is null");
        }
    }

    public static void assertNotNullOrEmpty(String exprText, String exprValue) {
        Guardian.assertNotNull(exprText, exprValue);
        Guardian.assertNonEmptyString(exprText, exprValue.length());
    }

    public static void assertNotNullOrEmpty(String exprText, byte[] exprValue) {
        Guardian.assertNotNull(exprText, exprValue);
        Guardian.assertNonEmptyArray(exprText, exprValue.length);
    }

    public static void assertNotNullOrEmpty(String exprText, char[] exprValue) {
        Guardian.assertNotNull(exprText, exprValue);
        Guardian.assertNonEmptyArray(exprText, exprValue.length);
    }

    public static void assertNotNullOrEmpty(String exprText, short[] exprValue) {
        Guardian.assertNotNull(exprText, exprValue);
        Guardian.assertNonEmptyArray(exprText, exprValue.length);
    }

    public static void assertNotNullOrEmpty(String exprText, int[] exprValue) {
        Guardian.assertNotNull(exprText, exprValue);
        Guardian.assertNonEmptyArray(exprText, exprValue.length);
    }

    public static void assertNotNullOrEmpty(String exprText, float[] exprValue) {
        Guardian.assertNotNull(exprText, exprValue);
        Guardian.assertNonEmptyArray(exprText, exprValue.length);
    }

    public static void assertNotNullOrEmpty(String exprText, double[] exprValue) {
        Guardian.assertNotNull(exprText, exprValue);
        Guardian.assertNonEmptyArray(exprText, exprValue.length);
    }

    public static void assertNotNullOrEmpty(String exprText, Object[] exprValue) {
        Guardian.assertNotNull(exprText, exprValue);
        Guardian.assertNonEmptyArray(exprText, exprValue.length);
    }

    public static void assertGreaterThan(String exprText, long exprValue, long limit) {
        if (exprValue <= limit) {
            StringBuffer sb = Guardian.createExprStringBuffer(exprText).append(" is less than or equal to [").append(limit).append("]");
            throw new IllegalArgumentException(sb.toString());
        }
    }

    public static void assertEquals(String exprText, boolean exprValue, boolean expectedValue) {
        Guardian.assertEquals(exprText, (Object)exprValue, (Object)expectedValue);
    }

    public static void assertEquals(String exprText, long exprValue, long expectedValue) {
        if (expectedValue != exprValue) {
            StringBuffer sb = Guardian.createExprStringBuffer(exprText).append(" is [").append(exprValue).append("] but should be equal to [").append(expectedValue).append("]");
            throw new IllegalArgumentException(sb.toString());
        }
    }

    public static void assertEquals(String exprText, Object exprValue, Object expectedValue) {
        if (!ObjectUtils.equalObjects(expectedValue, exprValue)) {
            StringBuffer sb = Guardian.createExprStringBuffer(exprText).append(" is [").append(exprValue).append("] but should be equal to [").append(expectedValue).append("]");
            throw new IllegalArgumentException(sb.toString());
        }
    }

    public static void assertSame(String exprText, Object exprValue, Object expectedValue) {
        if (expectedValue != exprValue) {
            StringBuffer sb = Guardian.createExprStringBuffer(exprText).append(" is [").append(exprValue).append("] but should be same as [").append(expectedValue).append("]");
            throw new IllegalArgumentException(sb.toString());
        }
    }

    public static void assertWithinRange(String exprText, long exprValue, long rangeMin, long rangeMax) {
        if (exprValue < rangeMin || exprValue > rangeMax) {
            StringBuffer sb = Guardian.createExprStringBuffer(exprText).append(" is [").append(exprValue).append("]  but should be in the range [").append(rangeMin).append("] to [").append(rangeMax).append("]");
            throw new IllegalArgumentException(sb.toString());
        }
    }

    public static void assertWithinRange(String exprText, double exprValue, double rangeMin, double rangeMax) {
        if (exprValue < rangeMin || exprValue > rangeMax) {
            StringBuffer sb = Guardian.createExprStringBuffer(exprText).append(" is [").append(exprValue).append("]  but should be in the range [").append(rangeMin).append("] to [").append(rangeMax).append("]");
            throw new IllegalArgumentException(sb.toString());
        }
    }

    private static void assertNonEmptyString(String exprText, int length) {
        if (length == 0) {
            StringBuffer sb = Guardian.createExprStringBuffer(exprText).append(" is an empty string");
            throw new IllegalArgumentException(sb.toString());
        }
    }

    private static void assertNonEmptyArray(String exprText, int length) {
        if (length == 0) {
            StringBuffer sb = Guardian.createExprStringBuffer(exprText).append(" is an empty array");
            throw new IllegalArgumentException(sb.toString());
        }
    }

    private static StringBuffer createExprStringBuffer(String exprText) {
        return new StringBuffer(32).append("[").append(exprText).append("]");
    }
}

