/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.util;

import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class IntMap
implements Cloneable {
    public static final int NULL = Integer.MIN_VALUE;
    private final Map<Integer, Integer> map = new TreeMap<Integer, Integer>();
    private final int[] table;
    private final int tableOffset;
    private int size;

    public IntMap() {
        this(0, 1024);
    }

    public IntMap(int tableOffset, int bufferSize) {
        this.table = new int[bufferSize];
        this.tableOffset = tableOffset;
        this.size = 0;
        Arrays.fill(this.table, Integer.MIN_VALUE);
    }

    public int getSize() {
        return this.size;
    }

    public void putValue(int key, int value) {
        if (value == Integer.MIN_VALUE) {
            throw new IllegalArgumentException("value");
        }
        int index = key - this.tableOffset;
        if (index >= 0 && index < this.table.length) {
            int oldValue = this.table[index];
            this.table[index] = value;
            if (oldValue == Integer.MIN_VALUE) {
                ++this.size;
            }
        } else {
            Integer oldValue = this.map.put(key, value);
            if (oldValue == null) {
                ++this.size;
            }
        }
    }

    public void removeValue(int key) {
        int index = key - this.tableOffset;
        if (index >= 0 && index < this.table.length) {
            int oldValue = this.table[index];
            this.table[index] = Integer.MIN_VALUE;
            if (oldValue != Integer.MIN_VALUE) {
                --this.size;
            }
        } else {
            Integer oldValue = this.map.remove(key);
            if (oldValue != null) {
                --this.size;
            }
        }
    }

    public int getValue(int key) {
        int index = key - this.tableOffset;
        if (index >= 0 && index < this.table.length) {
            return this.table[index];
        }
        Integer oldValue = this.map.get(key);
        if (oldValue != null) {
            return oldValue;
        }
        return Integer.MIN_VALUE;
    }

    public int[] getKeys() {
        int[] keys = new int[this.getSize()];
        int j = 0;
        for (int index = 0; index < this.table.length; ++index) {
            int value = this.table[index];
            if (value == Integer.MIN_VALUE) continue;
            keys[j++] = index + this.tableOffset;
        }
        Set<Integer> set = this.map.keySet();
        for (Integer key : set) {
            keys[j++] = key;
        }
        Arrays.sort(keys);
        return keys;
    }

    public int[][] getPairs() {
        int[] keys = this.getKeys();
        int[][] pairs = new int[keys.length][2];
        for (int i = 0; i < keys.length; ++i) {
            pairs[i][0] = keys[i];
            pairs[i][1] = this.getValue(keys[i]);
        }
        return pairs;
    }

    public int[][] getRanges() {
        int[] keys = this.getKeys();
        int keyMin = Integer.MAX_VALUE;
        int keyMax = Integer.MIN_VALUE;
        int valueMin = Integer.MAX_VALUE;
        int valueMax = Integer.MIN_VALUE;
        for (int key : keys) {
            keyMin = Math.min(keyMin, key);
            keyMax = Math.max(keyMax, key);
            int value = this.getValue(key);
            valueMin = Math.min(valueMin, value);
            valueMax = Math.max(valueMax, value);
        }
        return new int[][]{{keyMin, keyMax}, {valueMin, valueMax}};
    }

    public Object clone() {
        int[][] pairs;
        IntMap clone = new IntMap(this.tableOffset, this.table.length);
        for (int[] pair : pairs = this.getPairs()) {
            clone.putValue(pair[0], pair[1]);
        }
        return clone;
    }
}

