/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.util;

import com.bc.ceres.core.ProgressMonitor;
import com.bc.ceres.core.SubProgressMonitor;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.CodeSource;
import org.esa.beam.util.ResourceScanner;

public class ResourceInstaller {
    private ResourceScanner scanner;
    private File targetDir;

    public ResourceInstaller(URL sourceBaseUrl, String sourceRelPath, File targetDir) {
        this.targetDir = targetDir;
        this.scanner = new ResourceScanner(new URL[]{sourceBaseUrl}, sourceRelPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void install(String patternString, ProgressMonitor pm) throws IOException {
        try {
            pm.beginTask("Installing resource data: ", 2);
            this.scanner.scan(SubProgressMonitor.create((ProgressMonitor)pm, (int)1));
            URL[] resources = this.scanner.getResourcesByPattern(patternString);
            this.copyResources(resources, SubProgressMonitor.create((ProgressMonitor)pm, (int)1));
        }
        finally {
            pm.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyResources(URL[] resources, ProgressMonitor pm) throws IOException {
        pm.beginTask("Copying resource data...", resources.length);
        for (URL resource : resources) {
            String relFilePath = this.scanner.getRelativePath(resource);
            File targetFile = new File(this.targetDir, relFilePath);
            if (!targetFile.exists() && !resource.toExternalForm().endsWith("/")) {
                InputStream is = null;
                FileOutputStream fos = null;
                try {
                    is = resource.openStream();
                    File parentFile = targetFile.getParentFile();
                    if (parentFile == null) {
                        throw new IOException("Could not retrieve the parent directory of '" + targetFile.getAbsolutePath() + "'.");
                    }
                    parentFile.mkdirs();
                    targetFile.createNewFile();
                    fos = new FileOutputStream(targetFile);
                    byte[] bytes = new byte[0x100000];
                    int bytesRead = is.read(bytes);
                    while (bytesRead != -1) {
                        fos.write(bytes, 0, bytesRead);
                        bytesRead = is.read(bytes);
                    }
                }
                finally {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException ignored) {}
                    }
                    if (fos != null) {
                        try {
                            fos.close();
                        }
                        catch (IOException ignored) {}
                    }
                }
            }
            pm.worked(1);
        }
    }

    public static URL getSourceUrl(Class aClass) {
        CodeSource codeSource = aClass.getProtectionDomain().getCodeSource();
        URL sourceLocation = codeSource != null ? codeSource.getLocation() : aClass.getResource("/");
        return sourceLocation;
    }
}

