/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.util;

import com.bc.jexp.impl.Tokenizer;
import java.awt.Color;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;
import org.esa.beam.util.Guardian;

public class StringUtils {
    public static List<String> split(String text, char[] separators, boolean trimTokens, List<String> tokens) {
        Guardian.assertNotNull("text", text);
        if (separators == null || separators.length == 0) {
            throw new IllegalArgumentException("Separators must not be null or empty.");
        }
        if (tokens == null) {
            tokens = new ArrayList<String>();
        }
        String sepsStr = new String(separators);
        StringTokenizer st = new StringTokenizer(text, sepsStr, true);
        String lastToken = null;
        while (st.hasMoreTokens()) {
            String token;
            try {
                token = st.nextToken();
            }
            catch (Exception e) {
                break;
            }
            if (StringUtils.isSeparatorToken(token, sepsStr)) {
                if (lastToken == null || StringUtils.isSeparatorToken(lastToken, sepsStr)) {
                    tokens.add("");
                }
            } else {
                if (trimTokens) {
                    token = token.trim();
                }
                tokens.add(token);
            }
            lastToken = token;
        }
        if (lastToken != null && StringUtils.isSeparatorToken(lastToken, sepsStr)) {
            tokens.add("");
        }
        return tokens;
    }

    public static String[] split(String text, char[] separators, boolean trimTokens) {
        List<String> tokens = StringUtils.split(text, separators, trimTokens, null);
        return tokens.toArray(new String[tokens.size()]);
    }

    public static String join(Object[] tokens, String separator) {
        if (tokens == null) {
            throw new IllegalArgumentException("Tokens must not be null.");
        }
        if (separator == null) {
            throw new IllegalArgumentException("Separators must not be null.");
        }
        StringBuilder sb = new StringBuilder(tokens.length * 16);
        for (int i = 0; i < tokens.length; ++i) {
            if (i > 0) {
                sb.append(separator);
            }
            if (tokens[i] == null) continue;
            sb.append(tokens[i].toString());
        }
        return sb.toString();
    }

    public static String join(List tokens, String separator) {
        if (tokens == null) {
            throw new IllegalArgumentException("Tokens must not be null.");
        }
        return StringUtils.join(tokens.toArray(), separator);
    }

    public static boolean isIntegerString(String token) {
        return StringUtils.isIntegerString(token, 10);
    }

    public static boolean isIntegerString(String token, int radix) {
        if (token != null) {
            try {
                Integer.parseInt(token, radix);
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return false;
    }

    public static int[] toIntArray(String text, String delim) {
        Guardian.assertNotNull("text", text);
        if (delim == null || delim.length() == 0) {
            delim = ",";
        }
        String[] tokens = StringUtils.split(text, delim.toCharArray(), true);
        int[] numbers = new int[tokens.length];
        for (int i = 0; i < numbers.length; ++i) {
            numbers[i] = Integer.parseInt(tokens[i]);
        }
        return numbers;
    }

    public static float[] toFloatArray(String text, String delim) {
        Guardian.assertNotNull("text", text);
        if (delim == null || delim.length() == 0) {
            delim = ",";
        }
        String[] tokens = StringUtils.split(text, delim.toCharArray(), true);
        float[] numbers = new float[tokens.length];
        for (int i = 0; i < numbers.length; ++i) {
            numbers[i] = Float.parseFloat(tokens[i]);
        }
        return numbers;
    }

    public static double[] toDoubleArray(String text, String delim) {
        Guardian.assertNotNull("text", text);
        if (delim == null || delim.length() == 0) {
            delim = ",";
        }
        String[] tokens = StringUtils.split(text, delim.toCharArray(), true);
        double[] numbers = new double[tokens.length];
        for (int i = 0; i < numbers.length; ++i) {
            numbers[i] = Double.parseDouble(tokens[i]);
        }
        return numbers;
    }

    public static String[] toStringArray(String text, String delims) {
        Guardian.assertNotNull("text", text);
        if (delims == null || delims.length() == 0) {
            delims = ",";
        }
        return StringUtils.split(text, delims.toCharArray(), true);
    }

    public static String[] toStringArray(Object[] objArray) {
        if (objArray == null || objArray instanceof String[]) {
            return (String[])objArray;
        }
        String[] strArray = new String[objArray.length];
        for (int i = 0; i < objArray.length; ++i) {
            strArray[i] = objArray[i] != null ? objArray[i].toString() : null;
        }
        return strArray;
    }

    public static boolean isNullOrEmpty(String str) {
        return str == null || str.isEmpty();
    }

    public static boolean isNotNullAndNotEmpty(String str) {
        return str != null && !str.isEmpty();
    }

    public static String[] addToArray(String[] array, String toAdd) throws IllegalArgumentException {
        Guardian.assertNotNull("array", array);
        Guardian.assertNotNull("toAdd", toAdd);
        String[] newArray = new String[array.length + 1];
        System.arraycopy(array, 0, newArray, 0, array.length);
        newArray[array.length] = toAdd;
        return newArray;
    }

    public static String[] removeFromArray(String[] array, String toRemove) throws IllegalArgumentException {
        Guardian.assertNotNull("array", array);
        Guardian.assertNotNull("toRemove", toRemove);
        int index = StringUtils.indexOf(array, toRemove);
        if (index == -1) {
            return array;
        }
        String[] newArray = new String[array.length - 1];
        int offset = 0;
        for (int i = 0; i < array.length; ++i) {
            if (i != index) {
                newArray[i + offset] = array[i];
                continue;
            }
            offset = -1;
        }
        return newArray;
    }

    public static String[] removeFromArray(String[] array, String[] toRemove) throws IllegalArgumentException {
        Guardian.assertNotNull("array", array);
        if (toRemove == null) {
            return array;
        }
        String[] newArray = array;
        for (String item : toRemove) {
            newArray = StringUtils.removeFromArray(newArray, item);
        }
        return newArray;
    }

    public static String[] addArrays(String[] arr1, String[] arr2) throws IllegalArgumentException {
        Guardian.assertNotNull("arr1", arr1);
        Guardian.assertNotNull("arr2", arr2);
        int length1 = arr1.length;
        int length2 = arr2.length;
        String[] newArray = new String[length1 + length2];
        System.arraycopy(arr1, 0, newArray, 0, length1);
        System.arraycopy(arr2, 0, newArray, length1, length2);
        return newArray;
    }

    public static boolean contains(String[] a, String s) {
        return StringUtils.indexOf(a, s) >= 0;
    }

    public static boolean containsIgnoreCase(String[] a, String s) {
        return StringUtils.indexOfIgnoreCase(a, s) >= 0;
    }

    public static boolean containsIgnoreCase(List l, String s) {
        return StringUtils.indexOfIgnoreCase(l, s) >= 0;
    }

    public static boolean areEntriesUnique(String[] array) {
        Guardian.assertNotNull("array", array);
        for (int i = 0; i < array.length; ++i) {
            for (int j = i + 1; j < array.length; ++j) {
                if (array[i] != array[j] && (array[i] == null || array[j] == null || !array[i].equals(array[j]))) continue;
                return false;
            }
        }
        return true;
    }

    public static int indexOf(String[] a, String s) {
        Guardian.assertNotNull("a", a);
        Guardian.assertNotNull("s", s);
        for (int i = 0; i < a.length; ++i) {
            if (!s.equals(a[i])) continue;
            return i;
        }
        return -1;
    }

    public static int indexOfIgnoreCase(String[] a, String s) {
        Guardian.assertNotNull("a", a);
        Guardian.assertNotNull("s", s);
        for (int i = 0; i < a.length; ++i) {
            if (!s.equalsIgnoreCase(a[i])) continue;
            return i;
        }
        return -1;
    }

    public static int indexOfIgnoreCase(List l, String s) {
        Guardian.assertNotNull("l", l);
        Guardian.assertNotNull("s", s);
        for (int i = 0; i < l.size(); ++i) {
            if (l.get(i) == null || !l.get(i).toString().equalsIgnoreCase(s)) continue;
            return i;
        }
        return -1;
    }

    public static String arrayToCsv(Object array) {
        return StringUtils.arrayToString(array, ",");
    }

    public static String arrayToString(Object array, String s) {
        Guardian.assertNotNull("array", array);
        int length = Array.getLength(array);
        if (length == 0) {
            return "";
        }
        if (length == 1) {
            return Array.get(array, 0).toString();
        }
        StringBuilder sb = new StringBuilder(length * 8);
        sb.append(Array.get(array, 0));
        for (int i = 1; i < length; ++i) {
            sb.append(s);
            sb.append(Array.get(array, i));
        }
        return sb.toString();
    }

    public static String[] csvToArray(String csvString) {
        return StringUtils.stringToArray(csvString, ",");
    }

    public static String[] stringToArray(String csvString, String delim) {
        Guardian.assertNotNullOrEmpty("csvString", csvString);
        Guardian.assertNotNullOrEmpty("delim", delim);
        StringTokenizer tokenizer = new StringTokenizer(csvString, delim);
        ArrayList<String> strList = new ArrayList<String>(tokenizer.countTokens());
        while (tokenizer.hasMoreTokens()) {
            strList.add(tokenizer.nextToken());
        }
        return strList.toArray(new String[strList.size()]);
    }

    private static boolean isSeparatorToken(String token, String separators) {
        return token.length() == 1 && separators.contains(token);
    }

    protected StringUtils() {
    }

    public static Color parseColor(String text) throws NumberFormatException {
        Color color = null;
        String trimedText = text.trim();
        String[] components = StringUtils.split(trimedText, new char[]{','}, true);
        try {
            if (components.length == 1) {
                color = Color.decode(trimedText);
            }
            if (components.length >= 3) {
                int r = Integer.parseInt(components[0]);
                int g = Integer.parseInt(components[1]);
                int b = Integer.parseInt(components[2]);
                int a = 255;
                if (components.length > 3) {
                    a = Integer.parseInt(components[3]);
                }
                color = new Color(r, g, b, a);
            }
        }
        catch (NumberFormatException e) {
            color = null;
        }
        return color;
    }

    public static String formatColor(Color c) {
        StringBuilder sb = new StringBuilder();
        sb.append(c.getRed());
        sb.append(',');
        sb.append(c.getGreen());
        sb.append(',');
        sb.append(c.getBlue());
        if (c.getAlpha() != 255) {
            sb.append(',');
            sb.append(c.getAlpha());
        }
        return sb.toString();
    }

    public static String createValidName(String name, char[] validChars, char replaceChar) {
        Guardian.assertNotNull("name", name);
        char[] sortedValidChars = validChars == null ? new char[]{} : (char[])validChars.clone();
        Arrays.sort(sortedValidChars);
        StringBuilder validName = new StringBuilder(name.length());
        for (int i = 0; i < name.length(); ++i) {
            char ch = name.charAt(i);
            if (Character.isLetterOrDigit(ch)) {
                validName.append(ch);
                continue;
            }
            if (Arrays.binarySearch(sortedValidChars, ch) >= 0) {
                validName.append(ch);
                continue;
            }
            validName.append(replaceChar);
        }
        return validName.toString();
    }

    public static String replaceWord(String string, String oldWord, String newWord) {
        Guardian.assertNotNull("string", string);
        Guardian.assertNotNullOrEmpty("oldWord", oldWord);
        Guardian.assertNotNull("newWord", newWord);
        return string.replaceAll("\\b" + oldWord + "\\b", newWord);
    }

    public static boolean isIdentifier(String s) {
        return Tokenizer.isExternalName(s);
    }

    public static boolean isNumeric(String str, Class<? extends Number> clazz) {
        try {
            if (clazz.equals(Byte.class)) {
                Byte.parseByte(str);
            } else if (clazz.equals(Double.class)) {
                Double.parseDouble(str);
            } else if (clazz.equals(Float.class)) {
                Float.parseFloat(str);
            } else if (clazz.equals(Integer.class)) {
                Integer.parseInt(str);
            } else if (clazz.equals(Long.class)) {
                Long.parseLong(str);
            } else if (clazz.equals(Short.class)) {
                Short.parseShort(str);
            }
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        return true;
    }

    public static String firstLetterUp(String string) {
        String firstChar = string.substring(0, 1).toUpperCase();
        return firstChar + string.substring(1);
    }

    public static int indexOfSpecificOccurrence(String a, String s, int i) {
        int indexOfLastOccurrence = -1;
        for (int j = 0; j < i; ++j) {
            if ((indexOfLastOccurrence = a.indexOf(s, indexOfLastOccurrence + 1)) != -1 && indexOfLastOccurrence != a.length()) continue;
            return -1;
        }
        return indexOfLastOccurrence;
    }

    public static String padNum(int num, int max, char c) {
        StringBuilder str = new StringBuilder(String.valueOf(num));
        while (str.length() < max) {
            str.insert(0, c);
        }
        return str.toString();
    }
}

