/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.util;

import com.bc.ceres.core.runtime.RuntimeContext;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.text.MessageFormat;
import java.util.NoSuchElementException;
import java.util.ServiceLoader;
import java.util.StringTokenizer;
import java.util.logging.Level;
import javax.media.jai.JAI;
import javax.media.jai.OperationRegistry;
import javax.swing.UIManager;
import org.esa.beam.util.Guardian;
import org.esa.beam.util.logging.BeamLogManager;

public class SystemUtils {
    @Deprecated
    public static final String BEAM_HOME_PAGE = SystemUtils.getApplicationHomepageUrl();
    @Deprecated
    public static final String BEAM_HOME_PROPERTY_NAME = SystemUtils.getApplicationHomePropertyName();
    @Deprecated
    public static final String BEAM_PLUGIN_PATH_PROPERTY_NAME = "beam.plugin.path";
    public static final String BEAM_PARALLELISM_PROPERTY_NAME = "snap.parallelism";
    public static final String LAX_INSTALL_DIR_PROPERTY_NAME = "lax.root.install.dir";
    public static final String LS = System.getProperty("line.separator");
    private static final char _URL_DIR_SEPARATOR_CHAR = '/';
    public static final int LL_DEBUG = 10;
    public static final int LL_INFO = 20;
    public static final int LL_WARNING = 30;
    public static final int LL_ERROR = 40;
    public static final String LLS_DEBUG = "DEBUG";
    public static final String LLS_INFO = "INFO";
    public static final String LLS_WARNING = "WARNING";
    public static final String LLS_ERROR = "ERROR";
    public static final String EXTENSION_DIR_NAME = "extensions";
    public static final String AUXDATA_DIR_NAME = "auxdata";
    public static final String CACHE_DIR_NAME = "cache";
    private static final String _H5_CLASS_NAME = "ncsa.hdf.hdf5lib.H5";
    private static final String _H4_CLASS_NAME = "ncsa.hdf.hdflib.HDFLibrary";
    private static final String FILE_PROTOCOL_PREFIX = "file:";
    private static final String JAR_PROTOCOL_PREFIX = "jar:";
    private static final String EPSG_DATABASE_DIR_NAME = "epsg-database";
    private static final String JAI_REGISTRY_PATH = "/META-INF/javax.media.jai.registryFile.jai";

    public static String getUserName() {
        return System.getProperty("user.name", "unknown");
    }

    public static File getUserHomeDir() {
        return new File(System.getProperty("user.home", "."));
    }

    public static String getApplicationHomepageUrl() {
        return System.getProperty(SystemUtils.getApplicationContextId() + ".homepage.url", "http://sentinel.esa.int");
    }

    public static File getApplicationDataDir() {
        return SystemUtils.getApplicationDataDir(false);
    }

    public static File getApplicationDataDir(boolean force) {
        String contextId = SystemUtils.getApplicationContextId();
        File dir = new File(SystemUtils.getUserHomeDir(), "." + contextId);
        if (force && !dir.exists()) {
            dir.mkdirs();
        }
        return dir;
    }

    public static String getApplicationContextId() {
        String contextId = null;
        if (RuntimeContext.getModuleContext() != null) {
            contextId = RuntimeContext.getModuleContext().getRuntimeConfig().getContextId();
        }
        if (contextId == null) {
            contextId = System.getProperty("ceres.context", "snap");
        }
        return contextId;
    }

    public static String getApplicationName() {
        return System.getProperty(SystemUtils.getApplicationContextId() + ".application.name", "SNAP");
    }

    public static File getCurrentWorkingDir() {
        return new File(System.getProperty("user.dir", "."));
    }

    public static File[] getClassPathFiles() {
        String classPath = System.getProperty("java.class.path");
        if (classPath == null) {
            return new File[0];
        }
        StringTokenizer st = new StringTokenizer(classPath, File.pathSeparator);
        File[] files = new File[st.countTokens()];
        try {
            for (int i = 0; i < files.length; ++i) {
                files[i] = new File(st.nextToken());
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return files;
    }

    public static File getApplicationHomeDir() {
        String homeKey = SystemUtils.getApplicationHomePropertyName();
        String homeValue = System.getProperty(homeKey);
        if (homeValue != null) {
            return new File(homeValue);
        }
        URL url = SystemUtils.class.getResource(SystemUtils.getClassFileName(SystemUtils.class));
        return SystemUtils.getApplicationHomeDir(url);
    }

    public static String getApplicationHomePropertyName() {
        return SystemUtils.getApplicationContextId() + ".home";
    }

    public static File getApplicationHomeDir(URL url) {
        Guardian.assertNotNull("url", url);
        String path = url.getPath();
        try {
            path = URLDecoder.decode(path, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        path = SystemUtils.stripUrlProtocolPrefixes(path);
        path = path.replace(File.separatorChar, '/');
        path = SystemUtils.stripClassLibraryPaths(path);
        path = path.replace('/', File.separatorChar);
        return new File(path);
    }

    private static String stripClassLibraryPaths(String path) {
        int pos = path.lastIndexOf("/modules/");
        if (pos >= 0) {
            path = path.substring(0, pos);
        }
        return path;
    }

    public static String getClassFileName(Class aClass) {
        Guardian.assertNotNull("aClass", aClass);
        String qualClassName = aClass.getName();
        int pos = qualClassName.lastIndexOf(46);
        String className = pos > 0 ? qualClassName.substring(pos + 1) : qualClassName;
        return className + ".class";
    }

    private static String stripUrlProtocolPrefixes(String path) {
        while (true) {
            if (path.startsWith(FILE_PROTOCOL_PREFIX)) {
                path = path.substring(FILE_PROTOCOL_PREFIX.length());
                continue;
            }
            if (!path.startsWith(JAR_PROTOCOL_PREFIX)) break;
            path = path.substring(JAR_PROTOCOL_PREFIX.length());
        }
        return path;
    }

    @Deprecated
    public static File getBeamHomeDir() {
        String homeKey = SystemUtils.getApplicationHomePropertyName();
        String homeDir = System.getProperty(homeKey);
        if (homeDir != null && homeDir.length() > 0) {
            return new File(homeDir);
        }
        homeDir = System.getProperty(LAX_INSTALL_DIR_PROPERTY_NAME);
        if (homeDir != null && homeDir.length() > 0) {
            return new File(homeDir);
        }
        URL url = SystemUtils.class.getResource(SystemUtils.getClassFileName(SystemUtils.class));
        String path = url.getPath();
        try {
            path = URLDecoder.decode(path, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            // empty catch block
        }
        path = path.replace(File.separatorChar, '/');
        String beam4Key = "/beam4/";
        int beam4Index = path.indexOf(beam4Key);
        if (beam4Index != -1) {
            path = path.substring(0, beam4Index + beam4Key.length() - 1);
            path = path.replace('/', File.separatorChar);
            return new File(path);
        }
        return new File(".").getAbsoluteFile();
    }

    public static File getDefaultBeamCacheDir() {
        return new File(SystemUtils.getApplicationDataDir(), CACHE_DIR_NAME);
    }

    public static String convertToLocalPath(String urlPath) {
        Guardian.assertNotNull("urlPath", urlPath);
        if (File.separatorChar != '/' && urlPath.indexOf(47) >= 0) {
            return urlPath.replace('/', File.separatorChar);
        }
        return urlPath;
    }

    public static String createHumanReadableExceptionMessage(Exception e) {
        if (e == null) {
            return null;
        }
        String message = e.getMessage();
        if (message != null && message.length() > 0) {
            StringBuffer sb = new StringBuffer();
            sb.append(Character.toUpperCase(message.charAt(0)));
            sb.append(message.substring(1));
            String[] punctuators = new String[]{".", ",", "!", "?", ";", ":"};
            boolean punctuatorFound = false;
            for (String punctuator : punctuators) {
                if (!message.endsWith(punctuator)) continue;
                punctuatorFound = true;
                break;
            }
            if (!punctuatorFound) {
                sb.append('.');
            }
            message = sb.toString();
        } else {
            message = "No message text available.";
        }
        return message;
    }

    public static void copyToClipboard(String text) {
        StringSelection selection = new StringSelection(text == null ? "" : text);
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        if (clipboard != null) {
            clipboard.setContents(selection, selection);
        } else {
            BeamLogManager.getSystemLogger().severe("failed to obtain clipboard instance");
        }
    }

    public static void copyToClipboard(Image image) {
        ImageSelection selection = new ImageSelection(image);
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        if (clipboard != null) {
            clipboard.setContents(selection, null);
        } else {
            BeamLogManager.getSystemLogger().severe("failed to obtain clipboard instance");
        }
    }

    public static boolean isRunningOnMacOS() {
        String osName = System.getProperty("os.name");
        if ("Mac OS X".equalsIgnoreCase(osName)) {
            return true;
        }
        String macOsSpecificPropertyKey = "mrj.version";
        String systemLafName = UIManager.getSystemLookAndFeelClassName();
        String currentLafName = UIManager.getLookAndFeel().getClass().getName();
        return System.getProperty("mrj.version") != null && systemLafName.equals(currentLafName);
    }

    public static <S> Iterable<S> loadServices(Class<S> serviceType) {
        return ServiceLoader.load(serviceType);
    }

    public static <S> Iterable<S> loadServices(Class<S> serviceType, ClassLoader classLoader) {
        return ServiceLoader.load(serviceType, classLoader);
    }

    public static String getBuildNumber() {
        return System.getProperty(SystemUtils.getApplicationContextId() + ".build.id", "1");
    }

    public static int getLogLevel(String logLevelStr) {
        int logLevel = 20;
        if (LLS_DEBUG.equalsIgnoreCase(logLevelStr)) {
            logLevel = 10;
        } else if (LLS_INFO.equalsIgnoreCase(logLevelStr)) {
            logLevel = 20;
        } else if (LLS_ERROR.equalsIgnoreCase(logLevelStr)) {
            logLevel = 40;
        } else if (LLS_WARNING.equalsIgnoreCase(logLevelStr)) {
            logLevel = 30;
        }
        return logLevel;
    }

    @Deprecated
    public static Class<?> loadHdf4Lib(Class<?> callerClass) {
        return SystemUtils.loadClassWithNativeDependencies(callerClass, _H4_CLASS_NAME, "{0}: HDF-4 library not available: {1}: {2}");
    }

    @Deprecated
    public static Class<?> loadHdf5Lib(Class<?> callerClass) {
        return SystemUtils.loadClassWithNativeDependencies(callerClass, _H5_CLASS_NAME, "{0}: HDF-5 library not available: {1}: {2}");
    }

    @Deprecated
    private static Class<?> loadClassWithNativeDependencies(Class<?> callerClass, String className, String warningPattern) {
        ClassLoader classLoader = callerClass.getClassLoader();
        String classResourceName = "/" + className.replace('.', '/') + ".class";
        SystemUtils.class.getResource(classResourceName);
        if (callerClass.getResource(classResourceName) != null) {
            try {
                return Class.forName(className, true, classLoader);
            }
            catch (Throwable error) {
                BeamLogManager.getSystemLogger().warning(MessageFormat.format(warningPattern, callerClass, error.getClass(), error.getMessage()));
                return null;
            }
        }
        return null;
    }

    public static void init3rdPartyLibs(ClassLoader cl) {
        SystemUtils.initJAI(cl);
        SystemUtils.initGeoTools();
    }

    private static void initGeoTools() {
        File epsgDir = new File(SystemUtils.getApplicationDataDir(true), EPSG_DATABASE_DIR_NAME);
        System.setProperty("EPSG-HSQL.directory", epsgDir.getAbsolutePath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initJAI(ClassLoader cl) {
        System.setProperty("com.sun.media.jai.disableMediaLib", "true");
        OperationRegistry operationRegistry = OperationRegistry.getThreadSafeOperationRegistry();
        InputStream is = SystemUtils.class.getResourceAsStream(JAI_REGISTRY_PATH);
        if (is != null) {
            PrintStream oldErr = System.err;
            try {
                SystemUtils.setSystemErr(new PrintStream(new ByteArrayOutputStream()));
                operationRegistry.updateFromStream(is);
                operationRegistry.registerServices(cl);
                JAI.getDefaultInstance().setOperationRegistry(operationRegistry);
            }
            catch (IOException e) {
                BeamLogManager.getSystemLogger().log(Level.SEVERE, MessageFormat.format("Error loading {0}: {1}", JAI_REGISTRY_PATH, e.getMessage()), e);
            }
            finally {
                SystemUtils.setSystemErr(oldErr);
            }
        } else {
            BeamLogManager.getSystemLogger().warning(MessageFormat.format("{0} not found", JAI_REGISTRY_PATH));
        }
        Integer parallelism = Integer.getInteger(BEAM_PARALLELISM_PROPERTY_NAME, Runtime.getRuntime().availableProcessors());
        JAI.getDefaultInstance().getTileScheduler().setParallelism(parallelism.intValue());
        BeamLogManager.getSystemLogger().info(MessageFormat.format("JAI tile scheduler parallelism set to {0}", parallelism));
    }

    private static void setSystemErr(PrintStream oldErr) {
        try {
            System.setErr(oldErr);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String getApplicationRemoteVersionUrl() {
        String key = SystemUtils.getApplicationContextId() + ".remoteVersion.url";
        String applicationHomepageUrl = SystemUtils.getApplicationHomepageUrl();
        if (!applicationHomepageUrl.endsWith("/")) {
            applicationHomepageUrl = applicationHomepageUrl + "/";
        }
        return System.getProperty(key, applicationHomepageUrl + "software/version.txt");
    }

    public static class ImageSelection
    implements Transferable {
        private Image _image;

        public ImageSelection(Image image) {
            this._image = image;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{DataFlavor.imageFlavor};
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return DataFlavor.imageFlavor.equals(flavor);
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if (!DataFlavor.imageFlavor.equals(flavor)) {
                throw new UnsupportedFlavorException(flavor);
            }
            return this._image;
        }
    }
}

