/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.util.converters;

import com.bc.ceres.binding.ConversionException;
import com.bc.ceres.binding.Converter;

public class JavaTypeConverter
implements Converter<Class> {
    private static final String[] DEFAULT_PACKAGE_QUALIFIERS = new String[]{"", "java.lang.", "java.util.", "com.vividsolutions.jts.geom."};

    public Class<Class> getValueType() {
        return Class.class;
    }

    public Class parse(String text) throws ConversionException {
        Class<?> type = null;
        for (String defaultPackageQualifier : DEFAULT_PACKAGE_QUALIFIERS) {
            try {
                type = this.getClass().getClassLoader().loadClass(defaultPackageQualifier + text);
                break;
            }
            catch (ClassNotFoundException e) {
            }
        }
        if (type == null) {
            throw new ConversionException(text);
        }
        return type;
    }

    public String format(Class javaType) {
        String name = javaType.getName();
        for (int i = 1; i < DEFAULT_PACKAGE_QUALIFIERS.length; ++i) {
            String defaultPackageQualifier = DEFAULT_PACKAGE_QUALIFIERS[i];
            if (!name.startsWith(defaultPackageQualifier)) continue;
            return name.substring(defaultPackageQualifier.length());
        }
        return name;
    }
}

