/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.util.converters;

import com.bc.ceres.binding.ConversionException;
import com.bc.ceres.binding.Converter;
import com.bc.ceres.binding.ConverterRegistry;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.io.ParseException;
import com.vividsolutions.jts.io.WKTReader;
import com.vividsolutions.jts.io.WKTWriter;

public class JtsGeometryConverter
implements Converter<Geometry> {
    public Class<? extends Geometry> getValueType() {
        return Geometry.class;
    }

    public Geometry parse(String text) throws ConversionException {
        if (text.isEmpty()) {
            return null;
        }
        try {
            return new WKTReader().read(text);
        }
        catch (ParseException e) {
            throw new ConversionException("Could not parse geometry.", (Throwable)e);
        }
    }

    public String format(Geometry value) {
        if (value == null) {
            return "";
        }
        return new WKTWriter().write(value);
    }

    public static void registerConverter() {
        JtsGeometryConverter geometryConverter = new JtsGeometryConverter();
        ConverterRegistry.getInstance().setConverter(Geometry.class, (Converter)geometryConverter);
        ConverterRegistry.getInstance().setConverter(Point.class, (Converter)geometryConverter);
        ConverterRegistry.getInstance().setConverter(MultiPoint.class, (Converter)geometryConverter);
        ConverterRegistry.getInstance().setConverter(LineString.class, (Converter)geometryConverter);
        ConverterRegistry.getInstance().setConverter(MultiLineString.class, (Converter)geometryConverter);
        ConverterRegistry.getInstance().setConverter(LinearRing.class, (Converter)geometryConverter);
        ConverterRegistry.getInstance().setConverter(Polygon.class, (Converter)geometryConverter);
        ConverterRegistry.getInstance().setConverter(MultiPolygon.class, (Converter)geometryConverter);
        ConverterRegistry.getInstance().setConverter(GeometryCollection.class, (Converter)geometryConverter);
    }
}

