/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.util.converters;

import com.bc.ceres.binding.ConversionException;
import com.bc.ceres.binding.Converter;
import java.awt.Rectangle;
import org.esa.beam.util.StringUtils;

public class RectangleConverter
implements Converter<Rectangle> {
    public Class<Rectangle> getValueType() {
        return Rectangle.class;
    }

    public Rectangle parse(String text) throws ConversionException {
        if (text == null || text.isEmpty() || !text.contains(",")) {
            throw new ConversionException("Invalid Rectangle '" + text + "' should be in form of x,y,width,height");
        }
        String[] s = StringUtils.csvToArray(text);
        if (s.length != 4) {
            throw new ConversionException("Invalid Rectangle '" + text + "' should be in form of x,y,width,height");
        }
        return new Rectangle(Integer.parseInt(s[0]), Integer.parseInt(s[1]), Integer.parseInt(s[2]), Integer.parseInt(s[3]));
    }

    public String format(Rectangle r) {
        if (r == null) {
            return "0,0,0,0";
        }
        return "" + r.x + ',' + r.y + ',' + r.width + ',' + r.height;
    }
}

