/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.util.io;

import com.jidesoft.plaf.LookAndFeelFactory;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.HeadlessException;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.filechooser.FileSystemView;
import org.esa.beam.util.Debug;
import org.esa.beam.util.io.BeamFileFilter;
import org.esa.beam.util.io.FileUtils;

public class BeamFileChooser
extends JFileChooser {
    private String lastFilename;
    private Rectangle dialogBounds;
    private ResizeHandler resizeHandler;

    public BeamFileChooser() {
        this.init();
    }

    public BeamFileChooser(FileSystemView fsv) {
        super(fsv);
        this.init();
    }

    public BeamFileChooser(File currentDirectory) {
        super(currentDirectory);
        this.init();
    }

    public BeamFileChooser(File currentDirectory, FileSystemView fsv) {
        super(currentDirectory, fsv);
        this.init();
    }

    @Override
    public Icon getIcon(File f) {
        Icon icon = super.getIcon(f);
        if (f.isDirectory() && this.isCompoundDocument(f)) {
            return new CompoundDocumentIcon(icon);
        }
        return icon;
    }

    @Override
    public boolean isTraversable(File f) {
        return f.isDirectory() && !this.isCompoundDocument(f);
    }

    @Override
    protected JDialog createDialog(Component parent) throws HeadlessException {
        JDialog dialog = super.createDialog(parent);
        dialog.addComponentListener(this.resizeHandler);
        if (this.dialogBounds != null) {
            dialog.setBounds(this.dialogBounds);
        }
        return dialog;
    }

    @Override
    public void approveSelection() {
        Debug.trace("BeamFileChooser: approveSelection(): selectedFile = " + this.getSelectedFile());
        Debug.trace("BeamFileChooser: approveSelection(): currentFilename = " + this.getCurrentFilename());
        Debug.trace("BeamFileChooser: approveSelection(): currentDirectory = " + this.getCurrentDirectory());
        if (this.getDialogType() != 0) {
            this.ensureSelectedFileHasValidExtension();
        }
        super.approveSelection();
    }

    public Rectangle getDialogBounds() {
        return this.dialogBounds;
    }

    public void setDialogBounds(Rectangle dialogBounds) {
        this.dialogBounds = dialogBounds;
    }

    public String getCurrentFilename() {
        File selectedFile = this.getSelectedFile();
        if (selectedFile != null) {
            return selectedFile.getName();
        }
        return null;
    }

    public void setCurrentFilename(String currentFilename) {
        Debug.trace("BeamFileChooser: setCurrentFilename(\"" + currentFilename + "\")");
        String defaultExtension = this.getDefaultExtension();
        if (this.getDialogType() != 0 && currentFilename != null && defaultExtension != null) {
            FileNameExtensionFilter filter;
            FileFilter fileFilter = this.getFileFilter();
            if (fileFilter instanceof BeamFileFilter) {
                BeamFileFilter filter2 = (BeamFileFilter)fileFilter;
                if (!filter2.checkExtension(currentFilename)) {
                    currentFilename = FileUtils.exchangeExtension(currentFilename, defaultExtension);
                }
            } else if (fileFilter instanceof FileNameExtensionFilter && !BeamFileFilter.checkExtensions(currentFilename, (filter = (FileNameExtensionFilter)fileFilter).getExtensions())) {
                currentFilename = FileUtils.exchangeExtension(currentFilename, defaultExtension);
            }
        }
        if (currentFilename != null && currentFilename.length() > 0) {
            this.setSelectedFile(new File(currentFilename));
        }
    }

    public BeamFileFilter getBeamFileFilter() {
        FileFilter ff = this.getFileFilter();
        if (ff instanceof BeamFileFilter) {
            return (BeamFileFilter)ff;
        }
        return null;
    }

    public String getDefaultExtension() {
        if (this.getBeamFileFilter() != null) {
            return this.getBeamFileFilter().getDefaultExtension();
        }
        return null;
    }

    public boolean checkExtension(String filename) {
        FileFilter[] fileFilters;
        if (filename != null && (fileFilters = this.getChoosableFileFilters()) != null) {
            for (FileFilter filter : fileFilters) {
                BeamFileFilter beamFileFilter;
                if (!(filter instanceof BeamFileFilter) || !(beamFileFilter = (BeamFileFilter)filter).checkExtension(filename)) continue;
                return true;
            }
        }
        return false;
    }

    protected Window getWindow() {
        Container w = this;
        while (!(w instanceof Window)) {
            w = w.getParent();
        }
        return (Window)w;
    }

    @Override
    public void updateUI() {
        LookAndFeel old = UIManager.getLookAndFeel();
        if (old.toString().contains("WebLookAndFeel")) {
            int oldJideStyle = LookAndFeelFactory.getStyle();
            try {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
            catch (Throwable ex) {
                old = null;
            }
            super.updateUI();
            if (old != null) {
                try {
                    UIManager.setLookAndFeel(old);
                    LookAndFeelFactory.installJideExtension((int)oldJideStyle);
                }
                catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {}
            }
        } else {
            super.updateUI();
        }
    }

    private void init() {
        this.resizeHandler = new ResizeHandler();
        this.setAcceptAllFileFilterUsed(false);
        this.addPropertyChangeListener("SelectedFileChangedProperty", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Object newValue = evt.getNewValue();
                if (newValue instanceof File) {
                    BeamFileChooser.this.lastFilename = ((File)newValue).getName();
                }
            }
        });
        this.addPropertyChangeListener("fileFilterChanged", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                BeamFileFilter beamFileFilter = BeamFileChooser.this.getBeamFileFilter();
                if (beamFileFilter != null) {
                    BeamFileChooser.this.setFileSelectionMode(beamFileFilter.getFileSelectionMode().getValue());
                } else {
                    BeamFileChooser.this.setFileSelectionMode(0);
                }
                if (BeamFileChooser.this.getSelectedFile() != null) {
                    return;
                }
                if (BeamFileChooser.this.lastFilename == null || BeamFileChooser.this.lastFilename.length() == 0) {
                    return;
                }
                BeamFileChooser.this.setCurrentFilename(BeamFileChooser.this.lastFilename);
            }
        });
    }

    private boolean isCompoundDocument(File file) {
        FileFilter[] filters;
        for (FileFilter fileFilter : filters = this.getChoosableFileFilters()) {
            BeamFileFilter beamFileFilter;
            if (!(fileFilter instanceof BeamFileFilter) || !(beamFileFilter = (BeamFileFilter)fileFilter).isCompoundDocument(file)) continue;
            return true;
        }
        return false;
    }

    private void ensureSelectedFileHasValidExtension() {
        BeamFileFilter mff;
        File selectedFile = this.getSelectedFile();
        if (selectedFile != null && (mff = this.getBeamFileFilter()) != null && mff.getDefaultExtension() != null && !mff.checkExtension(selectedFile)) {
            selectedFile = FileUtils.exchangeExtension(selectedFile, mff.getDefaultExtension());
            Debug.trace("mod. selected file: " + selectedFile.getPath());
            this.setSelectedFile(selectedFile);
        }
    }

    private static class CompoundDocumentIcon
    implements Icon {
        private final Icon baseIcon;
        private static final Icon compoundDocumentIcon = new ImageIcon(CompoundDocumentIcon.class.getResource("CompoundDocument12.png"));

        public CompoundDocumentIcon(Icon baseIcon) {
            this.baseIcon = baseIcon;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            this.baseIcon.paintIcon(c, g, x, y);
            compoundDocumentIcon.paintIcon(c, g, x + this.baseIcon.getIconWidth() - compoundDocumentIcon.getIconWidth(), y + this.baseIcon.getIconHeight() - compoundDocumentIcon.getIconHeight());
        }

        @Override
        public int getIconWidth() {
            return this.baseIcon.getIconWidth();
        }

        @Override
        public int getIconHeight() {
            return this.baseIcon.getIconHeight();
        }
    }

    private class ResizeHandler
    extends ComponentAdapter {
        private ResizeHandler() {
        }

        @Override
        public void componentMoved(ComponentEvent e) {
            BeamFileChooser.this.setDialogBounds(e.getComponent().getBounds());
        }

        @Override
        public void componentResized(ComponentEvent e) {
            BeamFileChooser.this.setDialogBounds(e.getComponent().getBounds());
        }
    }
}

