/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.util.io;

import java.io.IOException;
import java.io.Writer;

public class CsvWriter
extends Writer {
    private Writer out;
    private String separator;

    public CsvWriter(Writer out, String separator) {
        this.out = out;
        this.separator = separator;
    }

    public void writeRecord(String ... values) throws IOException {
        for (int i = 0; i < values.length; ++i) {
            String value = values[i];
            if (i > 0) {
                this.write(this.separator);
            }
            this.write(value);
        }
        this.write("\n");
    }

    public void writeRecord(double ... values) throws IOException {
        for (int i = 0; i < values.length; ++i) {
            double value = values[i];
            if (i > 0) {
                this.write(this.separator);
            }
            this.write(Double.toString(value));
        }
        this.write("\n");
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        this.out.write(cbuf, off, len);
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }
}

